/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeDefinition;
import karate.org.thymeleaf.engine.AttributeDefinitions;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.engine.IAttributeDefinitionsAware;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import karate.org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import karate.org.thymeleaf.standard.util.StandardProcessorUtils;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EscapedAttributeUtils;
import karate.org.thymeleaf.util.Validate;

public abstract class AbstractStandardAttributeModifierTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    private final boolean removeIfEmpty;
    private final String targetAttrCompleteName;
    private AttributeDefinition targetAttributeDefinition;

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean removeIfEmpty) {
        this(templateMode, dialectPrefix, attrName, attrName, precedence, removeIfEmpty);
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean removeIfEmpty, boolean restrictedExpressionExecution) {
        this(templateMode, dialectPrefix, attrName, attrName, precedence, removeIfEmpty, restrictedExpressionExecution);
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, int precedence, boolean removeIfEmpty, StandardExpressionExecutionContext expressionExecutionContext) {
        this(templateMode, dialectPrefix, attrName, attrName, precedence, removeIfEmpty, expressionExecutionContext);
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, String targetAttrCompleteName, int precedence, boolean removeIfEmpty) {
        super(templateMode, dialectPrefix, attrName, precedence, false);
        Validate.notNull(targetAttrCompleteName, "Complete name of target attribute cannot be null");
        this.targetAttrCompleteName = targetAttrCompleteName;
        this.removeIfEmpty = removeIfEmpty;
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, String targetAttrCompleteName, int precedence, boolean removeIfEmpty, boolean restrictedExpressionExecution) {
        super(templateMode, dialectPrefix, attrName, precedence, false, restrictedExpressionExecution);
        Validate.notNull(targetAttrCompleteName, "Complete name of target attribute cannot be null");
        this.targetAttrCompleteName = targetAttrCompleteName;
        this.removeIfEmpty = removeIfEmpty;
    }

    protected AbstractStandardAttributeModifierTagProcessor(TemplateMode templateMode, String dialectPrefix, String attrName, String targetAttrCompleteName, int precedence, boolean removeIfEmpty, StandardExpressionExecutionContext expressionExecutionContext) {
        super(templateMode, dialectPrefix, attrName, precedence, false, expressionExecutionContext);
        Validate.notNull(targetAttrCompleteName, "Complete name of target attribute cannot be null");
        this.targetAttrCompleteName = targetAttrCompleteName;
        this.removeIfEmpty = removeIfEmpty;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(this.getTemplateMode(), this.targetAttrCompleteName);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = EscapedAttributeUtils.escapeAttribute(this.getTemplateMode(), expressionResult == null ? null : expressionResult.toString());
        if (this.removeIfEmpty && (newAttributeValue == null || newAttributeValue.length() == 0)) {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
            structureHandler.removeAttribute(attributeName);
        } else {
            StandardProcessorUtils.replaceAttribute(structureHandler, attributeName, this.targetAttributeDefinition, this.targetAttrCompleteName, newAttributeValue == null ? "" : newAttributeValue);
        }
    }
}

