/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.standard.expression.EqualsExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.standard.expression.IStandardExpressionParser;
import karate.org.thymeleaf.standard.expression.StandardExpressions;
import karate.org.thymeleaf.standard.processor.AbstractStandardConditionalVisibilityTagProcessor;
import karate.org.thymeleaf.standard.processor.StandardSwitchTagProcessor;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EvaluationUtils;
import karate.org.thymeleaf.util.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardCaseTagProcessor
extends AbstractStandardConditionalVisibilityTagProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int PRECEDENCE = 275;
    public static final String ATTR_NAME = "case";
    public static final String CASE_DEFAULT_ATTRIBUTE_VALUE = "*";

    public StandardCaseTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, ATTR_NAME, 275);
    }

    @Override
    protected boolean isVisible(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        StandardSwitchTagProcessor.SwitchStructure switchStructure = (StandardSwitchTagProcessor.SwitchStructure)context.getVariable("%%SWITCH_EXPR%%");
        if (switchStructure == null) {
            throw new TemplateProcessingException("Cannot specify a \"" + attributeName + "\" attribute in an environment where no switch operator has been defined before.");
        }
        if (switchStructure.isExecuted()) {
            return false;
        }
        if (attributeValue != null && attributeValue.trim().equals(CASE_DEFAULT_ATTRIBUTE_VALUE)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[THYMELEAF][{}][{}] Case expression \"{}\" in attribute \"{}\" has been evaluated as: \"{}\"", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(context.getTemplateData().getTemplate()), attributeValue, attributeName, attributeValue, Boolean.TRUE});
            }
            switchStructure.setExecuted(true);
            return true;
        }
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(context.getConfiguration());
        IStandardExpression caseExpression = expressionParser.parseExpression(context, attributeValue);
        EqualsExpression equalsExpression = new EqualsExpression(switchStructure.getExpression(), caseExpression);
        Object value = equalsExpression.execute(context);
        boolean visible = EvaluationUtils.evaluateAsBoolean(value);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[THYMELEAF][{}][{}] Case expression \"{}\" in attribute \"{}\" has been evaluated as: \"{}\"", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(context.getTemplateData().getTemplate()), attributeValue, attributeName, attributeValue, visible});
        }
        if (visible) {
            switchStructure.setExecuted(true);
        }
        return visible;
    }
}

