/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.TemplateManager;
import karate.org.thymeleaf.engine.TemplateModel;
import karate.org.thymeleaf.model.IComment;
import karate.org.thymeleaf.processor.comment.AbstractCommentProcessor;
import karate.org.thymeleaf.processor.comment.ICommentStructureHandler;
import karate.org.thymeleaf.standard.util.StandardConditionalCommentUtils;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.FastStringWriter;

public final class StandardConditionalCommentProcessor
extends AbstractCommentProcessor {
    public static final int PRECEDENCE = 1100;

    public StandardConditionalCommentProcessor() {
        super(TemplateMode.HTML, 1100);
    }

    @Override
    protected void doProcess(ITemplateContext context, IComment comment, ICommentStructureHandler structureHandler) {
        StandardConditionalCommentUtils.ConditionalCommentParsingResult parsingResult = StandardConditionalCommentUtils.parseConditionalComment(comment);
        if (parsingResult == null) {
            return;
        }
        String commentStr = comment.getComment();
        TemplateManager templateManager = context.getConfiguration().getTemplateManager();
        String parsableContent = commentStr.substring(parsingResult.getContentOffset(), parsingResult.getContentOffset() + parsingResult.getContentLen());
        TemplateModel templateModel = templateManager.parseString(context.getTemplateData(), parsableContent, comment.getLine(), comment.getCol(), null, true);
        FastStringWriter writer = new FastStringWriter(200);
        writer.write("[");
        writer.write(commentStr, parsingResult.getStartExpressionOffset(), parsingResult.getStartExpressionLen());
        writer.write("]>");
        templateManager.process(templateModel, context, writer);
        writer.write("<![");
        writer.write(commentStr, parsingResult.getEndExpressionOffset(), parsingResult.getEndExpressionLen());
        writer.write("]");
        structureHandler.setContent(writer.toString());
    }
}

