/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeDefinition;
import karate.org.thymeleaf.engine.AttributeDefinitions;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.engine.IAttributeDefinitionsAware;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import karate.org.thymeleaf.standard.util.StandardProcessorUtils;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.EvaluationUtils;
import karate.org.thymeleaf.util.Validate;

public final class StandardConditionalFixedValueTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int PRECEDENCE = 1000;
    public static final String[] ATTR_NAMES = new String[]{"async", "autofocus", "autoplay", "checked", "controls", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "ismap", "loop", "multiple", "novalidate", "nowrap", "open", "pubdate", "readonly", "required", "reversed", "selected", "scoped", "seamless"};
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private final String targetAttributeCompleteName;
    private AttributeDefinition targetAttributeDefinition;

    public StandardConditionalFixedValueTagProcessor(String dialectPrefix, String attrName) {
        super(TEMPLATE_MODE, dialectPrefix, attrName, 1000, true, false);
        this.targetAttributeCompleteName = attrName;
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, this.targetAttributeCompleteName);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        if (EvaluationUtils.evaluateAsBoolean(expressionResult)) {
            StandardProcessorUtils.setAttribute(structureHandler, this.targetAttributeDefinition, this.targetAttributeCompleteName, this.targetAttributeCompleteName);
        } else {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
        }
    }
}

