/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.AttributeName;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.model.IProcessableElementTag;
import karate.org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import karate.org.thymeleaf.processor.element.IElementTagStructureHandler;
import karate.org.thymeleaf.standard.expression.Each;
import karate.org.thymeleaf.standard.expression.EachUtils;
import karate.org.thymeleaf.standard.expression.IStandardExpression;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.StringUtils;

public final class StandardEachTagProcessor
extends AbstractAttributeTagProcessor {
    public static final int PRECEDENCE = 200;
    public static final String ATTR_NAME = "each";

    public StandardEachTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, null, false, ATTR_NAME, true, 200, true);
    }

    @Override
    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, IElementTagStructureHandler structureHandler) {
        String statusVarName;
        String iterVarName;
        Each each = EachUtils.parseEach(context, attributeValue);
        IStandardExpression iterVarExpr = each.getIterVar();
        Object iterVarValue = iterVarExpr.execute(context);
        IStandardExpression statusVarExpr = each.getStatusVar();
        Object statusVarValue = statusVarExpr != null ? statusVarExpr.execute(context) : null;
        IStandardExpression iterableExpr = each.getIterable();
        Object iteratedValue = iterableExpr.execute(context);
        String string = iterVarName = iterVarValue == null ? null : iterVarValue.toString();
        if (StringUtils.isEmptyOrWhitespace(iterVarName)) {
            throw new TemplateProcessingException("Iteration variable name expression evaluated as null: \"" + iterVarExpr + "\"");
        }
        String string2 = statusVarName = statusVarValue == null ? null : statusVarValue.toString();
        if (statusVarExpr != null && StringUtils.isEmptyOrWhitespace(statusVarName)) {
            throw new TemplateProcessingException("Status variable name expression evaluated as null or empty: \"" + statusVarExpr + "\"");
        }
        structureHandler.iterateElement(iterVarName, statusVarName, iteratedValue);
    }
}

