/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.inline.IInliner;
import karate.org.thymeleaf.inline.NoOpInliner;
import karate.org.thymeleaf.standard.inline.StandardInlineMode;
import karate.org.thymeleaf.standard.inline.StandardTextInliner;
import karate.org.thymeleaf.standard.inline.StandardXMLInliner;
import karate.org.thymeleaf.standard.processor.AbstractStandardTextInlineSettingTagProcessor;
import karate.org.thymeleaf.templatemode.TemplateMode;

public final class StandardInlineXMLTagProcessor
extends AbstractStandardTextInlineSettingTagProcessor {
    public static final int PRECEDENCE = 1000;
    public static final String ATTR_NAME = "inline";

    public StandardInlineXMLTagProcessor(String dialectPrefix) {
        super(TemplateMode.XML, dialectPrefix, ATTR_NAME, 1000);
    }

    @Override
    protected IInliner getInliner(ITemplateContext context, StandardInlineMode inlineMode) {
        switch (inlineMode) {
            case NONE: {
                return NoOpInliner.INSTANCE;
            }
            case XML: {
                return new StandardXMLInliner(context.getConfiguration());
            }
            case TEXT: {
                return new StandardTextInliner(context.getConfiguration());
            }
        }
        throw new TemplateProcessingException("Invalid inline mode selected: " + (Object)((Object)inlineMode) + ". Allowed inline modes in template mode " + (Object)((Object)this.getTemplateMode()) + " are: \"" + (Object)((Object)StandardInlineMode.XML) + "\", \"" + (Object)((Object)StandardInlineMode.TEXT) + "\", \"" + (Object)((Object)StandardInlineMode.NONE) + "\"");
    }
}

