/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.standard.processor;

import karate.org.thymeleaf.context.ITemplateContext;
import karate.org.thymeleaf.engine.EngineEventUtils;
import karate.org.thymeleaf.inline.IInliner;
import karate.org.thymeleaf.inline.NoOpInliner;
import karate.org.thymeleaf.model.IText;
import karate.org.thymeleaf.processor.text.AbstractTextProcessor;
import karate.org.thymeleaf.processor.text.ITextStructureHandler;
import karate.org.thymeleaf.templatemode.TemplateMode;

public final class StandardInliningTextProcessor
extends AbstractTextProcessor {
    public static final int PRECEDENCE = 1000;

    public StandardInliningTextProcessor(TemplateMode templateMode) {
        super(templateMode, 1000);
    }

    @Override
    protected void doProcess(ITemplateContext context, IText text, ITextStructureHandler structureHandler) {
        if (EngineEventUtils.isWhitespace(text)) {
            return;
        }
        IInliner inliner = context.getInliner();
        if (inliner == null || inliner == NoOpInliner.INSTANCE) {
            return;
        }
        CharSequence inlined = inliner.inline(context, text);
        if (inlined != null && inlined != text) {
            structureHandler.setText(inlined);
        }
    }
}

