/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateparser.markup;

import java.util.concurrent.ConcurrentHashMap;
import karate.org.attoparser.select.IMarkupSelectorReferenceResolver;
import karate.org.thymeleaf.util.Validate;

final class TemplateFragmentMarkupReferenceResolver
implements IMarkupSelectorReferenceResolver {
    private static final TemplateFragmentMarkupReferenceResolver HTML_INSTANCE_NO_PREFIX = new TemplateFragmentMarkupReferenceResolver(true, null);
    private static final ConcurrentHashMap<String, TemplateFragmentMarkupReferenceResolver> HTML_INSTANCES_BY_PREFIX;
    private static final TemplateFragmentMarkupReferenceResolver XML_INSTANCE_NO_PREFIX;
    private static final ConcurrentHashMap<String, TemplateFragmentMarkupReferenceResolver> XML_INSTANCES_BY_PREFIX;
    private static final String HTML_FORMAT_WITHOUT_PREFIX = "/[ref='%1$s' or data-ref='%1$s' or fragment='%1$s' or data-fragment='%1$s' or fragment^='%1$s(' or data-fragment^='%1$s(' or fragment^='%1$s (' or data-fragment^='%1$s (']";
    private static final String HTML_FORMAT_WITH_PREFIX = "/[%1$s:ref='%%1$s' or data-%1$s-ref='%%1$s' or %1$s:fragment='%%1$s' or data-%1$s-fragment='%%1$s' or %1$s:fragment^='%%1$s(' or data-%1$s-fragment^='%%1$s(' or %1$s:fragment^='%%1$s (' or data-%1$s-fragment^='%%1$s (']";
    private static final String XML_FORMAT_WITHOUT_PREFIX = "/[ref='%1$s' or fragment='%1$s' or fragment^='%1$s(' or fragment^='%1$s (']";
    private static final String XML_FORMAT_WITH_PREFIX = "/[%1$s:ref='%%1$s' or %1$s:fragment='%%1$s' or %1$s:fragment^='%%1$s(' or %1$s:fragment^='%%1$s (']";
    private final ConcurrentHashMap<String, String> selectorsByReference = new ConcurrentHashMap(20);
    private final String resolverFormat;

    static TemplateFragmentMarkupReferenceResolver forPrefix(boolean html, String standardDialectPrefix) {
        return html ? TemplateFragmentMarkupReferenceResolver.forHTMLPrefix(standardDialectPrefix) : TemplateFragmentMarkupReferenceResolver.forXMLPrefix(standardDialectPrefix);
    }

    private static TemplateFragmentMarkupReferenceResolver forHTMLPrefix(String standardDialectPrefix) {
        if (standardDialectPrefix == null || standardDialectPrefix.length() == 0) {
            return HTML_INSTANCE_NO_PREFIX;
        }
        String prefix = standardDialectPrefix.toLowerCase();
        TemplateFragmentMarkupReferenceResolver resolver = HTML_INSTANCES_BY_PREFIX.get(prefix);
        if (resolver != null) {
            return resolver;
        }
        TemplateFragmentMarkupReferenceResolver newResolver = new TemplateFragmentMarkupReferenceResolver(true, prefix);
        HTML_INSTANCES_BY_PREFIX.putIfAbsent(prefix, newResolver);
        return HTML_INSTANCES_BY_PREFIX.get(prefix);
    }

    private static TemplateFragmentMarkupReferenceResolver forXMLPrefix(String standardDialectPrefix) {
        if (standardDialectPrefix == null || standardDialectPrefix.length() == 0) {
            return XML_INSTANCE_NO_PREFIX;
        }
        TemplateFragmentMarkupReferenceResolver resolver = XML_INSTANCES_BY_PREFIX.get(standardDialectPrefix);
        if (resolver != null) {
            return resolver;
        }
        TemplateFragmentMarkupReferenceResolver newResolver = new TemplateFragmentMarkupReferenceResolver(false, standardDialectPrefix);
        XML_INSTANCES_BY_PREFIX.putIfAbsent(standardDialectPrefix, newResolver);
        return XML_INSTANCES_BY_PREFIX.get(standardDialectPrefix);
    }

    private TemplateFragmentMarkupReferenceResolver(boolean html, String standardDialectPrefix) {
        this.resolverFormat = standardDialectPrefix == null ? (html ? HTML_FORMAT_WITHOUT_PREFIX : XML_FORMAT_WITHOUT_PREFIX) : (html ? String.format(HTML_FORMAT_WITH_PREFIX, standardDialectPrefix) : String.format(XML_FORMAT_WITH_PREFIX, standardDialectPrefix));
    }

    @Override
    public String resolveSelectorFromReference(String reference) {
        Validate.notNull(reference, "Reference cannot be null");
        String selector = this.selectorsByReference.get(reference);
        if (selector != null) {
            return selector;
        }
        String newSelector = String.format(this.resolverFormat, reference);
        this.selectorsByReference.put(reference, newSelector);
        return newSelector;
    }

    static {
        XML_INSTANCE_NO_PREFIX = new TemplateFragmentMarkupReferenceResolver(false, null);
        HTML_INSTANCES_BY_PREFIX = new ConcurrentHashMap(3, 0.9f, 2);
        XML_INSTANCES_BY_PREFIX = new ConcurrentHashMap(3, 0.9f, 2);
    }
}

