/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateparser.markup.decoupled;

import java.io.IOException;
import java.util.Set;
import karate.org.attoparser.IMarkupHandler;
import karate.org.attoparser.IMarkupParser;
import karate.org.attoparser.ParseException;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.TemplateEngine;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogic;
import karate.org.thymeleaf.templateparser.markup.decoupled.DecoupledTemplateLogicBuilderMarkupHandler;
import karate.org.thymeleaf.templateparser.markup.decoupled.IDecoupledTemplateLogicResolver;
import karate.org.thymeleaf.templateresource.ITemplateResource;
import karate.org.thymeleaf.util.LoggingUtils;
import karate.org.thymeleaf.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DecoupledTemplateLogicUtils {
    private static final Logger logger = LoggerFactory.getLogger(DecoupledTemplateLogicUtils.class);

    public static DecoupledTemplateLogic computeDecoupledTemplateLogic(IEngineConfiguration configuration, String ownerTemplate, String template, Set<String> templateSelectors, ITemplateResource resource, TemplateMode templateMode, IMarkupParser parser) throws IOException, ParseException {
        Validate.notNull(configuration, "Engine Configuration cannot be null");
        Validate.notNull(template, "Template cannot be null");
        Validate.notNull(resource, "Template Resource cannot be null");
        Validate.notNull((Object)templateMode, "Template Mode cannot be null");
        IDecoupledTemplateLogicResolver decoupledTemplateLogicResolver = configuration.getDecoupledTemplateLogicResolver();
        ITemplateResource decoupledResource = decoupledTemplateLogicResolver.resolveDecoupledTemplateLogic(configuration, ownerTemplate, template, templateSelectors, resource, templateMode);
        if (!decoupledResource.exists()) {
            if (logger.isTraceEnabled()) {
                logger.trace("[THYMELEAF][{}] Decoupled logic for template \"{}\" could not be resolved as relative resource \"{}\". This does not need to be an error, as templates may lack a corresponding decoupled logic file.", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(template), decoupledResource.getDescription()});
            }
            return null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Decoupled logic for template \"{}\" has been resolved as relative resource \"{}\"", new Object[]{TemplateEngine.threadIndex(), LoggingUtils.loggifyTemplateName(template), decoupledResource.getDescription()});
        }
        DecoupledTemplateLogicBuilderMarkupHandler decoupledMarkupHandler = new DecoupledTemplateLogicBuilderMarkupHandler(template, templateMode);
        parser.parse(decoupledResource.reader(), (IMarkupHandler)decoupledMarkupHandler);
        return decoupledMarkupHandler.getDecoupledTemplateLogic();
    }

    private DecoupledTemplateLogicUtils() {
    }
}

