/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateparser.text;

import java.util.Arrays;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateparser.text.AbstractChainedTextHandler;
import karate.org.thymeleaf.templateparser.text.ITextHandler;
import karate.org.thymeleaf.templateparser.text.TextParseException;
import karate.org.thymeleaf.util.TextUtils;

final class EventProcessorTextHandler
extends AbstractChainedTextHandler {
    private static final int DEFAULT_STACK_LEN = 10;
    private static final int DEFAULT_ATTRIBUTE_NAMES_LEN = 3;
    private StructureNamesRepository structureNamesRepository;
    private char[][] elementStack = new char[10][];
    private int elementStackSize = 0;
    private char[][] currentElementAttributeNames = null;
    private int currentElementAttributeNamesSize = 0;

    EventProcessorTextHandler(ITextHandler handler) {
        super(handler);
        this.structureNamesRepository = new StructureNamesRepository();
    }

    @Override
    public void handleDocumentEnd(long endTimeNanos, long totalTimeNanos, int line, int col) throws TextParseException {
        if (this.elementStackSize > 0) {
            char[] popped = this.popFromStack();
            throw new TextParseException("Malformed template: element \"" + new String(popped, 0, popped.length) + "\" is never closed (no closing tag at the end of document)");
        }
        super.handleDocumentEnd(endTimeNanos, totalTimeNanos, line, col);
    }

    @Override
    public void handleStandaloneElementStart(char[] buffer, int nameOffset, int nameLen, boolean minimized, int line, int col) throws TextParseException {
        this.currentElementAttributeNames = null;
        this.currentElementAttributeNamesSize = 0;
        super.handleStandaloneElementStart(buffer, nameOffset, nameLen, minimized, line, col);
    }

    @Override
    public void handleOpenElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        this.currentElementAttributeNames = null;
        this.currentElementAttributeNamesSize = 0;
        super.handleOpenElementStart(buffer, nameOffset, nameLen, line, col);
        this.pushToStack(buffer, nameOffset, nameLen);
    }

    @Override
    public void handleCloseElementStart(char[] buffer, int nameOffset, int nameLen, int line, int col) throws TextParseException {
        if (!this.checkStackForElement(buffer, nameOffset, nameLen, line, col)) {
            throw new TextParseException("Malformed text: element \"" + new String(buffer, nameOffset, nameLen) + "\" is never closed", line, col);
        }
        this.currentElementAttributeNames = null;
        this.currentElementAttributeNamesSize = 0;
        super.handleCloseElementStart(buffer, nameOffset, nameLen, line, col);
    }

    @Override
    public void handleAttribute(char[] buffer, int nameOffset, int nameLen, int nameLine, int nameCol, int operatorOffset, int operatorLen, int operatorLine, int operatorCol, int valueContentOffset, int valueContentLen, int valueOuterOffset, int valueOuterLen, int valueLine, int valueCol) throws TextParseException {
        if (this.currentElementAttributeNames == null) {
            this.currentElementAttributeNames = new char[3][];
        }
        for (int i = 0; i < this.currentElementAttributeNamesSize; ++i) {
            if (!TextUtils.equals(TemplateMode.TEXT.isCaseSensitive(), this.currentElementAttributeNames[i], 0, this.currentElementAttributeNames[i].length, buffer, nameOffset, nameLen)) continue;
            throw new TextParseException("Malformed text: Attribute \"" + new String(buffer, nameOffset, nameLen) + "\" appears more than once in element", nameLine, nameCol);
        }
        if (this.currentElementAttributeNamesSize == this.currentElementAttributeNames.length) {
            char[][] newCurrentElementAttributeNames = new char[this.currentElementAttributeNames.length + 3][];
            System.arraycopy(this.currentElementAttributeNames, 0, newCurrentElementAttributeNames, 0, this.currentElementAttributeNames.length);
            this.currentElementAttributeNames = newCurrentElementAttributeNames;
        }
        this.currentElementAttributeNames[this.currentElementAttributeNamesSize] = this.structureNamesRepository.getStructureName(buffer, nameOffset, nameLen);
        ++this.currentElementAttributeNamesSize;
        super.handleAttribute(buffer, nameOffset, nameLen, nameLine, nameCol, operatorOffset, operatorLen, operatorLine, operatorCol, valueContentOffset, valueContentLen, valueOuterOffset, valueOuterLen, valueLine, valueCol);
    }

    private boolean checkStackForElement(char[] buffer, int offset, int len, int line, int col) throws TextParseException {
        char[] peek = this.peekFromStack();
        if (peek != null) {
            if (TextUtils.equals(TemplateMode.TEXT.isCaseSensitive(), peek, 0, peek.length, buffer, offset, len)) {
                this.popFromStack();
                return true;
            }
            throw new TextParseException("Malformed template: " + (peek.length > 0 ? "element \"" + new String(peek, 0, peek.length) + "\"" : "unnamed element") + " is never closed", line, col);
        }
        throw new TextParseException("Malformed template: unnamed closing element is never opened", line, col);
    }

    private void pushToStack(char[] buffer, int offset, int len) {
        if (this.elementStackSize == this.elementStack.length) {
            this.growStack();
        }
        this.elementStack[this.elementStackSize] = this.structureNamesRepository.getStructureName(buffer, offset, len);
        ++this.elementStackSize;
    }

    private char[] peekFromStack() {
        if (this.elementStackSize == 0) {
            return null;
        }
        return this.elementStack[this.elementStackSize - 1];
    }

    private char[] popFromStack() {
        if (this.elementStackSize == 0) {
            return null;
        }
        char[] popped = this.elementStack[this.elementStackSize - 1];
        this.elementStack[this.elementStackSize - 1] = null;
        --this.elementStackSize;
        return popped;
    }

    private void growStack() {
        int newStackLen = this.elementStack.length + 10;
        char[][] newStack = new char[newStackLen][];
        System.arraycopy(this.elementStack, 0, newStack, 0, this.elementStack.length);
        this.elementStack = newStack;
    }

    static final class StructureNamesRepository {
        private static final int REPOSITORY_INITIAL_LEN = 20;
        private static final int REPOSITORY_INITIAL_INC = 5;
        private char[][] repository = new char[20][];
        private int repositorySize = 0;

        StructureNamesRepository() {
        }

        char[] getStructureName(char[] text, int offset, int len) {
            int index = TextUtils.binarySearch(true, this.repository, 0, this.repositorySize, text, offset, len);
            if (index >= 0) {
                return this.repository[index];
            }
            return this.storeStructureName(index, text, offset, len);
        }

        private char[] storeStructureName(int index, char[] text, int offset, int len) {
            if (this.repositorySize == this.repository.length) {
                char[][] newRepository = new char[this.repository.length + 5][];
                Arrays.fill((Object[])newRepository, null);
                System.arraycopy(this.repository, 0, newRepository, 0, this.repositorySize);
                this.repository = newRepository;
            }
            int insertionIndex = (index + 1) * -1;
            char[] structureName = new char[len];
            System.arraycopy(text, offset, structureName, 0, len);
            System.arraycopy(this.repository, insertionIndex, this.repository, insertionIndex + 1, this.repositorySize - insertionIndex);
            this.repository[insertionIndex] = structureName;
            ++this.repositorySize;
            return structureName;
        }
    }
}

