/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateparser.text;

import karate.org.thymeleaf.templateparser.text.ITextHandler;
import karate.org.thymeleaf.templateparser.text.TextParseException;
import karate.org.thymeleaf.templateparser.text.TextParsingAttributeSequenceUtil;
import karate.org.thymeleaf.templateparser.text.TextParsingUtil;

final class TextParsingElementUtil {
    private TextParsingElementUtil() {
    }

    public static void parseStandaloneElement(char[] buffer, int offset, int len, int line, int col, ITextHandler handler) throws TextParseException {
        if (len < 4 || !TextParsingElementUtil.isOpenElementStart(buffer, offset, offset + len) || !TextParsingElementUtil.isElementEnd(buffer, offset + len - 2, offset + len, true)) {
            throw new TextParseException("Could not parse as a well-formed standalone element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 4;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler.handleStandaloneElementStart(buffer, contentOffset, contentLen, true, line, col);
            handler.handleStandaloneElementEnd(buffer, contentOffset, contentLen, true, locator[0], locator[1]);
            return;
        }
        handler.handleStandaloneElementStart(buffer, contentOffset, elementNameEnd - contentOffset, true, line, col);
        TextParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], handler);
        TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        handler.handleStandaloneElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, true, locator[0], locator[1]);
    }

    public static void parseOpenElement(char[] buffer, int offset, int len, int line, int col, ITextHandler handler) throws TextParseException {
        if (len < 3 || !TextParsingElementUtil.isOpenElementStart(buffer, offset, offset + len) || !TextParsingElementUtil.isElementEnd(buffer, offset + len - 1, offset + len, false)) {
            throw new TextParseException("Could not parse as a well-formed open element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler.handleOpenElementStart(buffer, contentOffset, contentLen, line, col);
            handler.handleOpenElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        handler.handleOpenElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        TextParsingAttributeSequenceUtil.parseAttributeSequence(buffer, elementNameEnd, maxi - elementNameEnd, locator[0], locator[1], handler);
        TextParsingUtil.findNextStructureEndAvoidQuotes(buffer, elementNameEnd, maxi, locator);
        handler.handleOpenElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    public static void parseCloseElement(char[] buffer, int offset, int len, int line, int col, ITextHandler handler) throws TextParseException {
        if (len < 3 || !TextParsingElementUtil.isCloseElementStart(buffer, offset, offset + len) || !TextParsingElementUtil.isElementEnd(buffer, offset + len - 1, offset + len, false)) {
            throw new TextParseException("Could not parse as a well-formed close element: \"" + new String(buffer, offset, len) + "\"", line, col);
        }
        int contentOffset = offset + 2;
        int contentLen = len - 3;
        int maxi = contentOffset + contentLen;
        int[] locator = new int[]{line, col + 2};
        int elementNameEnd = TextParsingUtil.findNextWhitespaceCharWildcard(buffer, contentOffset, maxi, true, locator);
        if (elementNameEnd == -1) {
            handler.handleCloseElementStart(buffer, contentOffset, contentLen, line, col);
            handler.handleCloseElementEnd(buffer, contentOffset, contentLen, locator[0], locator[1]);
            return;
        }
        handler.handleCloseElementStart(buffer, contentOffset, elementNameEnd - contentOffset, line, col);
        int wsEnd = TextParsingUtil.findNextNonWhitespaceCharWildcard(buffer, elementNameEnd, maxi, locator);
        if (wsEnd != -1) {
            throw new TextParseException("Could not parse as a well-formed closing element \"" + new String(buffer, offset, len) + "\": No attributes are allowed here", line, col);
        }
        handler.handleCloseElementEnd(buffer, contentOffset, elementNameEnd - contentOffset, locator[0], locator[1]);
    }

    static boolean isOpenElementStart(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        return len > 2 && buffer[offset] == '[' && buffer[offset + 1] == '#' && TextParsingElementUtil.isElementNameOrEnd(buffer, offset + 2, maxi);
    }

    static boolean isCloseElementStart(char[] buffer, int offset, int maxi) {
        int len = maxi - offset;
        return len > 2 && buffer[offset] == '[' && buffer[offset + 1] == '/' && TextParsingElementUtil.isElementNameOrEnd(buffer, offset + 2, maxi);
    }

    static boolean isElementEnd(char[] buffer, int offset, int maxi, boolean minimized) {
        int len = maxi - offset;
        if (len < 1) {
            return false;
        }
        if (minimized) {
            if (len < 2 || buffer[offset] != '/') {
                return false;
            }
            return buffer[offset + 1] == ']';
        }
        return buffer[offset] == ']';
    }

    private static boolean isElementNameOrEnd(char[] buffer, int offset, int maxi) {
        if (Character.isWhitespace(buffer[offset])) {
            return true;
        }
        int len = maxi - offset;
        if (len > 1 && buffer[offset] == '/') {
            return TextParsingElementUtil.isElementEnd(buffer, offset, maxi, true);
        }
        if (len > 0 && buffer[offset] == ']') {
            return TextParsingElementUtil.isElementEnd(buffer, offset, maxi, false);
        }
        return len > 0 && buffer[offset] != '-' && buffer[offset] != '!' && buffer[offset] != '/' && buffer[offset] != '?' && buffer[offset] != '[' && buffer[offset] != '{' && !Character.isWhitespace(buffer[offset]);
    }
}

