/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateparser.text;

import karate.org.thymeleaf.templateparser.text.ParsingLocatorUtil;

final class TextParsingUtil {
    private TextParsingUtil() {
    }

    static int findNextStructureEndAvoidQuotes(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (c == '\"' && !inApos) {
                inQuotes = !inQuotes;
            } else if (c == '\'' && !inQuotes) {
                inApos = !inApos;
            } else if (c == ']' && !inQuotes && !inApos) {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextCommentBlockEnd(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (i > offset && c == '/' && text[i - 1] == '*') {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextCommentLineEnd(char[] text, int offset, int maxi, int[] locator) {
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '\n') {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextLiteralEnd(char[] text, int offset, int maxi, int[] locator, char literalMarker) {
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else if (i > offset && c == literalMarker && TextParsingUtil.isLiteralDelimiter(text, offset, i)) {
                locator[1] = locator[1] + (i - colIndex);
                return i;
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    static int findNextStructureStartOrLiteralMarker(char[] text, int offset, int maxi, int[] locator, boolean processCommentsAndLiterals) {
        int colIndex = offset;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '\n') {
                colIndex = i;
                locator[1] = 0;
                locator[0] = locator[0] + 1;
            } else {
                if (c == '[') {
                    locator[1] = locator[1] + (i - colIndex);
                    return i;
                }
                if (processCommentsAndLiterals) {
                    if (c == '/') {
                        locator[1] = locator[1] + (i - colIndex);
                        return i;
                    }
                    if ((c == '\'' || c == '\"' || c == '`') && TextParsingUtil.isLiteralDelimiter(text, offset, i)) {
                        locator[1] = locator[1] + (i - colIndex);
                        return i;
                    }
                }
            }
            ++i;
        }
        locator[1] = locator[1] + (maxi - colIndex);
        return -1;
    }

    private static boolean isLiteralDelimiter(char[] text, int offset, int i) {
        int escapes = 0;
        int j = i - 1;
        while (j >= offset && text[j--] == '\\') {
            ++escapes;
        }
        return escapes % 2 == 0;
    }

    static int findNextWhitespaceCharWildcard(char[] text, int offset, int maxi, boolean avoidQuotes, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (avoidQuotes && !inApos && c == '\"') {
                inQuotes = !inQuotes;
            } else if (avoidQuotes && !inQuotes && c == '\'') {
                inApos = !inApos;
            } else if (!inQuotes && !inApos && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c))) {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i;
        }
        return -1;
    }

    static int findNextNonWhitespaceCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            boolean isWhitespace;
            char c = text[i];
            boolean bl = isWhitespace = c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c);
            if (!isWhitespace) {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i;
        }
        return -1;
    }

    static int findNextOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (c == '=' || c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c)) {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i;
        }
        return -1;
    }

    static int findNextNonOperatorCharWildcard(char[] text, int offset, int maxi, int[] locator) {
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (!(c == '=' || c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f' || c == '\u000b' || c == '\u001c' || c == '\u001d' || c == '\u001e' || c == '\u001f' || c > '\u007f' && Character.isWhitespace(c))) {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i;
        }
        return -1;
    }

    static int findNextAnyCharAvoidQuotesWildcard(char[] text, int offset, int maxi, int[] locator) {
        boolean inQuotes = false;
        boolean inApos = false;
        int i = offset;
        int n = maxi - offset;
        while (n-- != 0) {
            char c = text[i];
            if (!inApos && c == '\"') {
                if (inQuotes) {
                    ParsingLocatorUtil.countChar(locator, c);
                    return ++i < maxi ? i : -1;
                }
                inQuotes = true;
            } else if (!inQuotes && c == '\'') {
                if (inApos) {
                    ParsingLocatorUtil.countChar(locator, c);
                    return ++i < maxi ? i : -1;
                }
                inApos = true;
            } else if (!inQuotes && !inApos) {
                return i;
            }
            ParsingLocatorUtil.countChar(locator, c);
            ++i;
        }
        return -1;
    }
}

