/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateresolver;

import java.util.Map;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.cache.AlwaysValidCacheEntryValidity;
import karate.org.thymeleaf.cache.ICacheEntryValidity;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.templateresolver.AbstractTemplateResolver;
import karate.org.thymeleaf.templateresource.ITemplateResource;
import karate.org.thymeleaf.templateresource.StringTemplateResource;
import karate.org.thymeleaf.util.Validate;

public class DefaultTemplateResolver
extends AbstractTemplateResolver {
    public static final TemplateMode DEFAULT_TEMPLATE_MODE = TemplateMode.HTML;
    private TemplateMode templateMode = DEFAULT_TEMPLATE_MODE;
    private String template = "";

    public final TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    public final void setTemplateMode(TemplateMode templateMode) {
        Validate.notNull((Object)templateMode, "Cannot set a null template mode value");
        this.templateMode = templateMode;
    }

    public final void setTemplateMode(String templateMode) {
        Validate.notNull(templateMode, "Cannot set a null template mode value");
        this.templateMode = TemplateMode.parse(templateMode);
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return new StringTemplateResource(this.template);
    }

    @Override
    protected TemplateMode computeTemplateMode(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return this.templateMode;
    }

    @Override
    protected ICacheEntryValidity computeValidity(IEngineConfiguration configuration, String ownerTemplate, String template, Map<String, Object> templateResolutionAttributes) {
        return AlwaysValidCacheEntryValidity.INSTANCE;
    }
}

