/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateresource;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import karate.org.thymeleaf.exceptions.TemplateInputException;
import karate.org.thymeleaf.templateresource.ITemplateResource;
import karate.org.thymeleaf.util.Validate;

public final class StringTemplateResource
implements ITemplateResource {
    private final String resource;

    public StringTemplateResource(String resource) {
        Validate.notNull(resource, "Resource cannot be null or empty");
        this.resource = resource;
    }

    @Override
    public String getDescription() {
        return this.resource;
    }

    @Override
    public String getBaseName() {
        return null;
    }

    @Override
    public Reader reader() throws IOException {
        return new StringReader(this.resource);
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        throw new TemplateInputException(String.format("Cannot create a relative resource for String resource  \"%s\"", this.resource));
    }

    @Override
    public boolean exists() {
        return true;
    }
}

