/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import karate.org.thymeleaf.templateresource.ITemplateResource;
import karate.org.thymeleaf.templateresource.TemplateResourceUtils;
import karate.org.thymeleaf.util.StringUtils;
import karate.org.thymeleaf.util.Validate;
import karate.org.thymeleaf.web.IWebApplication;

public final class WebApplicationTemplateResource
implements ITemplateResource {
    private final IWebApplication webApplication;
    private final String path;
    private final String characterEncoding;

    public WebApplicationTemplateResource(IWebApplication webApplication, String path, String characterEncoding) {
        Validate.notNull(webApplication, "Web Application object cannot be null");
        Validate.notEmpty(path, "Resource Path cannot be null or empty");
        this.webApplication = webApplication;
        String cleanPath = TemplateResourceUtils.cleanPath(path);
        this.path = cleanPath.charAt(0) != '/' ? "/" + cleanPath : cleanPath;
        this.characterEncoding = characterEncoding;
    }

    @Override
    public String getDescription() {
        return this.path;
    }

    @Override
    public String getBaseName() {
        return TemplateResourceUtils.computeBaseName(this.path);
    }

    @Override
    public Reader reader() throws IOException {
        InputStream inputStream = this.webApplication.getResourceAsStream(this.path);
        if (inputStream == null) {
            throw new FileNotFoundException(String.format("Web Application resource \"%s\" does not exist", this.path));
        }
        if (!StringUtils.isEmptyOrWhitespace(this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    @Override
    public ITemplateResource relative(String relativeLocation) {
        Validate.notEmpty(relativeLocation, "Relative Path cannot be null or empty");
        String fullRelativeLocation = TemplateResourceUtils.computeRelativeLocation(this.path, relativeLocation);
        return new WebApplicationTemplateResource(this.webApplication, fullRelativeLocation, this.characterEncoding);
    }

    @Override
    public boolean exists() {
        return this.webApplication.resourceExists(this.path);
    }
}

