/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import karate.org.thymeleaf.standard.expression.LiteralValue;

public final class EvaluationUtils {
    public static boolean evaluateAsBoolean(Object condition) {
        String condStr;
        boolean result = true;
        result = condition == null ? false : (condition instanceof Boolean ? (Boolean)condition : (condition instanceof Number ? (condition instanceof BigDecimal ? ((BigDecimal)condition).compareTo(BigDecimal.ZERO) != 0 : (condition instanceof BigInteger ? !condition.equals(BigInteger.ZERO) : ((Number)condition).doubleValue() != 0.0)) : (condition instanceof Character ? ((Character)condition).charValue() != '\u0000' : (condition instanceof String ? !"false".equals(condStr = ((String)condition).trim().toLowerCase()) && !"off".equals(condStr) && !"no".equals(condStr) : (condition instanceof LiteralValue ? !"false".equals(condStr = ((LiteralValue)condition).getValue().trim().toLowerCase()) && !"off".equals(condStr) && !"no".equals(condStr) : true)))));
        return result;
    }

    public static BigDecimal evaluateAsNumber(Object object) {
        char c0;
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Byte) {
                return new BigDecimal(((Byte)object).intValue());
            }
            if (object instanceof Short) {
                return new BigDecimal(((Short)object).intValue());
            }
            if (object instanceof Integer) {
                return new BigDecimal((Integer)object);
            }
            if (object instanceof Long) {
                return new BigDecimal((Long)object);
            }
            if (object instanceof Float) {
                return new BigDecimal(((Float)object).doubleValue());
            }
            if (object instanceof Double) {
                return new BigDecimal((Double)object);
            }
        } else if (object instanceof String && ((String)object).length() > 0 && ((c0 = ((String)object).charAt(0)) >= '0' && c0 <= '9' || c0 == '+' || c0 == '-')) {
            try {
                return new BigDecimal(((String)object).trim());
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return null;
    }

    public static List<Object> evaluateAsList(Object value) {
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (value instanceof Iterable) {
            for (Object obj : (Iterable)value) {
                result.add(obj);
            }
        } else if (value instanceof Map) {
            for (Map.Entry obj : ((Map)value).entrySet()) {
                result.add(new MapEntry(obj.getKey(), obj.getValue()));
            }
        } else if (value.getClass().isArray()) {
            if (value instanceof byte[]) {
                for (byte obj : (byte[])value) {
                    result.add(obj);
                }
            } else if (value instanceof short[]) {
                for (short obj : (short[])value) {
                    result.add(obj);
                }
            } else if (value instanceof int[]) {
                for (int obj : (int[])value) {
                    result.add(obj);
                }
            } else if (value instanceof long[]) {
                for (long obj : (long[])value) {
                    result.add(obj);
                }
            } else if (value instanceof float[]) {
                for (float obj : (float[])value) {
                    result.add(Float.valueOf(obj));
                }
            } else if (value instanceof double[]) {
                for (double obj : (double[])value) {
                    result.add(obj);
                }
            } else if (value instanceof boolean[]) {
                for (boolean obj : (boolean[])value) {
                    result.add(obj);
                }
            } else if (value instanceof char[]) {
                for (char obj : (char[])value) {
                    result.add(Character.valueOf(obj));
                }
            } else {
                Object[] objValue = (Object[])value;
                Collections.addAll(result, objValue);
            }
        } else {
            result.add(value);
        }
        return Collections.unmodifiableList(result);
    }

    public static Object[] evaluateAsArray(Object value) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (value == null) {
            return new Object[]{null};
        }
        if (value instanceof Iterable) {
            for (Object obj : (Iterable)value) {
                result.add(obj);
            }
        } else if (value instanceof Map) {
            for (Map.Entry obj : ((Map)value).entrySet()) {
                result.add(obj);
            }
        } else {
            if (value.getClass().isArray()) {
                return (Object[])value;
            }
            result.add(value);
        }
        return result.toArray(new Object[result.size()]);
    }

    private EvaluationUtils() {
    }

    static final class MapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K entryKey;
        private final V entryValue;

        MapEntry(K key, V value) {
            this.entryKey = key;
            this.entryValue = value;
        }

        @Override
        public K getKey() {
            return this.entryKey;
        }

        @Override
        public V getValue() {
            return this.entryValue;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.entryKey + "=" + this.entryValue;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry mapEntry = (Map.Entry)o;
            if (this.entryKey != null ? !this.entryKey.equals(mapEntry.getKey()) : mapEntry.getKey() != null) {
                return false;
            }
            return !(this.entryValue != null ? !this.entryValue.equals(mapEntry.getValue()) : mapEntry.getValue() != null);
        }

        @Override
        public int hashCode() {
            int result = this.entryKey != null ? this.entryKey.hashCode() : 0;
            result = 31 * result + (this.entryValue != null ? this.entryValue.hashCode() : 0);
            return result;
        }
    }
}

