/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.util;

import java.io.IOException;
import java.io.Writer;
import karate.org.thymeleaf.IEngineConfiguration;
import karate.org.thymeleaf.exceptions.TemplateProcessingException;
import karate.org.thymeleaf.standard.serializer.IStandardCSSSerializer;
import karate.org.thymeleaf.standard.serializer.IStandardJavaScriptSerializer;
import karate.org.thymeleaf.standard.serializer.StandardSerializers;
import karate.org.thymeleaf.templatemode.TemplateMode;
import karate.org.thymeleaf.util.AbstractLazyCharSequence;
import karate.org.thymeleaf.util.FastStringWriter;
import karate.org.unbescape.html.HtmlEscape;
import karate.org.unbescape.xml.XmlEscape;

public final class LazyEscapingCharSequence
extends AbstractLazyCharSequence {
    private final IEngineConfiguration configuration;
    private final TemplateMode templateMode;
    private final Object input;

    public LazyEscapingCharSequence(IEngineConfiguration configuration, TemplateMode templateMode, Object input) {
        if (configuration == null) {
            throw new IllegalArgumentException("Engine Configuraion is null, which is forbidden");
        }
        if (templateMode == null) {
            throw new IllegalArgumentException("Template Mode is null, which is forbidden");
        }
        this.configuration = configuration;
        this.templateMode = templateMode;
        this.input = input;
    }

    @Override
    protected String resolveText() {
        FastStringWriter stringWriter = new FastStringWriter();
        this.produceEscapedOutput(stringWriter);
        return ((Object)stringWriter).toString();
    }

    @Override
    protected void writeUnresolved(Writer writer) throws IOException {
        this.produceEscapedOutput(writer);
    }

    private void produceEscapedOutput(Writer writer) {
        try {
            switch (this.templateMode) {
                case TEXT: 
                case HTML: {
                    if (this.input != null) {
                        HtmlEscape.escapeHtml4Xml(this.input.toString(), writer);
                    }
                    return;
                }
                case XML: {
                    if (this.input != null) {
                        XmlEscape.escapeXml10(this.input.toString(), writer);
                    }
                    return;
                }
                case JAVASCRIPT: {
                    IStandardJavaScriptSerializer javaScriptSerializer = StandardSerializers.getJavaScriptSerializer(this.configuration);
                    javaScriptSerializer.serializeValue(this.input, writer);
                    return;
                }
                case CSS: {
                    IStandardCSSSerializer cssSerializer = StandardSerializers.getCSSSerializer(this.configuration);
                    cssSerializer.serializeValue(this.input, writer);
                    return;
                }
                case RAW: {
                    if (this.input != null) {
                        writer.write(this.input.toString());
                    }
                    return;
                }
            }
            throw new TemplateProcessingException("Unrecognized template mode " + (Object)((Object)this.templateMode) + ". Cannot produce escaped output for this template mode.");
        }
        catch (IOException e) {
            throw new TemplateProcessingException("An error happened while trying to produce escaped output", e);
        }
    }
}

