/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.web;

import java.util.Map;
import java.util.Set;

public interface IWebRequest {
    public String getMethod();

    default public boolean isSecure() {
        String scheme = this.getScheme();
        return scheme != null && scheme.equalsIgnoreCase("https");
    }

    public String getScheme();

    public String getServerName();

    public Integer getServerPort();

    public String getApplicationPath();

    public String getPathWithinApplication();

    public String getQueryString();

    default public String getRequestPath() {
        String applicationPath = this.getApplicationPath();
        String pathWithinApplication = this.getPathWithinApplication();
        return (applicationPath == null ? "" : applicationPath) + (pathWithinApplication == null ? "" : pathWithinApplication);
    }

    default public String getRequestURL() {
        String scheme = this.getScheme();
        String serverName = this.getServerName();
        Integer serverPort = this.getServerPort();
        String requestPath = this.getRequestPath();
        String queryString = this.getQueryString();
        if (scheme == null || serverName == null || serverPort == null) {
            throw new UnsupportedOperationException("Request scheme, server name or port are null in this environment. Cannot compute request URL");
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(scheme).append("://").append(serverName);
        if (!(scheme.equals("http") && serverPort == 80 || scheme.equals("https") && serverPort == 443)) {
            urlBuilder.append(':').append(serverPort);
        }
        urlBuilder.append(requestPath);
        if (queryString != null) {
            urlBuilder.append('?').append(queryString);
        }
        return urlBuilder.toString();
    }

    public boolean containsHeader(String var1);

    public int getHeaderCount();

    public Set<String> getAllHeaderNames();

    public Map<String, String[]> getHeaderMap();

    default public String getHeaderValue(String name) {
        String[] headerValues = this.getHeaderValues(name);
        return headerValues == null || headerValues.length == 0 ? null : headerValues[0];
    }

    public String[] getHeaderValues(String var1);

    public boolean containsParameter(String var1);

    public int getParameterCount();

    public Set<String> getAllParameterNames();

    public Map<String, String[]> getParameterMap();

    default public String getParameterValue(String name) {
        String[] parameterValues = this.getParameterValues(name);
        return parameterValues == null || parameterValues.length == 0 ? null : parameterValues[0];
    }

    public String[] getParameterValues(String var1);

    public boolean containsCookie(String var1);

    public int getCookieCount();

    public Set<String> getAllCookieNames();

    public Map<String, String[]> getCookieMap();

    default public String getCookieValue(String name) {
        String[] cookieValues = this.getCookieValues(name);
        return cookieValues == null || cookieValues.length == 0 ? null : cookieValues[0];
    }

    public String[] getCookieValues(String var1);
}

