/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.web.servlet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import karate.org.thymeleaf.util.Validate;
import karate.org.thymeleaf.web.IWebApplication;

public interface IServletWebApplication
extends IWebApplication {
    public Enumeration<String> getAttributeNames();

    @Override
    default public boolean containsAttribute(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.getAttributeValue(name) != null;
    }

    @Override
    default public int getAttributeCount() {
        int count = 0;
        Enumeration<String> attributeNamesEnum = this.getAttributeNames();
        while (attributeNamesEnum.hasMoreElements()) {
            attributeNamesEnum.nextElement();
            ++count;
        }
        return count;
    }

    @Override
    default public Set<String> getAllAttributeNames() {
        LinkedHashSet<String> attributeNames = new LinkedHashSet<String>(10);
        Enumeration<String> attributeNamesEnum = this.getAttributeNames();
        while (attributeNamesEnum.hasMoreElements()) {
            attributeNames.add(attributeNamesEnum.nextElement());
        }
        return Collections.unmodifiableSet(attributeNames);
    }

    @Override
    default public Map<String, Object> getAttributeMap() {
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(10);
        Enumeration<String> attributeNamesEnum = this.getAttributeNames();
        while (attributeNamesEnum.hasMoreElements()) {
            String attributeName = attributeNamesEnum.nextElement();
            attributeMap.put(attributeName, this.getAttributeValue(attributeName));
        }
        return Collections.unmodifiableMap(attributeMap);
    }

    @Override
    default public void removeAttribute(String name) {
        Validate.notNull(name, "Name cannot be null");
        this.setAttributeValue(name, null);
    }

    public URL getResource(String var1) throws MalformedURLException;

    @Override
    default public boolean resourceExists(String path) {
        Validate.notNull(path, "Path cannot be null");
        try {
            return this.getResource(path) != null;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Object getNativeServletContextObject();
}

