/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.web.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import karate.org.thymeleaf.util.Validate;
import karate.org.thymeleaf.web.servlet.IServletWebApplication;
import karate.org.thymeleaf.web.servlet.IServletWebExchange;
import karate.org.thymeleaf.web.servlet.JakartaServletWebExchange;
import karate.org.thymeleaf.web.servlet.JakartaServletWebRequest;
import karate.org.thymeleaf.web.servlet.JakartaServletWebSession;

public class JakartaServletWebApplication
implements IServletWebApplication {
    private final ServletContext servletContext;

    JakartaServletWebApplication(ServletContext servletContext) {
        Validate.notNull(servletContext, "Servlet context cannot be null");
        this.servletContext = servletContext;
    }

    public static JakartaServletWebApplication buildApplication(ServletContext servletContext) {
        return new JakartaServletWebApplication(servletContext);
    }

    public IServletWebExchange buildExchange(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Validate.notNull(httpServletRequest, "Request cannot be null");
        Validate.notNull(httpServletResponse, "Response cannot be null");
        Validate.isTrue(this.servletContextMatches(httpServletRequest), "Cannot build an application for a request which servlet context does not match with the application that it is being built for.");
        JakartaServletWebRequest request = new JakartaServletWebRequest(httpServletRequest);
        JakartaServletWebSession session = new JakartaServletWebSession(httpServletRequest);
        return new JakartaServletWebExchange(request, session, this, httpServletResponse);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return this.servletContext.getAttributeNames();
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.servletContext.getAttribute(name);
    }

    @Override
    public void setAttributeValue(String name, Object value) {
        Validate.notNull(name, "Name cannot be null");
        this.servletContext.setAttribute(name, value);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        Validate.notNull(path, "Path cannot be null");
        return this.servletContext.getResourceAsStream(path);
    }

    @Override
    public URL getResource(String path) throws MalformedURLException {
        Validate.notNull(path, "Path cannot be null");
        return this.servletContext.getResource(path);
    }

    @Override
    public Object getNativeServletContextObject() {
        return this.servletContext;
    }

    private boolean servletContextMatches(HttpServletRequest httpServletRequest) {
        String servletContextPath = this.servletContext.getContextPath();
        String requestServletContextPath = httpServletRequest.getServletContext().getContextPath();
        return Objects.equals(servletContextPath, requestServletContextPath);
    }
}

