/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.web.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Collections;
import java.util.Enumeration;
import karate.org.thymeleaf.util.Validate;
import karate.org.thymeleaf.web.servlet.IServletWebSession;

final class JakartaServletWebSession
implements IServletWebSession {
    private final HttpServletRequest request;
    private HttpSession session;

    JakartaServletWebSession(HttpServletRequest request) {
        Validate.notNull(request, "Request cannot be null");
        this.request = request;
        this.session = this.request.getSession(false);
    }

    @Override
    public boolean exists() {
        return this.session != null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.session == null) {
            return Collections.emptyEnumeration();
        }
        return this.session.getAttributeNames();
    }

    @Override
    public Object getAttributeValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        if (this.session == null) {
            return null;
        }
        return this.session.getAttribute(name);
    }

    @Override
    public void setAttributeValue(String name, Object value) {
        Validate.notNull(name, "Name cannot be null");
        if (this.session == null) {
            this.session = this.request.getSession(true);
        }
        this.session.setAttribute(name, value);
    }

    @Override
    public Object getNativeSessionObject() {
        return this.session;
    }
}

