/*
 * Decompiled with CFR 0.152.
 */
package karate.org.thymeleaf.web.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import karate.org.thymeleaf.util.Validate;
import karate.org.thymeleaf.web.servlet.IServletWebRequest;

final class JavaxServletWebRequest
implements IServletWebRequest {
    private final HttpServletRequest request;

    JavaxServletWebRequest(HttpServletRequest request) {
        Validate.notNull(request, "Request cannot be null");
        this.request = request;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getScheme() {
        return this.request.getScheme();
    }

    @Override
    public String getServerName() {
        return this.request.getServerName();
    }

    @Override
    public Integer getServerPort() {
        return this.request.getServerPort();
    }

    @Override
    public String getContextPath() {
        String contextPath = this.request.getContextPath();
        return contextPath != null && contextPath.length() == 1 && contextPath.charAt(0) == '/' ? "" : contextPath;
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    @Override
    public String getHeaderValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.request.getHeader(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    @Override
    public String getParameterValue(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.request.getParameter(name);
    }

    @Override
    public String[] getParameterValues(String name) {
        Validate.notNull(name, "Name cannot be null");
        return this.request.getParameterValues(name);
    }

    @Override
    public boolean containsCookie(String name) {
        Validate.notNull(name, "Name cannot be null");
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return false;
        }
        for (int i = 0; i < cookies.length; ++i) {
            if (!name.equals(cookies[i].getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCookieCount() {
        Cookie[] cookies = this.request.getCookies();
        return cookies == null ? 0 : cookies.length;
    }

    @Override
    public Set<String> getAllCookieNames() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> cookieNames = new LinkedHashSet<String>(3);
        for (int i = 0; i < cookies.length; ++i) {
            cookieNames.add(cookies[i].getName());
        }
        return Collections.unmodifiableSet(cookieNames);
    }

    @Override
    public Map<String, String[]> getCookieMap() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String[]> cookieMap = new LinkedHashMap<String, String[]>(3);
        for (int i = 0; i < cookies.length; ++i) {
            String cookieName = cookies[i].getName();
            String cookieValue = cookies[i].getValue();
            if (cookieMap.containsKey(cookieName)) {
                String[] currentCookieValues = (String[])cookieMap.get(cookieName);
                String[] newCookieValues = Arrays.copyOf(currentCookieValues, currentCookieValues.length + 1);
                newCookieValues[currentCookieValues.length] = cookieValue;
                cookieMap.put(cookieName, newCookieValues);
                continue;
            }
            cookieMap.put(cookieName, new String[]{cookieValue});
        }
        return Collections.unmodifiableMap(cookieMap);
    }

    @Override
    public String[] getCookieValues(String name) {
        Validate.notNull(name, "Name cannot be null");
        Cookie[] cookies = this.request.getCookies();
        if (cookies == null) {
            return null;
        }
        String[] cookieValues = null;
        for (int i = 0; i < cookies.length; ++i) {
            String cookieName = cookies[i].getName();
            if (!name.equals(cookieName)) continue;
            String cookieValue = cookies[i].getValue();
            if (cookieValues != null) {
                String[] newCookieValues = (String[])Arrays.copyOf(cookieValues, cookieValues.length + 1);
                newCookieValues[cookieValues.length] = cookieValue;
                cookieValues = newCookieValues;
                continue;
            }
            cookieValues = new String[]{cookieValue};
        }
        return cookieValues;
    }

    @Override
    public Object getNativeRequestObject() {
        return this.request;
    }
}

