/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DevToolsDriver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.http.Response;
import com.intuit.karate.shell.Command;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Chrome
extends DevToolsDriver {
    public static final String DRIVER_TYPE = "chrome";
    public static final String DEFAULT_PATH_MAC = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
    public static final String DEFAULT_PATH_WIN32 = "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
    public static final String DEFAULT_PATH_WIN64 = "C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe";
    public static final String DEFAULT_PATH_WIN = Files.isRegularFile(Paths.get("C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe", new String[0]), new LinkOption[0]) && Files.isReadable(Paths.get("C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe", new String[0])) ? "C:\\Program Files\\Google\\Chrome\\Application\\chrome.exe" : "C:\\Program Files (x86)\\Google\\Chrome\\Application\\chrome.exe";
    public static final String DEFAULT_PATH_LINUX = "/usr/bin/google-chrome";

    public Chrome(DriverOptions options, Command command, String webSocketUrl) {
        super(options, command, webSocketUrl);
    }

    public static Chrome start(Map<String, Object> map, ScenarioRuntime sr) {
        DriverOptions options = new DriverOptions(map, sr, 9222, FileUtils.isOsWindows() ? DEFAULT_PATH_WIN : (FileUtils.isOsMacOsX() ? DEFAULT_PATH_MAC : DEFAULT_PATH_LINUX));
        options.arg("--remote-debugging-port=" + options.port);
        options.arg("--remote-allow-origins=*");
        options.arg("--no-first-run");
        if (options.userDataDir != null) {
            options.arg("--user-data-dir=" + options.userDataDir);
        }
        options.arg("--disable-popup-blocking");
        if (options.headless) {
            options.arg("--headless=new");
        }
        Command command = options.startProcess();
        Http http = options.getHttp();
        Command.waitForHttp(http.urlBase + "/json", r -> r.getStatus() == 200 && !r.json().asList().isEmpty());
        Response res = http.path("json").get();
        if (res.json().asList().isEmpty()) {
            if (command != null) {
                command.close(true);
            }
            throw new RuntimeException("chrome server returned empty list from " + http.urlBase);
        }
        String webSocketUrl = null;
        List targets = res.json().asList();
        for (Map target : targets) {
            String targetType;
            String targetUrl = (String)target.get("url");
            if (targetUrl == null || targetUrl.startsWith("chrome-") || !"page".equals(targetType = (String)target.get("type"))) continue;
            webSocketUrl = (String)target.get("webSocketDebuggerUrl");
            if (options.attach != null && !targetUrl.contains(options.attach)) continue;
            break;
        }
        if (webSocketUrl == null) {
            throw new RuntimeException("failed to attach to chrome debug server");
        }
        Chrome chrome = new Chrome(options, command, webSocketUrl);
        chrome.activate();
        chrome.enablePageEvents();
        chrome.enableRuntimeEvents();
        if (!options.headless) {
            chrome.initWindowIdAndState();
        }
        return chrome;
    }

    public static Chrome start(String chromeExecutablePath, boolean headless) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("executable", chromeExecutablePath);
        options.put("headless", headless);
        return Chrome.start(options);
    }

    public static Chrome start(Map<String, Object> options) {
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        options.putIfAbsent("type", DRIVER_TYPE);
        ScenarioRuntime runtime = FeatureRuntime.forTempUse((HttpClientFactory)HttpClientFactory.DEFAULT).scenarios.next();
        ScenarioEngine.set(runtime.engine);
        return Chrome.start(options, runtime);
    }

    public static Chrome start() {
        return Chrome.start(null);
    }

    public static Chrome startHeadless() {
        return Chrome.start(Collections.singletonMap("headless", true));
    }
}

