/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsArray;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.graal.Methods;
import com.intuit.karate.http.Cookies;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.MultiPartBuilder;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.client.utils.URIBuilder;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestBuilder
implements ProxyObject {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestBuilder.class);
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String PATH = "path";
    private static final String PARAM = "param";
    private static final String PARAMS = "params";
    private static final String HEADER = "header";
    private static final String HEADERS = "headers";
    private static final String BODY = "body";
    private static final String INVOKE = "invoke";
    private static final String GET = "get";
    private static final String POST = "post";
    private static final String PUT = "put";
    private static final String DELETE = "delete";
    private static final String PATCH = "patch";
    private static final String HEAD = "head";
    private static final String CONNECT = "connect";
    private static final String OPTIONS = "options";
    private static final String TRACE = "trace";
    private static final String MULTI_PART = "multiPart";
    private static final String[] KEYS = new String[]{"url", "method", "path", "param", "params", "header", "headers", "body", "invoke", "get", "post", "put", "delete", "patch", "head", "connect", "options", "trace", "multiPart"};
    private static final Set<String> KEY_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final JsArray KEY_ARRAY = new JsArray(KEYS);
    private String url;
    private String method;
    private List<String> paths;
    private Map<String, List<String>> params;
    private Map<String, List<String>> headers;
    private MultiPartBuilder multiPart;
    private Object body;
    private Set<Cookie> cookies;
    private String retryUntil;
    private RuntimeHook hook;
    public final HttpClient client;
    private final Methods.FunVar PATH_FUNCTION = args -> {
        if (args.length == 0) {
            return this.getUri();
        }
        for (Object o : args) {
            if (o == null) continue;
            this.path(o.toString());
        }
        return this;
    };
    private final Methods.FunVar PARAM_FUNCTION = args -> {
        if (args.length == 1) {
            List<String> list = this.getParam(HttpRequestBuilder.toString(args[0]));
            if (list == null || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        this.param(HttpRequestBuilder.toString(args[0]), HttpRequestBuilder.toString(args[1]));
        return this;
    };
    private final Methods.FunVar HEADER_FUNCTION = args -> {
        if (args.length == 1) {
            return this.getHeader(HttpRequestBuilder.toString(args[0]));
        }
        this.header(HttpRequestBuilder.toString(args[0]), HttpRequestBuilder.toString(args[1]));
        return this;
    };
    private final Methods.FunVar INVOKE_FUNCTION = args -> {
        switch (args.length) {
            case 0: {
                return this.invoke();
            }
            case 1: {
                return this.invoke(args[0].toString());
            }
        }
        return this.invoke(args[0].toString(), args[1]);
    };
    private final Methods.FunVar METHOD_FUNCTION = args -> {
        if (args.length > 0) {
            return this.method((String)args[0]);
        }
        return this.method;
    };
    private final Methods.FunVar BODY_FUNCTION = args -> {
        if (args == null) {
            return this;
        }
        if (args.length > 0) {
            return this.body(args[0]);
        }
        return JsValue.fromJava(this.body);
    };
    private final Supplier GET_FUNCTION = () -> this.invoke(GET);
    private final Function POST_FUNCTION = o -> this.invoke(POST, o);
    private final Function PUT_FUNCTION = o -> this.invoke(PUT, o);
    private final Function PATCH_FUNCTION = o -> this.invoke(PATCH, o);
    private final Supplier DELETE_FUNCTION = () -> this.invoke(DELETE);

    public HttpRequestBuilder(HttpClient client) {
        this.client = client;
    }

    public HttpRequestBuilder reset() {
        this.method = null;
        this.paths = null;
        this.params = null;
        this.headers = null;
        this.multiPart = null;
        this.body = null;
        this.cookies = null;
        this.retryUntil = null;
        return this;
    }

    public HttpRequestBuilder copy(HttpClient newClient) {
        HttpRequestBuilder hrb = new HttpRequestBuilder(newClient == null ? this.client : newClient);
        hrb.url = this.url;
        hrb.method = this.method;
        hrb.paths = this.paths;
        hrb.params = this.params;
        hrb.headers = this.headers;
        hrb.multiPart = this.multiPart;
        hrb.body = this.body;
        hrb.cookies = this.cookies;
        hrb.retryUntil = this.retryUntil;
        return hrb;
    }

    public Response invoke(String method) {
        this.method = method;
        return this.invoke();
    }

    public Response invoke(String method, Object body) {
        this.method = method;
        this.body = body;
        return this.invoke();
    }

    public HttpRequest build() {
        this.buildInternal();
        HttpRequest request = new HttpRequest();
        request.setMethod(this.method);
        request.setUrl(this.getUri());
        if (this.multiPart != null) {
            request.setBodyForDisplay(this.multiPart.getBodyForDisplay());
        }
        if (this.body != null) {
            request.setBody(JsonUtils.toBytes(this.body));
        }
        request.setHeaders(this.headers);
        return request;
    }

    private void buildInternal() {
        if (this.url == null) {
            this.url = this.client.getConfig().getUrl();
            if (this.url == null) {
                throw new RuntimeException("incomplete http request, 'url' not set");
            }
        }
        if (this.method == null) {
            this.method = this.multiPart != null && this.multiPart.isMultipart() ? "POST" : "GET";
        }
        this.method = this.method.toUpperCase();
        if ("GET".equals(this.method) && this.multiPart != null) {
            Map<String, Object> parts = this.multiPart.getFormFields();
            if (parts != null) {
                parts.forEach((k, v) -> this.param((String)k, (String)v));
            }
            this.multiPart = null;
        }
        if (this.multiPart != null && this.body == null) {
            this.body = this.multiPart.build();
            String userContentType = this.getHeader("Content-Type");
            if (userContentType != null) {
                String boundary = this.multiPart.getBoundary();
                if (boundary != null) {
                    this.contentType(userContentType + "; boundary=" + (String)boundary);
                }
            } else {
                this.contentType(this.multiPart.getContentTypeHeader());
            }
        }
        if (this.cookies != null && !this.cookies.isEmpty()) {
            ArrayList<String> cookieValues = new ArrayList<String>(this.cookies.size());
            for (Cookie c : this.cookies) {
                String cookieValue = ClientCookieEncoder.LAX.encode(c);
                cookieValues.add(cookieValue);
            }
            this.header("Cookie", StringUtils.join(cookieValues, "; "));
        }
        if (this.body != null && this.multiPart == null) {
            Charset charset;
            ResourceType rt;
            Object contentType = this.getContentType();
            if (contentType == null && (rt = ResourceType.fromObject(this.body)) != null) {
                contentType = rt.contentType;
            }
            Charset charset2 = charset = contentType == null ? null : HttpUtils.parseContentTypeCharset((String)contentType);
            if (charset == null) {
                Charset charset3 = this.client == null ? null : (charset = this.client.getConfig() == null ? null : this.client.getConfig().getCharset());
                if (charset != null && (contentType = StringUtils.trimToNull((String)contentType)) != null) {
                    contentType = (String)contentType + "; charset=" + charset;
                }
            }
            this.contentType((String)contentType);
        }
    }

    public Response invoke() {
        return this.client.invoke(this.build());
    }

    public boolean isRetry() {
        return this.retryUntil != null;
    }

    public String getRetryUntil() {
        return this.retryUntil;
    }

    public void setRetryUntil(String retryUntil) {
        this.retryUntil = retryUntil;
    }

    public HttpRequestBuilder url(String value) {
        this.url = value;
        return this;
    }

    public HttpRequestBuilder method(String method) {
        this.method = method;
        return this;
    }

    public HttpRequestBuilder paths(String ... paths) {
        for (String path : paths) {
            this.path(path);
        }
        return this;
    }

    public HttpRequestBuilder path(String path) {
        if (path == null) {
            return this;
        }
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(path);
        return this;
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Object getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            return new LinkedHashMap<String, String>(0);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(this.headers.size());
        this.headers.forEach((k, v) -> {
            Object value;
            if (v != null && !v.isEmpty() && (value = v.get(0)) != null) {
                map.put((String)k, value.toString());
            }
        });
        return map;
    }

    public String getUri() {
        try {
            URIBuilder builder = this.url == null ? new URIBuilder() : new URIBuilder(this.url);
            if (this.params != null) {
                this.params.forEach((key, values) -> values.forEach(value -> builder.addParameter(key, value)));
            }
            if (this.paths != null) {
                ArrayList<String> segments = new ArrayList<String>();
                for (String item : builder.getPathSegments()) {
                    if (item.isEmpty()) continue;
                    segments.add(item);
                }
                Iterator<String> pathIterator = this.paths.iterator();
                while (pathIterator.hasNext()) {
                    String item;
                    item = pathIterator.next();
                    if (!pathIterator.hasNext() && "/".equals(item)) {
                        segments.add("");
                        continue;
                    }
                    for (String s : StringUtils.split(item, '/', true)) {
                        segments.add(s);
                    }
                }
                builder.setPathSegments(segments);
            }
            URI uri = builder.build();
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpRequestBuilder body(Object body) {
        this.body = body;
        return this;
    }

    public HttpRequestBuilder bodyJson(String json) {
        this.body = Json.of(json).value();
        return this;
    }

    public List<String> getHeaderValues(String name) {
        return StringUtils.getIgnoreKeyCase(this.headers, name);
    }

    public String getHeader(String name) {
        List<String> list = this.getHeaderValues(name);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public HttpRequestBuilder removeHeader(String name) {
        if (this.headers != null) {
            StringUtils.removeIgnoreKeyCase(this.headers, name);
        }
        return this;
    }

    public HttpRequestBuilder header(String name, String ... values) {
        return this.header(name, Arrays.asList(values));
    }

    public HttpRequestBuilder header(String name, List<String> values) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, List<String>>();
        }
        for (String key : this.headers.keySet()) {
            if (!key.equalsIgnoreCase(name)) continue;
            name = key;
            break;
        }
        this.headers.put(name, values);
        return this;
    }

    public HttpRequestBuilder header(String name, String value) {
        return this.header(name, Collections.singletonList(value));
    }

    public HttpRequestBuilder headers(Map<String, Object> map) {
        map.forEach((k, v) -> {
            if (!k.startsWith(":")) {
                if (v instanceof List) {
                    this.header((String)k, (List)v);
                } else if (v != null) {
                    this.header((String)k, v.toString());
                }
            }
        });
        return this;
    }

    public HttpRequestBuilder headers(Value value) {
        JsValue jv = new JsValue(value);
        if (jv.isObject()) {
            this.headers(jv.getAsMap());
        } else {
            logger.warn("unexpected headers() argument: {}", (Object)value);
        }
        return this;
    }

    public HttpRequestBuilder contentType(String contentType) {
        if (contentType != null) {
            this.header("Content-Type", contentType);
        }
        return this;
    }

    public List<String> getParam(String name) {
        if (this.params == null || name == null) {
            return null;
        }
        return this.params.get(name);
    }

    public HttpRequestBuilder param(String name, String ... values) {
        return this.param(name, Arrays.asList(values));
    }

    public HttpRequestBuilder param(String name, List<String> values) {
        List notNullValues;
        if (this.params == null) {
            this.params = new LinkedHashMap<String, List<String>>();
        }
        if (!(notNullValues = values.stream().filter(v -> v != null).collect(Collectors.toList())).isEmpty()) {
            this.params.put(name, notNullValues);
        }
        return this;
    }

    public HttpRequestBuilder params(Map<String, List<String>> params) {
        this.params = params;
        return this;
    }

    public HttpRequestBuilder cookies(Collection<Map> cookies) {
        for (Map map : cookies) {
            this.cookie(map);
        }
        return this;
    }

    public HttpRequestBuilder cookie(Map<String, Object> map) {
        return this.cookie(Cookies.fromMap(map));
    }

    public HttpRequestBuilder cookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new HashSet<Cookie>();
        }
        this.cookies.add(cookie);
        return this;
    }

    public HttpRequestBuilder cookie(String name, String value) {
        return this.cookie((Cookie)new DefaultCookie(name, value));
    }

    public HttpRequestBuilder formField(String name, Object value) {
        if (this.multiPart == null) {
            this.multiPart = new MultiPartBuilder(false, this.client);
        }
        this.multiPart.part(name, value);
        return this;
    }

    public HttpRequestBuilder multiPartJson(String json) {
        return this.multiPart((Map)Json.of(json).value());
    }

    public HttpRequestBuilder multiPart(Map<String, Object> map) {
        if (this.multiPart == null) {
            this.multiPart = new MultiPartBuilder(true, this.client);
        }
        this.multiPart.part(map);
        return this;
    }

    public HttpRequestBuilder hook(RuntimeHook hook) {
        this.hook = hook;
        return this;
    }

    public RuntimeHook hook() {
        return this.hook;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public Object getMember(String key) {
        switch (key) {
            case "method": {
                return this.METHOD_FUNCTION;
            }
            case "path": {
                return this.PATH_FUNCTION;
            }
            case "header": {
                return this.HEADER_FUNCTION;
            }
            case "headers": {
                return JsValue.fromJava(this.headers);
            }
            case "param": {
                return this.PARAM_FUNCTION;
            }
            case "params": {
                return JsValue.fromJava(this.params);
            }
            case "body": {
                return this.BODY_FUNCTION;
            }
            case "invoke": {
                return this.INVOKE_FUNCTION;
            }
            case "get": {
                return this.GET_FUNCTION;
            }
            case "post": {
                return this.POST_FUNCTION;
            }
            case "put": {
                return this.PUT_FUNCTION;
            }
            case "patch": {
                return this.PATCH_FUNCTION;
            }
            case "delete": {
                return this.DELETE_FUNCTION;
            }
            case "url": {
                return this::url;
            }
            case "multiPart": {
                return this::multiPart;
            }
        }
        logger.warn("no such property on http object: {}", (Object)key);
        return null;
    }

    public void putMember(String key, Value value) {
        switch (key) {
            case "method": {
                this.method = value.asString();
                break;
            }
            case "body": {
                this.body = JsValue.toJava(value);
                break;
            }
            case "headers": {
                this.headers(value);
                break;
            }
            case "params": {
                this.params = (Map)JsValue.toJava(value);
                break;
            }
            case "url": {
                this.url = value.asString();
                break;
            }
            default: {
                logger.warn("put not supported on http object: {} - {}", (Object)key, (Object)value);
            }
        }
    }

    public Object getMemberKeys() {
        return KEY_ARRAY;
    }

    public boolean hasMember(String key) {
        return KEY_SET.contains(key);
    }

    public String toString() {
        return this.getUri();
    }

    public String toCurlCommand() {
        this.buildInternal();
        StringBuilder sb = new StringBuilder();
        sb.append("curl ");
        sb.append("-X ").append(this.method).append(' ');
        String url = this.getUri();
        if (!StringUtils.isBlank(url)) {
            sb.append(this.getUri()).append(' ');
        }
        if (this.multiPart != null) {
            sb.append("\\\n");
            sb.append(this.multiPart.toCurlCommand());
        } else if (this.body != null) {
            sb.append("\\\n");
            String raw = JsonUtils.toString(this.body);
            sb.append("-d '").append(raw).append("'");
        }
        return sb.toString();
    }

    public Map<String, Object> toMap() {
        ArrayList list;
        this.buildInternal();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(URL, this.getUri());
        map.put(METHOD, this.method);
        if (this.headers != null) {
            list = new ArrayList(this.headers.size());
            map.put(HEADERS, list);
            this.headers.forEach((k, v) -> {
                if (v != null) {
                    v.forEach(value -> {
                        if (value != null) {
                            HashMap<String, String> header = new HashMap<String, String>();
                            header.put("name", (String)k);
                            header.put("value", (String)value);
                            list.add(header);
                        }
                    });
                }
            });
        }
        if (this.params != null) {
            list = new ArrayList(this.params.size());
            map.put(PARAMS, list);
            this.params.forEach((k, v) -> {
                if (v != null) {
                    v.forEach(value -> {
                        if (value != null) {
                            HashMap<String, String> header = new HashMap<String, String>();
                            header.put("name", (String)k);
                            header.put("value", (String)value);
                            list.add(header);
                        }
                    });
                }
            });
        }
        if (this.body != null) {
            map.put(BODY, this.body);
        }
        return map;
    }
}

