/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.template.KarateAttributeTagProcessor;
import com.intuit.karate.template.KarateEachTagProcessor;
import com.intuit.karate.template.KarateExpression;
import com.intuit.karate.template.KarateWithTagProcessor;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.IStandardVariableExpression;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.standard.expression.StandardExpressionParser;
import org.thymeleaf.standard.processor.StandardAttrTagProcessor;
import org.thymeleaf.standard.processor.StandardAttrappendTagProcessor;
import org.thymeleaf.standard.processor.StandardAttrprependTagProcessor;
import org.thymeleaf.standard.processor.StandardEachTagProcessor;
import org.thymeleaf.standard.processor.StandardWithTagProcessor;

public class KarateStandardDialect
extends StandardDialect
implements IStandardVariableExpressionEvaluator,
IStandardExpressionParser {
    private static final Logger logger = LoggerFactory.getLogger(KarateStandardDialect.class);
    private final StandardExpressionParser expressionParser = new StandardExpressionParser();

    public IStandardVariableExpressionEvaluator getVariableExpressionEvaluator() {
        return this;
    }

    public IStandardExpressionParser getExpressionParser() {
        return this;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        Set processors = StandardDialect.createStandardProcessorsSet((String)dialectPrefix);
        HashSet<IProcessor> patched = new HashSet<IProcessor>(processors.size());
        for (Object p : processors) {
            if (p instanceof StandardEachTagProcessor) {
                p = new KarateEachTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardWithTagProcessor) {
                p = new KarateWithTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrappendTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrappendTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            if (p instanceof StandardAttrprependTagProcessor) {
                p = new KarateAttributeTagProcessor.KarateAttrprependTagProcessor(p.getTemplateMode(), dialectPrefix);
            }
            patched.add((IProcessor)p);
        }
        return patched;
    }

    public Object evaluate(IExpressionContext ctx, IStandardVariableExpression ve, StandardExpressionExecutionContext ec) {
        KarateExpression ke = new KarateExpression(ve.getExpression());
        return ke.execute(ctx);
    }

    public IStandardExpression parseExpression(IExpressionContext context, String input) {
        if (input.charAt(0) == '~') {
            return this.expressionParser.parseExpression(context, input);
        }
        return new KarateExpression(input);
    }
}

