/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.template;

import com.intuit.karate.graal.JsValue;
import com.intuit.karate.template.KarateEngineContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.context.IEngineContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.AbstractAttributeTagProcessor;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.templatemode.TemplateMode;

public class KarateWithTagProcessor
extends AbstractAttributeTagProcessor {
    private static final Logger logger = LoggerFactory.getLogger(KarateWithTagProcessor.class);
    public static final int PRECEDENCE = 600;
    public static final String ATTR_NAME = "with";

    public KarateWithTagProcessor(TemplateMode templateMode, String dialectPrefix) {
        super(templateMode, dialectPrefix, null, false, ATTR_NAME, true, 600, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String av, IElementTagStructureHandler structureHandler) {
        JsValue jv = KarateEngineContext.get().evalLocalAsObject(av);
        if (!jv.isObject()) {
            logger.warn("value did not evaluate to json: {}", (Object)av);
            return;
        }
        Map<String, Object> map = jv.getAsMap();
        IEngineContext engineContext = context instanceof IEngineContext ? (IEngineContext)context : null;
        map.forEach((k, v) -> {
            if (engineContext != null) {
                engineContext.setVariable(k, v);
            } else {
                structureHandler.setLocalVariable(k, v);
            }
        });
    }
}

