/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Json;
import com.intuit.karate.LogAppender;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.Variable;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.Response;
import java.util.Map;

public class Http {
    public final String urlBase;
    private final ScenarioEngine engine;
    private final HttpRequestBuilder builder;

    public static Http to(String url) {
        return new Http(url);
    }

    public void setAppender(LogAppender appender) {
        this.engine.logger.setAppender(appender);
    }

    private Http(String urlBase) {
        this.urlBase = urlBase;
        this.engine = ScenarioEngine.forTempUse(HttpClientFactory.DEFAULT);
        this.builder = this.engine.getRequestBuilder();
        this.builder.url(urlBase);
    }

    public Http url(String url) {
        this.builder.url(url);
        return this;
    }

    public Http param(String key, String ... values) {
        this.builder.param(key, values);
        return this;
    }

    public Http path(String ... paths) {
        this.builder.paths(paths);
        return this;
    }

    public Http header(String name, String value) {
        this.builder.header(name, value);
        return this;
    }

    public Http hook(RuntimeHook hook) {
        this.builder.hook(hook);
        return this;
    }

    public Response method(String method, Object body) {
        if (body != null) {
            this.builder.body(body instanceof Json ? ((Json)body).value() : body);
        }
        this.builder.method(method);
        Response response = this.engine.httpInvoke();
        if (response.getStatus() >= 400) {
            this.engine.logger.warn("http response code: {}, response: {}, request: {}", response.getStatus(), response.getBodyAsString(), this.engine.getHttpRequest());
        }
        return response;
    }

    public Response method(String method) {
        return this.method(method, null);
    }

    public Response methodJson(String method, String body) {
        return this.method(method, Json.of(body));
    }

    public Response get() {
        return this.method("get");
    }

    public Response postJson(String body) {
        return this.post(Json.of(body));
    }

    public Response post(Object body) {
        return this.method("post", body);
    }

    public Response put(Object body) {
        return this.method("put", body);
    }

    public Response putJson(String body) {
        return this.put(Json.of(body));
    }

    public Response delete() {
        return this.method("delete");
    }

    public Http configure(String key, Object value) {
        this.engine.configure(key, new Variable(value));
        return this;
    }

    public Http configure(Map<String, Object> map) {
        map.forEach((k, v) -> this.configure((String)k, v));
        return this;
    }
}

