/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Json;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.DevToolsDriver;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevToolsMessage {
    private static final Logger logger = LoggerFactory.getLogger(DevToolsMessage.class);
    protected final DevToolsDriver driver;
    private final String sessionId;
    private final String method;
    private Integer id;
    private Json params;
    private Map<String, Object> error;
    private Variable result;
    private Integer timeout;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean methodIs(String method) {
        return method.equals(this.method);
    }

    public <T> T getParam(String path) {
        if (this.params == null) {
            return null;
        }
        try {
            return this.params.get(path);
        }
        catch (Exception e) {
            if (logger.isTraceEnabled()) {
                logger.trace("get param - json path failed: {} - {}", (Object)path, (Object)this.params);
            }
            return null;
        }
    }

    public Variable getResult() {
        return this.result == null ? Variable.NULL : this.result;
    }

    public <T> T getResult(String path) {
        if (this.result == null || this.result.isNull()) {
            return null;
        }
        Json json = Json.of(this.result.getValue());
        return json.get(path);
    }

    public void setResult(Variable result) {
        this.result = result;
    }

    private static Map<String, Object> toMap(List<Map<String, Object>> list) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        for (Map<String, Object> map : list) {
            String key = (String)map.get("name");
            Map valMap = (Map)map.get("value");
            res.put(key, valMap == null ? null : (Object)valMap.get("value"));
        }
        return res;
    }

    public boolean isResultError() {
        if (this.error != null) {
            return true;
        }
        if (this.result == null || !this.result.isMap()) {
            return false;
        }
        String resultError = (String)((Map)this.result.getValue()).get("subtype");
        return "error".equals(resultError);
    }

    public Variable getResultVariable(String key) {
        if (this.result == null || !this.result.isMap()) {
            return null;
        }
        return new Variable(((Map)this.result.getValue()).get(key));
    }

    public Map<String, Object> getError() {
        return this.error;
    }

    public DevToolsMessage(DevToolsDriver driver, String method) {
        this.driver = driver;
        this.id = driver.nextId();
        this.method = method;
        this.sessionId = driver.sessionId;
    }

    public DevToolsMessage(DevToolsDriver driver, Map<String, Object> map) {
        this.driver = driver;
        this.sessionId = (String)map.get("sessionId");
        this.id = (Integer)map.get("id");
        this.method = (String)map.get("method");
        Map temp = (Map)map.get("params");
        if (temp != null) {
            this.params = Json.of(temp);
        }
        if ((temp = (Map)map.get("result")) != null) {
            Map innerMap;
            String subtype;
            Object inner;
            this.result = temp.containsKey("result") ? ((inner = temp.get("result")) instanceof List ? new Variable(DevToolsMessage.toMap((List)inner)) : ("error".equals(subtype = (String)(innerMap = (Map)inner).get("subtype")) || innerMap.containsKey("objectId") ? new Variable(innerMap) : new Variable(innerMap.get("value")))) : new Variable(temp);
        }
        this.error = (Map)map.get("error");
    }

    public DevToolsMessage param(String path, Object value) {
        if (this.params == null) {
            this.params = Json.object();
        }
        this.params.set(path, value);
        return this;
    }

    public DevToolsMessage params(Map<String, Object> map) {
        this.params = Json.of(map);
        return this;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(4);
        map.put("id", this.id);
        if (this.sessionId != null) {
            map.put("sessionId", this.sessionId);
        }
        map.put("method", this.method);
        if (this.params != null) {
            map.put("params", this.params.value());
        }
        if (this.result != null) {
            map.put("result", this.result.getValue());
        }
        return map;
    }

    public void sendWithoutWaiting() {
        this.driver.send(this);
    }

    public DevToolsMessage send() {
        return this.send(null);
    }

    public DevToolsMessage send(Predicate<DevToolsMessage> condition) {
        return this.driver.sendAndWait(this, condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[id: ").append(this.id);
        if (this.sessionId != null) {
            sb.append(", sessionId: ").append(this.sessionId);
        }
        if (this.method != null) {
            sb.append(", method: ").append(this.method);
        }
        if (this.params != null) {
            sb.append(", params: ").append(this.params);
        }
        if (this.result != null) {
            sb.append(", result: ").append(this.result);
        }
        if (this.error != null) {
            sb.append(", error: ").append(this.error);
        }
        sb.append("]");
        return sb.toString();
    }
}

