/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.firefox;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import java.util.Map;

public class GeckoWebDriver
extends WebDriver {
    public static final String DRIVER_TYPE = "geckodriver";

    public GeckoWebDriver(DriverOptions options) {
        super(options);
    }

    public static GeckoWebDriver start(Map<String, Object> map, ScenarioRuntime sr) {
        DriverOptions options = new DriverOptions(map, sr, 4444, DRIVER_TYPE);
        options.arg("--port=" + options.port);
        return new GeckoWebDriver(options);
    }

    @Override
    protected String getJsonForFrame(String text) {
        return Json.object().set("frameId", text).toString();
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getOsType()) {
                    case MACOSX: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Firefox\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }

    @Override
    public void quit() {
        this.open = false;
        super.quit();
    }
}

