/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.playwright;

import com.intuit.karate.Logger;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.playwright.PlaywrightDriver;
import com.intuit.karate.driver.playwright.PlaywrightMessage;
import java.util.function.Predicate;

public class PlaywrightWait {
    private final DriverOptions options;
    private final PlaywrightDriver driver;
    private PlaywrightMessage lastSent;
    private Predicate<PlaywrightMessage> condition;
    private PlaywrightMessage lastReceived;
    private final Predicate<PlaywrightMessage> DEFAULT = m -> this.lastSent.getId().equals(m.getId());
    public static final Predicate<PlaywrightMessage> DOM_CONTENT_LOADED = m -> m.methodIs("domcontentloaded");
    private Logger logger;

    public PlaywrightWait(PlaywrightDriver driver, DriverOptions options) {
        this.driver = driver;
        this.options = options;
        this.logger = options.driverLogger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaywrightMessage send(PlaywrightMessage pwm, Predicate<PlaywrightMessage> condition) {
        this.lastReceived = null;
        this.lastSent = pwm;
        this.condition = condition == null ? this.DEFAULT : condition;
        long timeout = pwm.getTimeout() == null ? (long)this.options.getTimeout() : (long)pwm.getTimeout().intValue();
        PlaywrightWait playwrightWait = this;
        synchronized (playwrightWait) {
            this.logger.trace(">> wait: {}", pwm);
            try {
                this.driver.send(pwm);
                this.wait(timeout);
            }
            catch (InterruptedException e) {
                this.logger.error("interrupted: {} wait: {}", e.getMessage(), pwm);
            }
        }
        if (this.lastReceived == null) {
            this.logger.error("<< timed out after milliseconds: {} - {}", timeout, pwm);
            return null;
        }
        this.logger.trace("<< notified: {}", pwm);
        return this.lastReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(PlaywrightMessage pwm) {
        if (this.condition == null) {
            return;
        }
        PlaywrightWait playwrightWait = this;
        synchronized (playwrightWait) {
            if (this.condition.test(pwm)) {
                if (pwm.isError()) {
                    this.logger.warn("playwright error: {}", pwm);
                } else {
                    this.logger.trace("<< notify: {}", pwm);
                }
                this.lastReceived = pwm;
                this.notify();
            } else {
                this.logger.trace("<< ignore: {}", pwm);
            }
        }
    }
}

