/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.Constants;
import com.intuit.karate.Logger;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Config;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpLogger;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.Response;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class ArmeriaHttpClient
implements HttpClient,
DecoratingHttpClientFunction {
    private final Logger logger;
    private final HttpLogger httpLogger;
    private Config config;
    private HttpRequest request;
    private RequestContext requestContext;

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public ArmeriaHttpClient(Config config, Logger logger) {
        this.config = config;
        this.logger = logger;
        this.httpLogger = new HttpLogger(logger);
    }

    @Override
    public Response invoke(HttpRequest request) {
        AggregatedHttpResponse ahr;
        this.request = request;
        HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod());
        StringUtils.Pair urlAndPath = HttpUtils.parseUriIntoUrlBaseAndPath(request.getUrl());
        WebClient webClient = WebClient.builder((String)urlAndPath.left).decorator((DecoratingHttpClientFunction)this).build();
        RequestHeadersBuilder rhb = RequestHeaders.builder((HttpMethod)httpMethod, (String)urlAndPath.right);
        Map<String, List<String>> headers = request.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> rhb.add((CharSequence)k, (Iterable)v));
        }
        byte[] body = request.getBody() == null ? Constants.ZERO_BYTES : request.getBody();
        Callable<AggregatedHttpResponse> callable = () -> (AggregatedHttpResponse)webClient.execute(rhb.build(), body).aggregate().join();
        ServiceRequestContext src = this.requestContext == null ? null : this.requestContext.root();
        try {
            if (src == null) {
                ahr = callable.call();
            } else {
                Future future = src.blockingTaskExecutor().submit(callable);
                ahr = (AggregatedHttpResponse)future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ResponseHeaders rh = ahr.headers();
        LinkedHashMap<String, List<String>> responseHeaders = new LinkedHashMap<String, List<String>>(rh.size());
        for (CharSequence name : rh.names()) {
            if (HttpHeaderNames.STATUS.equals((Object)name)) continue;
            responseHeaders.put(name.toString(), rh.getAll(name));
        }
        byte[] responseBody = ahr.content().isEmpty() ? Constants.ZERO_BYTES : ahr.content().array();
        Response response = new Response(ahr.status().code(), responseHeaders, responseBody);
        this.httpLogger.logResponse(this.config, request, response);
        return response;
    }

    @Override
    public void setConfig(Config config) {
        this.config = config;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public HttpResponse execute(com.linecorp.armeria.client.HttpClient delegate, ClientRequestContext ctx, com.linecorp.armeria.common.HttpRequest req) throws Exception {
        ctx.log().whenAvailable(RequestLogProperty.REQUEST_HEADERS).thenAccept(log -> {
            this.request.setStartTime(log.requestStartTimeMillis());
            RequestHeaders rh = log.requestHeaders();
            for (CharSequence name : rh.names()) {
                if (name.charAt(0) == ':') continue;
                this.request.putHeader(name.toString(), rh.getAll(name));
            }
            this.httpLogger.logRequest(this.config, this.request);
        });
        ctx.log().whenAvailable(RequestLogProperty.RESPONSE_START_TIME).thenAccept(log -> this.request.setEndTime(log.responseStartTimeMillis()));
        return delegate.execute(ctx, req);
    }
}

