/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.FileUtils;
import com.intuit.karate.resource.FileResource;
import com.intuit.karate.resource.Resource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;

public class MemoryResource
implements Resource {
    private final File file;
    private final byte[] bytes;

    public MemoryResource(File file, String text) {
        this(file, FileUtils.toBytes(text));
    }

    public MemoryResource(File file, byte[] bytes) {
        this.file = file;
        this.bytes = bytes;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isClassPath() {
        return false;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getUri() {
        return this.file.toURI();
    }

    @Override
    public String getRelativePath() {
        return this.file.getPath().replace('\\', '/');
    }

    @Override
    public Resource resolve(String path) {
        return new FileResource(new File(this.file.getParent() + File.separator + path));
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return this.getPrefixedPath();
    }
}

