/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.resource;

import com.intuit.karate.resource.ResourceUtils;
import java.io.File;
import java.io.InputStream;
import java.net.URI;

public interface Resource {
    public static final String CLASSPATH_COLON = "classpath:";
    public static final String FILE_COLON = "file:";
    public static final String THIS_COLON = "this:";

    public boolean isFile();

    public boolean isClassPath();

    public File getFile();

    public URI getUri();

    public String getRelativePath();

    public Resource resolve(String var1);

    default public String getPrefixedPath() {
        return this.isClassPath() ? CLASSPATH_COLON + this.getRelativePath() : this.getRelativePath();
    }

    default public String getPrefixedParentPath() {
        return ResourceUtils.getParentPath(this.getPrefixedPath());
    }

    default public String getPackageQualifiedName() {
        String path = this.getRelativePath();
        if (path.endsWith(".feature")) {
            path = path.substring(0, path.length() - 8);
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path.replace('/', '.').replaceAll("\\.[.]+", ".");
    }

    default public String getFileNameWithoutExtension() {
        String path = this.getRelativePath();
        int pos = path.lastIndexOf(46);
        if (pos == -1) {
            return path;
        }
        return path.substring(0, pos);
    }

    public InputStream getStream();

    default public long getLastModified() {
        if (this.isFile()) {
            return this.getFile().lastModified();
        }
        try {
            return this.getUri().toURL().openConnection().getLastModified();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

