/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.JsonUtils;
import com.intuit.karate.Match;
import com.intuit.karate.MatchOperation;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.graal.JsValue;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public interface MatchOperator {
    public boolean execute(MatchOperation var1);

    public static class CoreOperator
    implements MatchOperator {
        private final boolean isEquals;
        private final boolean isContains;
        private final boolean isContainsAny;
        private final boolean isContainsOnly;
        private final boolean isDeep;
        private final boolean matchEachEmptyAllowed;
        private final CoreOperator equalsOperator;
        private static final Pattern UNDERSCORE_PATTERN = Pattern.compile("\\W_\\W|\\W_|_\\W");

        private CoreOperator(boolean isEquals, boolean isContains, boolean isContainsAny, boolean isContainsOnly, boolean matchEachEmptyAllowed) {
            this(isEquals, isContains, isContainsAny, isContainsOnly, false, matchEachEmptyAllowed);
        }

        private CoreOperator(boolean isEquals, boolean isContains, boolean isContainsAny, boolean isContainsOnly, boolean isDeep, boolean matchEachEmptyAllowed) {
            this.isEquals = isEquals;
            this.isContains = isContains;
            this.isContainsAny = isContainsAny;
            this.isContainsOnly = isContainsOnly;
            this.isDeep = isDeep;
            this.matchEachEmptyAllowed = matchEachEmptyAllowed;
            this.equalsOperator = isEquals ? this : CoreOperator.equalsOperator(matchEachEmptyAllowed);
        }

        @Override
        public boolean execute(MatchOperation operation) {
            String expStr;
            Match.Value actual = operation.actual;
            Match.Value expected = operation.expected;
            Match.Context context = operation.context;
            if (!(!actual.isNotPresent() || expected.isString() && expected.getAsString().startsWith("#"))) {
                return operation.fail("actual path does not exist");
            }
            boolean isContainsFamily = this.isContainsFamily();
            if (actual.type != expected.type) {
                if (!(!isContainsFamily || expected.isList() || expected.isString() && expected.isArrayObjectOrReference())) {
                    MatchOperation mo = new MatchOperation(context, (MatchOperator)this, actual, new Match.Value(Collections.singletonList(expected.getValue())));
                    mo.execute();
                    return mo.pass ? operation.pass() : operation.fail(mo.failReason);
                }
                if (expected.isXml() && actual.isMap()) {
                    MatchOperation mo = new MatchOperation(context, (MatchOperator)this, actual, new Match.Value(XmlUtils.toObject((Node)expected.getValue(), true)));
                    mo.execute();
                    return mo.pass ? operation.pass() : operation.fail(mo.failReason);
                }
                if (expected.isString()) {
                    expStr = (String)expected.getValue();
                    if (!expStr.startsWith("#")) {
                        return operation.fail("data types don't match");
                    }
                } else {
                    return operation.fail("data types don't match");
                }
            }
            if (expected.isString() && (expStr = (String)expected.getValue()).startsWith("#")) {
                return this.macroEqualsExpected(operation, expStr) ? operation.pass() : operation.fail(null);
            }
            if (this.isEquals()) {
                return this.actualEqualsExpected(operation) ? operation.pass() : operation.fail("not equal");
            }
            if (isContainsFamily) {
                return this.actualContainsExpected(operation) ? operation.pass() : operation.fail("actual does not contain expected");
            }
            throw new RuntimeException("unexpected match operator: " + String.valueOf(this));
        }

        private boolean macroEqualsExpected(MatchOperation operation, String expStr) {
            int minLength;
            Match.Value actual = operation.actual;
            Match.Value expected = operation.expected;
            Match.Context context = operation.context;
            boolean optional = expStr.startsWith("##");
            if (optional && actual.isNull()) {
                return true;
            }
            int n = minLength = optional ? 3 : 2;
            if (expStr.length() > minLength) {
                Object macro = expStr.substring(minLength - 1);
                if (((String)macro).startsWith("(") && ((String)macro).endsWith(")")) {
                    macro = ((String)macro).substring(1, ((String)macro).length() - 1);
                    Match.Type nestedType = CoreOperator.macroToMatchType(false, (String)macro);
                    int startPos = CoreOperator.matchTypeToStartPos(nestedType);
                    macro = ((String)macro).substring(startPos);
                    MatchOperator nestedOperator = nestedType.operator(this.isMatchEachEmptyAllowed());
                    if (this.isContainsFamily() && actual.isList()) {
                        nestedOperator = this.macroOperator(nestedOperator);
                    }
                    context.JS.put("$", context.root.actual.getValue());
                    context.JS.put("_", actual.getValue());
                    JsValue jv = context.JS.eval((String)macro);
                    context.JS.bindings.removeMember("$");
                    context.JS.bindings.removeMember("_");
                    MatchOperation mo = new MatchOperation(context, nestedOperator, actual, new Match.Value(jv.getValue()));
                    return mo.execute();
                }
                if (((String)macro).startsWith("[")) {
                    int closeBracketPos = ((String)macro).indexOf(93);
                    if (closeBracketPos != -1) {
                        if (!actual.isList()) {
                            return operation.fail("actual is not an array");
                        }
                        if (closeBracketPos > 1) {
                            String bracketContents = ((String)macro).substring(1, closeBracketPos);
                            List listAct = (List)actual.getValue();
                            int listSize = listAct.size();
                            context.JS.put("$", context.root.actual.getValue());
                            context.JS.put("_", listSize);
                            Object sizeExpr = this.containsPlaceholderUnderscore(bracketContents) ? bracketContents : bracketContents + " == _";
                            JsValue jv = context.JS.eval((String)sizeExpr);
                            context.JS.bindings.removeMember("$");
                            context.JS.bindings.removeMember("_");
                            if (!jv.isTrue()) {
                                return operation.fail("actual array length is " + listSize);
                            }
                        }
                        if (((String)macro).length() > closeBracketPos + 1 && (macro = StringUtils.trimToNull(((String)macro).substring(closeBracketPos + 1))) != null) {
                            if (((String)macro).startsWith("(") && ((String)macro).endsWith(")")) {
                                macro = ((String)macro).substring(1, ((String)macro).length() - 1);
                            }
                            if (((String)macro).startsWith("?")) {
                                macro = "#" + (String)macro;
                            }
                            if (((String)macro).startsWith("#")) {
                                MatchOperation mo = new MatchOperation(context, Match.Type.EACH_EQUALS.operator(this.isMatchEachEmptyAllowed()), actual, new Match.Value(macro));
                                mo.execute();
                                return mo.pass ? operation.pass() : operation.fail("all array elements matched");
                            }
                            Match.Type nestedType = CoreOperator.macroToMatchType(true, (String)macro);
                            int startPos = CoreOperator.matchTypeToStartPos(nestedType);
                            macro = ((String)macro).substring(startPos);
                            JsValue jv = context.JS.eval((String)macro);
                            MatchOperation mo = new MatchOperation(context, nestedType.operator(this.isMatchEachEmptyAllowed()), actual, new Match.Value(jv.getValue()));
                            return mo.execute();
                        }
                        return true;
                    }
                } else {
                    int questionPos = ((String)macro).indexOf(63);
                    String validatorName = null;
                    if (questionPos != -1 && !((String)macro).startsWith("regex")) {
                        validatorName = ((String)macro).substring(0, questionPos);
                        macro = ((String)macro).length() > questionPos + 1 ? StringUtils.trimToEmpty(((String)macro).substring(questionPos + 1)) : "";
                    } else {
                        validatorName = macro;
                        macro = "";
                    }
                    validatorName = StringUtils.trimToNull(validatorName);
                    if (validatorName != null) {
                        Match.Validator validator = null;
                        if (validatorName.startsWith("regex")) {
                            String regex = validatorName.substring(5).trim();
                            validator = new Match.RegexValidator(regex);
                        } else {
                            validator = Match.VALIDATORS.get(validatorName);
                        }
                        if (validator != null) {
                            if (!optional || !actual.isNotPresent() && !actual.isNull()) {
                                if (!optional && actual.isNotPresent()) {
                                    return expected.isNotPresent() || "#ignore".contentEquals(expected.getAsString());
                                }
                                Match.Result mr = (Match.Result)validator.apply(actual);
                                if (!mr.pass) {
                                    return operation.fail(mr.message);
                                }
                            }
                        } else if (!validatorName.startsWith("regex")) {
                            String actualValue = (String)actual.getValue();
                            return this.isContains() ? actualValue.contains(expStr) : actualValue.equals(expStr);
                        }
                    }
                    if ((macro = StringUtils.trimToNull((String)macro)) != null && questionPos != -1) {
                        context.JS.put("$", context.root.actual.getValue());
                        context.JS.put("_", actual.getValue());
                        JsValue jv = context.JS.eval((String)macro);
                        context.JS.bindings.removeMember("$");
                        context.JS.bindings.removeMember("_");
                        if (!jv.isTrue()) {
                            return operation.fail("evaluated to 'false'");
                        }
                    }
                }
            }
            return true;
        }

        private boolean containsPlaceholderUnderscore(String bracketContents) {
            Matcher m1 = UNDERSCORE_PATTERN.matcher(bracketContents);
            return m1.find();
        }

        private static Match.Type macroToMatchType(boolean each, String macro) {
            if (macro.startsWith("^^")) {
                return each ? Match.Type.EACH_CONTAINS_ONLY : Match.Type.CONTAINS_ONLY;
            }
            if (macro.startsWith("^+")) {
                return each ? Match.Type.EACH_CONTAINS_DEEP : Match.Type.CONTAINS_DEEP;
            }
            if (macro.startsWith("^*")) {
                return each ? Match.Type.EACH_CONTAINS_ANY : Match.Type.CONTAINS_ANY;
            }
            if (macro.startsWith("^")) {
                return each ? Match.Type.EACH_CONTAINS : Match.Type.CONTAINS;
            }
            if (macro.startsWith("!^")) {
                return each ? Match.Type.EACH_NOT_CONTAINS : Match.Type.NOT_CONTAINS;
            }
            if (macro.startsWith("!=")) {
                return each ? Match.Type.EACH_NOT_EQUALS : Match.Type.NOT_EQUALS;
            }
            return each ? Match.Type.EACH_EQUALS : Match.Type.EQUALS;
        }

        private static int matchTypeToStartPos(Match.Type mt) {
            return mt.shortcutLength;
        }

        private static BigDecimal toBigDecimal(Object o) {
            if (o instanceof BigDecimal) {
                return (BigDecimal)o;
            }
            if (o instanceof Number) {
                Number n = (Number)o;
                return BigDecimal.valueOf(n.doubleValue());
            }
            throw new RuntimeException("expected number instead of: " + String.valueOf(o));
        }

        private boolean actualEqualsExpected(MatchOperation operation) {
            Match.Value actual = operation.actual;
            Match.Value expected = operation.expected;
            Match.Context context = operation.context;
            switch (actual.type) {
                case NULL: {
                    return true;
                }
                case BOOLEAN: {
                    boolean actBoolean = (Boolean)actual.getValue();
                    boolean expBoolean = (Boolean)expected.getValue();
                    return actBoolean == expBoolean;
                }
                case NUMBER: {
                    if (actual.getValue() instanceof BigDecimal || expected.getValue() instanceof BigDecimal) {
                        BigDecimal expBigDecimal;
                        BigDecimal actBigDecimal = CoreOperator.toBigDecimal(actual.getValue());
                        return actBigDecimal.compareTo(expBigDecimal = CoreOperator.toBigDecimal(expected.getValue())) == 0;
                    }
                    Number actNumber = (Number)actual.getValue();
                    Number expNumber = (Number)expected.getValue();
                    return actNumber.doubleValue() == expNumber.doubleValue();
                }
                case STRING: {
                    return actual.getValue().equals(expected.getValue());
                }
                case BYTES: {
                    byte[] actBytes = (byte[])actual.getValue();
                    byte[] expBytes = (byte[])expected.getValue();
                    return Arrays.equals(actBytes, expBytes);
                }
                case LIST: {
                    List actList = (List)actual.getValue();
                    List expList = (List)expected.getValue();
                    int actListCount = actList.size();
                    int expListCount = expList.size();
                    if (actListCount != expListCount) {
                        return operation.fail("actual array length is not equal to expected - " + actListCount + ":" + expListCount);
                    }
                    for (int i = 0; i < actListCount; ++i) {
                        Match.Value actListValue = new Match.Value(actList.get(i));
                        Match.Value expListValue = new Match.Value(expList.get(i));
                        MatchOperation mo = new MatchOperation(context.descend(i), (MatchOperator)this.equalsOperator, actListValue, expListValue);
                        mo.execute();
                        if (mo.pass) continue;
                        return operation.fail("array match failed at index " + i);
                    }
                    return true;
                }
                case MAP: {
                    Map actMap = (Map)actual.getValue();
                    Map expMap = (Map)expected.getValue();
                    return this.matchMapValues(actMap, expMap, operation);
                }
                case XML: {
                    Map actXml = (Map)XmlUtils.toObject((Node)actual.getValue(), true);
                    Map expXml = (Map)XmlUtils.toObject((Node)expected.getValue(), true);
                    return this.matchMapValues(actXml, expXml, operation);
                }
                case OTHER: {
                    return actual.getValue().equals(expected.getValue());
                }
            }
            throw new RuntimeException("unexpected type (match equals): " + String.valueOf((Object)actual.type));
        }

        private boolean matchMapValues(Map<String, Object> actMap, Map<String, Object> expMap, MatchOperation operation) {
            if (actMap.size() > expMap.size() && (this.isEquals() || this.isContainsOnly())) {
                int sizeDiff = actMap.size() - expMap.size();
                LinkedHashMap<String, Object> diffMap = new LinkedHashMap<String, Object>(actMap);
                for (String key : expMap.keySet()) {
                    diffMap.remove(key);
                }
                return operation.fail("actual has " + sizeDiff + " more key(s) than expected - " + JsonUtils.toJson(diffMap));
            }
            LinkedHashSet<String> unMatchedKeysAct = new LinkedHashSet<String>(actMap.keySet());
            LinkedHashSet<String> unMatchedKeysExp = new LinkedHashSet<String>(expMap.keySet());
            for (Map.Entry<String, Object> expEntry : expMap.entrySet()) {
                String key = expEntry.getKey();
                Object childExp = expEntry.getValue();
                if (!actMap.containsKey(key)) {
                    String childString;
                    if (childExp instanceof String && ((childString = (String)childExp).startsWith("##") || childString.equals("#ignore") || childString.equals("#notpresent"))) {
                        if (this.isContainsAny()) {
                            return true;
                        }
                        unMatchedKeysExp.remove(key);
                        if (!unMatchedKeysExp.isEmpty() || !this.isContains()) continue;
                        return true;
                    }
                    if (!this.isContainsAny()) {
                        return operation.fail("actual does not contain key - '" + key + "'");
                    }
                }
                Match.Value childActValue = new Match.Value(actMap.get(key));
                MatchOperator childMatchType = this.childOperator(childActValue);
                MatchOperation mo = new MatchOperation(operation.context.descend(key), childMatchType, childActValue, new Match.Value(childExp));
                mo.execute();
                if (mo.pass) {
                    if (this.isContainsAny()) {
                        return true;
                    }
                    unMatchedKeysExp.remove(key);
                    if (unMatchedKeysExp.isEmpty() && this.isContains()) {
                        return true;
                    }
                    unMatchedKeysAct.remove(key);
                    continue;
                }
                if (!this.isEquals()) continue;
                return operation.fail("match failed for name: '" + key + "'");
            }
            if (this.isContainsAny()) {
                return unMatchedKeysExp.isEmpty() ? true : operation.fail("no key-values matched");
            }
            if (unMatchedKeysExp.isEmpty() && this.isContains()) {
                return true;
            }
            if (!unMatchedKeysExp.isEmpty()) {
                return operation.fail("all key-values did not match, expected has un-matched keys - " + String.valueOf(unMatchedKeysExp));
            }
            if (!unMatchedKeysAct.isEmpty()) {
                return operation.fail("all key-values did not match, actual has un-matched keys - " + String.valueOf(unMatchedKeysAct));
            }
            return true;
        }

        private boolean actualContainsExpected(MatchOperation operation) {
            Match.Value actual = operation.actual;
            Match.Value expected = operation.expected;
            Match.Context context = operation.context;
            switch (actual.type) {
                case STRING: {
                    String actString = (String)actual.getValue();
                    String expString = (String)expected.getValue();
                    return actString.contains(expString);
                }
                case LIST: {
                    List actList = (List)actual.getValue();
                    List expList = (List)expected.getValue();
                    int actListCount = actList.size();
                    int expListCount = expList.size();
                    boolean[] actVisitedList = new boolean[actListCount];
                    if (!this.isContainsAny() && expListCount > actListCount) {
                        return operation.fail("actual array length is less than expected - " + actListCount + ":" + expListCount);
                    }
                    if (this.isContainsOnly() && expListCount != actListCount) {
                        return operation.fail("actual array length is not equal to expected - " + actListCount + ":" + expListCount);
                    }
                    for (Object exp : expList) {
                        boolean found = false;
                        Match.Value expListValue = new Match.Value(exp);
                        for (int i = 0; i < actListCount; ++i) {
                            Match.Value actListValue = new Match.Value(actList.get(i));
                            MatchOperator childMatchType = this.childOperator(actListValue);
                            MatchOperation mo = new MatchOperation(context.descend(i), childMatchType, actListValue, expListValue);
                            mo.execute();
                            if (!mo.pass) continue;
                            if (this.isContainsAny()) {
                                return true;
                            }
                            if (this.isContainsOnly()) {
                                if (actVisitedList[i]) continue;
                                actVisitedList[i] = true;
                                found = true;
                                break;
                            }
                            found = true;
                            break;
                        }
                        if (found || this.isContainsAny()) continue;
                        return operation.fail("actual array does not contain expected item - " + expListValue.getAsString());
                    }
                    if (this.isContainsAny()) {
                        return operation.fail("actual array does not contain any of the expected items");
                    }
                    return true;
                }
                case MAP: {
                    Map actMap = (Map)actual.getValue();
                    Map expMap = (Map)expected.getValue();
                    return this.matchMapValues(actMap, expMap, operation);
                }
                case XML: {
                    Map actXml = (Map)XmlUtils.toObject((Node)actual.getValue());
                    Map expXml = (Map)XmlUtils.toObject((Node)expected.getValue());
                    return this.matchMapValues(actXml, expXml, operation);
                }
            }
            throw new RuntimeException("unexpected type (match contains): " + String.valueOf((Object)actual.type));
        }

        CoreOperator deep() {
            return new CoreOperator(this.isEquals, this.isContains, this.isContainsAny, this.isContainsOnly, true, this.matchEachEmptyAllowed);
        }

        static CoreOperator equalsOperator(boolean matchEachEmptyAllowed) {
            return new CoreOperator(true, false, false, false, matchEachEmptyAllowed);
        }

        static CoreOperator containsOperator(boolean matchEachEmptyAllowed) {
            return new CoreOperator(false, true, false, false, matchEachEmptyAllowed);
        }

        static CoreOperator containsAnyOperator(boolean matchEachEmptyAllowed) {
            return new CoreOperator(false, false, true, false, matchEachEmptyAllowed);
        }

        static CoreOperator containsOnlyOperator(boolean matchEachEmptyAllowed) {
            return new CoreOperator(false, false, false, true, matchEachEmptyAllowed);
        }

        boolean isEquals() {
            return this.isEquals;
        }

        boolean isContains() {
            return this.isContains;
        }

        boolean isContainsAny() {
            return this.isContainsAny;
        }

        boolean isContainsOnly() {
            return this.isContainsOnly;
        }

        boolean isContainsFamily() {
            return this.isContains() || this.isContainsOnly() || this.isContainsAny();
        }

        boolean isMatchEachEmptyAllowed() {
            return this.matchEachEmptyAllowed;
        }

        MatchOperator childOperator(Match.Value value) {
            return this.isDeep && value.isMapOrListOrXml() ? this : this.equalsOperator;
        }

        protected MatchOperator macroOperator(final MatchOperator specifiedOperator) {
            if (this.isContainsFamily()) {
                return this.isDeep ? this : new CoreOperator(false, this.isContains(), this.isContainsAny(), this.isContainsOnly(), this.isMatchEachEmptyAllowed()){

                    @Override
                    protected MatchOperator childOperator(Match.Value actual) {
                        return specifiedOperator;
                    }
                };
            }
            return specifiedOperator;
        }

        public String toString() {
            String operatorString = this.isEquals ? "EQUALS" : (this.isContains ? "CONTAINS" : (this.isContainsAny ? "CONTAINS_ANY" : "CONTAINS_ONLY"));
            return this.isDeep ? operatorString + "_DEEP" : operatorString;
        }
    }

    public static class NotOperator
    implements MatchOperator {
        private final CoreOperator delegate;
        private final String failureMessage;

        NotOperator(CoreOperator delegate, String failureMessage) {
            this.delegate = delegate;
            this.failureMessage = failureMessage;
        }

        public String toString() {
            return "NOT_" + String.valueOf(this.delegate);
        }

        @Override
        public boolean execute(MatchOperation operation) {
            Match.Value expected = operation.expected;
            if (this.delegate.isContains() && expected.isMap() && ((Map)expected.getValue()).isEmpty()) {
                return true;
            }
            MatchOperation mo = new MatchOperation(operation.context, (MatchOperator)this.delegate, operation.actual, expected);
            mo.execute();
            if (!mo.pass) {
                return operation.pass();
            }
            return operation.fail(this.failureMessage);
        }
    }

    public static class EachOperator
    implements MatchOperator {
        private final MatchOperator delegate;
        private final boolean matchEachEmptyAllowed;

        EachOperator(MatchOperator delegate, boolean matchEachEmptyAllowed) {
            this.delegate = delegate;
            this.matchEachEmptyAllowed = matchEachEmptyAllowed;
        }

        public String toString() {
            return "EACH_" + String.valueOf(this.delegate);
        }

        @Override
        public boolean execute(MatchOperation operation) {
            Match.Value actual = operation.actual;
            Match.Context context = operation.context;
            if (actual.isList()) {
                List list = (List)actual.getValue();
                if (list.isEmpty() && !this.matchEachEmptyAllowed) {
                    return operation.fail("match each failed, empty array / list");
                }
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    Object o = list.get(i);
                    context.JS.put("_$", o);
                    MatchOperation mo = new MatchOperation(context.descend(i), this.delegate, new Match.Value(o), operation.expected);
                    mo.execute();
                    context.JS.bindings.removeMember("_$");
                    if (mo.pass) continue;
                    return operation.fail("match each failed at index " + i);
                }
                return true;
            }
            return operation.fail("actual is not an array or list");
        }
    }
}

