/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Actions;
import com.intuit.karate.MatchStep;
import com.intuit.karate.core.AssignType;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.When;
import java.util.List;
import java.util.Map;

public class ScenarioActions
implements Actions {
    private final ScenarioEngine engine;

    public ScenarioActions(ScenarioEngine engine) {
        this.engine = engine;
    }

    @Override
    public boolean isFailed() {
        return this.engine.isFailed();
    }

    @Override
    public Throwable getFailedReason() {
        return this.engine.getFailedReason();
    }

    @Override
    public boolean isAborted() {
        return this.engine.isAborted();
    }

    @Override
    @When(value="^configure ([^\\s]+) =$")
    public void configureDocString(String key, String exp) {
        this.engine.configure(key, exp);
    }

    @Override
    @When(value="^configure\\h+([^\\s]+)\\h+= (.+)")
    public void configure(String key, String exp) {
        this.engine.configure(key, exp);
    }

    @Override
    @When(value="^url (.+)")
    public void url(String exp) {
        this.engine.url(exp);
    }

    @Override
    @When(value="^path (.+)")
    public void path(String exp) {
        this.engine.path(exp);
    }

    @Override
    @When(value="^param\\h+([^\\s]+)\\h+= (.+)")
    public void param(String name, String exp) {
        this.engine.param(name, exp);
    }

    @Override
    @When(value="^params (.+)")
    public void params(String exp) {
        this.engine.params(exp);
    }

    @Override
    @When(value="^cookie\\h+([^\\s]+)\\h+= (.+)")
    public void cookie(String name, String value) {
        this.engine.cookie(name, value);
    }

    @Override
    @When(value="^cookies (.+)")
    public void cookies(String exp) {
        this.engine.cookies(exp);
    }

    @Override
    @When(value="^csv (.+) = (.+)")
    public void csv(String name, String exp) {
        this.engine.assign(AssignType.CSV, name, exp, false);
    }

    @Override
    @When(value="^csv (.+) =$")
    public void csvDocString(String name, String exp) {
        this.engine.assign(AssignType.CSV, name, exp, true);
    }

    @Override
    @When(value="^header\\h+([^\\s]+)\\h+= (.+)")
    public void header(String name, String exp) {
        this.engine.header(name, exp);
    }

    @Override
    @When(value="^headers (.+)")
    public void headers(String exp) {
        this.engine.headers(exp);
    }

    @Override
    @When(value="^form field\\h+([^\\s]+)\\h+= (.+)")
    public void formField(String name, String exp) {
        this.engine.formField(name, exp);
    }

    @Override
    @When(value="^form fields (.+)")
    public void formFields(String exp) {
        this.engine.formFields(exp);
    }

    @Override
    @When(value="^request$")
    public void requestDocString(String body) {
        this.engine.request(body);
    }

    @Override
    @When(value="^request (.+)")
    public void request(String body) {
        this.engine.request(body);
    }

    @Override
    @When(value="^table (.+)")
    public void table(String name, List<Map<String, String>> table) {
        this.engine.table(name, table);
    }

    @Override
    @When(value="^replace (\\w+)$")
    public void replace(String name, List<Map<String, String>> table) {
        this.engine.replaceTable(name, table);
    }

    @Override
    @When(value="^replace\\h+(\\w+).([^\\s]+)\\h+= (.+)")
    public void replace(String name, String token, String value) {
        this.engine.replace(name, token, value);
    }

    @Override
    @When(value="^def\\h+(\\w+)\\h+=\\h+(.+)")
    public void def(String name, String exp) {
        this.engine.assign(AssignType.AUTO, name, exp, false);
    }

    @Override
    @When(value="^def (.+) =$")
    public void defDocString(String name, String exp) {
        this.engine.assign(AssignType.AUTO, name, exp, false);
    }

    @Override
    @When(value="^text (.+) =$")
    public void text(String name, String exp) {
        this.engine.assign(AssignType.TEXT, name, exp, true);
    }

    @Override
    @When(value="^yaml (.+) = (.+)")
    public void yaml(String name, String exp) {
        this.engine.assign(AssignType.YAML, name, exp, false);
    }

    @Override
    @When(value="^yaml (.+) =$")
    public void yamlDocString(String name, String exp) {
        this.engine.assign(AssignType.YAML, name, exp, true);
    }

    @Override
    @When(value="^copy (.+) = (.+)")
    public void copy(String name, String exp) {
        this.engine.assign(AssignType.COPY, name, exp, false);
    }

    @Override
    @When(value="^json (.+) = (.+)")
    public void json(String name, String exp) {
        this.engine.assign(AssignType.JSON, name, exp, false);
    }

    @Override
    @When(value="^string (.+) = (.+)")
    public void string(String name, String exp) {
        this.engine.assign(AssignType.STRING, name, exp, false);
    }

    @Override
    @When(value="^xml (.+) = (.+)")
    public void xml(String name, String exp) {
        this.engine.assign(AssignType.XML, name, exp, false);
    }

    @Override
    @When(value="^xmlstring (.+) = (.+)")
    public void xmlstring(String name, String exp) {
        this.engine.assign(AssignType.XML_STRING, name, exp, false);
    }

    @Override
    @When(value="^bytes (.+) = (.+)")
    public void bytes(String name, String exp) {
        this.engine.assign(AssignType.BYTE_ARRAY, name, exp, false);
    }

    @Override
    @When(value="^assert (.+)")
    public void assertTrue(String exp) {
        this.engine.assertTrue(exp);
    }

    @Override
    @When(value="^method\\h+(\\w+)")
    public void method(String method) {
        this.engine.method(method);
    }

    @Override
    @When(value="^retry until (.+)")
    public void retry(String until) {
        this.engine.retry(until);
    }

    @Override
    @When(value="^soap action( .+)?")
    public void soapAction(String action) {
        this.engine.soapAction(action);
    }

    @Override
    @When(value="^multipart entity (.+)")
    public void multipartEntity(String value) {
        this.engine.multipartField(null, value);
    }

    @Override
    @When(value="^multipart field (.+) = (.+)")
    public void multipartField(String name, String value) {
        this.engine.multipartField(name, value);
    }

    @Override
    @When(value="^multipart fields (.+)")
    public void multipartFields(String exp) {
        this.engine.multipartFields(exp);
    }

    @Override
    @When(value="^multipart file (.+) = (.+)")
    public void multipartFile(String name, String value) {
        this.engine.multipartFile(name, value);
    }

    @Override
    @When(value="^multipart files (.+)")
    public void multipartFiles(String exp) {
        this.engine.multipartFiles(exp);
    }

    @Override
    @When(value="^print (.+)")
    public void print(String exp) {
        this.engine.print(exp);
    }

    @Override
    @When(value="^status\\h+(\\d+)")
    public void status(int status) {
        this.engine.status(status);
    }

    @Override
    @When(value="^match (.+)(=|contains|any|only|deep)(.*)")
    public void match(String exp, String op1, String op2, String rhs) {
        if (op2 == null) {
            op2 = "";
        }
        rhs = rhs == null ? "" : " " + (String)rhs;
        MatchStep m = new MatchStep(exp + op1 + op2 + (String)rhs);
        this.engine.matchResult(m.type, m.name, m.path, m.expected);
    }

    @Override
    @When(value="^set\\h+([^\\s]+)( .+)? =$")
    public void setDocString(String name, String path, String value) {
        this.engine.set(name, path, value);
    }

    @Override
    @When(value="^set\\h+([^\\s]+)( .+)?\\h+= (.+)")
    public void set(String name, String path, String value) {
        this.engine.set(name, path, value);
    }

    @Override
    @When(value="^set ([^\\s]+)( [^=]+)?$")
    public void set(String name, String path, List<Map<String, String>> table) {
        this.engine.setViaTable(name, path, table);
    }

    @Override
    @When(value="^remove\\h+([^\\s]+)( .+)?")
    public void remove(String name, String path) {
        this.engine.remove(name, path);
    }

    @Override
    @When(value="^call (.+)")
    public void call(String line) {
        this.engine.call(false, line, true);
    }

    @Override
    @When(value="^callonce (.+)")
    public void callonce(String line) {
        this.engine.call(true, line, true);
    }

    @Override
    @When(value="^eval (.+)")
    public void eval(String exp) {
        this.engine.evalJs(exp);
    }

    @Override
    @When(value="^eval$")
    public void evalDocString(String exp) {
        this.engine.evalJs(exp);
    }

    @Override
    @When(value="^([\\w]+\\.[^=]+=$)")
    public void evalAssignDocString(String lhs, String rhs) {
        this.engine.evalJs(lhs + rhs);
    }

    @Override
    @When(value="^([\\w]+)([^\\s^\\w])(.+)")
    public void eval(String name, String dotOrParen, String exp) {
        this.engine.evalJs(name + dotOrParen + exp);
    }

    @Override
    @When(value="^if (.+)")
    public void evalIf(String exp) {
        this.engine.evalJs("if " + exp);
    }

    @Override
    @When(value="^delete (.+)")
    public void evalDelete(String exp) {
        this.engine.evalJs("delete " + exp);
    }

    @Override
    @When(value="^listen (.+)")
    public void listen(String body) {
        this.engine.listen(body);
    }

    @Override
    @When(value="^doc (.+)")
    public void doc(String exp) {
        this.engine.doc(exp);
    }

    @Override
    @When(value="^compareImage (.+)")
    public void compareImage(String exp) {
        this.engine.compareImage(exp);
    }

    @Override
    @When(value="^driver (.+)")
    public void driver(String exp) {
        this.engine.driver(exp);
    }

    @Override
    @When(value="^robot (.+)")
    public void robot(String exp) {
        this.engine.robot(exp);
    }
}

