/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.MockHandler;
import com.intuit.karate.core.MockInterceptor;
import com.intuit.karate.http.GenericHttpHeaderTracking;
import com.intuit.karate.http.HttpServer;
import com.intuit.karate.http.HttpServerHandler;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.ServerHandler;
import com.intuit.karate.http.SslContextFactory;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class MockServer
extends HttpServer {
    private MockServer(ServerBuilder sb) {
        super(sb);
    }

    public static Builder feature(String path) {
        return new Builder(Feature.read(path));
    }

    public static Builder feature(File file) {
        return new Builder(Feature.read(file));
    }

    public static Builder feature(Feature feature) {
        return new Builder(feature);
    }

    public static Builder featurePaths(List<String> paths) {
        return new Builder(paths.stream().map(p -> Feature.read(p)).collect(Collectors.toList()));
    }

    public static Builder featurePaths(String ... paths) {
        return MockServer.featurePaths(Arrays.asList(paths));
    }

    public static Builder featureFiles(List<File> features) {
        return new Builder(features.stream().map(file -> Feature.read(file)).collect(Collectors.toList()));
    }

    public static Builder features(List<Feature> features) {
        return new Builder(features);
    }

    public static class Builder {
        final List<Feature> features;
        int port;
        boolean ssl;
        boolean watch;
        File certFile;
        File keyFile;
        Map<String, Object> args;
        String prefix = null;
        MockInterceptor interceptor = null;
        boolean keepOriginalHeaders;

        Builder(Feature feature) {
            this.features = Arrays.asList(feature);
        }

        Builder(List<Feature> features) {
            this.features = features;
        }

        public Builder watch(boolean value) {
            this.watch = value;
            return this;
        }

        public Builder http(int value) {
            this.port = value;
            return this;
        }

        public Builder https(int value) {
            this.ssl = true;
            this.port = value;
            return this;
        }

        public Builder certFile(File value) {
            this.certFile = value;
            return this;
        }

        public Builder keyFile(File value) {
            this.keyFile = value;
            return this;
        }

        public Builder pathPrefix(String prefix) {
            if (((String)prefix).charAt(0) != '/') {
                prefix = "/" + (String)prefix;
            }
            this.prefix = prefix;
            return this;
        }

        public Builder args(Map<String, Object> value) {
            this.args = value;
            return this;
        }

        public Builder arg(String name, Object value) {
            if (this.args == null) {
                this.args = new HashMap<String, Object>();
            }
            this.args.put(name, value);
            return this;
        }

        public Builder interceptor(MockInterceptor value) {
            this.interceptor = value;
            return this;
        }

        public Builder keepOriginalHeaders(boolean value) {
            this.keepOriginalHeaders = value;
            return this;
        }

        public MockServer build() {
            ServerBuilder sb = Server.builder();
            sb.requestTimeoutMillis(0L);
            if (this.ssl) {
                sb.https(this.port);
                SslContextFactory factory = new SslContextFactory();
                factory.setCertFile(this.certFile);
                factory.setKeyFile(this.keyFile);
                factory.build();
                sb.tls(factory.getCertFile(), factory.getKeyFile());
            } else {
                sb.http(this.port);
            }
            ServerHandler handler = this.watch ? new ReloadingMockHandler(this.features, this.args, this.prefix, this.interceptor) : new MockHandler(this.prefix, this.features, this.args, this.interceptor);
            HttpServerHandler.Builder serverHandlerBuilder = HttpServerHandler.Builder.builder();
            serverHandlerBuilder.handler(handler);
            if (this.keepOriginalHeaders) {
                GenericHttpHeaderTracking headerTracking = new GenericHttpHeaderTracking();
                sb.http1HeaderNaming(http2HeaderName -> headerTracking.getOriginalHeader(String.valueOf(http2HeaderName)));
                serverHandlerBuilder.httpHeaderTracking(headerTracking);
            }
            HttpServerHandler service = serverHandlerBuilder.build();
            sb.service("prefix:" + (this.prefix == null ? "/" : this.prefix), (HttpService)service);
            return new MockServer(sb);
        }
    }

    private static class ReloadingMockHandler
    implements ServerHandler {
        private final Map<String, Object> args;
        private MockHandler handler;
        private final LinkedHashMap<File, Long> files = new LinkedHashMap();
        private final String prefix;
        private final MockInterceptor interceptor;

        public ReloadingMockHandler(List<Feature> features, Map<String, Object> args, String prefix, MockInterceptor interceptor) {
            this.args = args;
            this.prefix = prefix;
            this.interceptor = interceptor;
            for (Feature f : features) {
                this.files.put(f.getResource().getFile(), f.getResource().getFile().lastModified());
            }
            logger.debug("watch mode init - {}", this.files);
            this.handler = new MockHandler(prefix, features, args, this.interceptor);
        }

        @Override
        public Response handle(Request request) {
            boolean reload = this.files.entrySet().stream().reduce(false, (modified, entry) -> ((File)entry.getKey()).lastModified() > (Long)entry.getValue(), (a, b) -> a != false || b != false);
            if (reload) {
                List<Feature> features = this.files.keySet().stream().map(f -> Feature.read(f)).collect(Collectors.toList());
                this.handler = new MockHandler(this.prefix, features, this.args, this.interceptor);
            }
            return this.handler.handle(request);
        }
    }
}

