/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ImageComparison;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.Logger;
import com.intuit.karate.Match;
import com.intuit.karate.RuntimeHook;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.AfterHookType;
import com.intuit.karate.core.AssignType;
import com.intuit.karate.core.Channel;
import com.intuit.karate.core.ChannelFactory;
import com.intuit.karate.core.Config;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.MockHandler;
import com.intuit.karate.core.PerfEvent;
import com.intuit.karate.core.Plugin;
import com.intuit.karate.core.PluginFactory;
import com.intuit.karate.core.ScenarioBridge;
import com.intuit.karate.core.ScenarioCall;
import com.intuit.karate.core.ScenarioFileReader;
import com.intuit.karate.core.ScenarioIterator;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Variable;
import com.intuit.karate.driver.Driver;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.Key;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.graal.JsFunction;
import com.intuit.karate.graal.JsLambda;
import com.intuit.karate.graal.JsValue;
import com.intuit.karate.http.ArmeriaHttpClient;
import com.intuit.karate.http.Cookies;
import com.intuit.karate.http.HttpClient;
import com.intuit.karate.http.HttpClientFactory;
import com.intuit.karate.http.HttpConstants;
import com.intuit.karate.http.HttpLogger;
import com.intuit.karate.http.HttpRequest;
import com.intuit.karate.http.HttpRequestBuilder;
import com.intuit.karate.http.Request;
import com.intuit.karate.http.ResourceType;
import com.intuit.karate.http.Response;
import com.intuit.karate.http.WebSocketClient;
import com.intuit.karate.http.WebSocketOptions;
import com.intuit.karate.resource.Resource;
import com.intuit.karate.resource.ResourceResolver;
import com.intuit.karate.shell.Command;
import com.intuit.karate.template.KarateEngineContext;
import com.intuit.karate.template.KarateTemplateEngine;
import com.intuit.karate.template.TemplateUtils;
import com.jayway.jsonpath.PathNotFoundException;
import java.io.File;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScenarioEngine {
    private static final org.slf4j.Logger LOGGER = LoggerFactory.getLogger(ScenarioEngine.class);
    private static final String KARATE = "karate";
    private static final String READ = "read";
    private static final String KEY = "Key";
    public static final String RESPONSE = "response";
    public static final String RESPONSE_HEADERS = "responseHeaders";
    public static final String RESPONSE_STATUS = "responseStatus";
    private static final String RESPONSE_BYTES = "responseBytes";
    private static final String RESPONSE_COOKIES = "responseCookies";
    private static final String RESPONSE_TIME = "responseTime";
    private static final String RESPONSE_TYPE = "responseType";
    private static final String LISTEN_RESULT = "listenResult";
    public static final String REQUEST = "request";
    public static final String REQUEST_URL_BASE = "requestUrlBase";
    public static final String REQUEST_URI = "requestUri";
    public static final String REQUEST_PATH = "requestPath";
    private static final String REQUEST_PARAMS = "requestParams";
    public static final String REQUEST_METHOD = "requestMethod";
    public static final String REQUEST_HEADERS = "requestHeaders";
    private static final String REQUEST_TIME_STAMP = "requestTimeStamp";
    public final ScenarioRuntime runtime;
    public final ScenarioFileReader fileReader;
    public final Map<String, Variable> vars;
    public final Logger logger;
    private final Function<String, Object> readFunction;
    private final ScenarioBridge bridge;
    private final Collection<RuntimeHook> hooks;
    private boolean aborted;
    private Throwable failedReason;
    protected JsEngine JS;
    private static final ThreadLocal<ScenarioEngine> THREAD_LOCAL = new ThreadLocal();
    private PerfEvent prevPerfEvent;
    protected HttpRequestBuilder requestBuilder;
    private HttpRequest httpRequest;
    private Request request;
    private Response response;
    private Config config;
    List<Channel> channels;
    private List<WebSocketClient> webSocketClients;
    private CompletableFuture SIGNAL = new CompletableFuture();
    protected Driver driver;
    protected Plugin robot;
    private KarateTemplateEngine templateEngine;
    private ResourceResolver resourceResolver;
    private static final String TOKEN = "token";
    private static final String PATH = "path";
    private static final Pattern VAR_AND_PATH_PATTERN = Pattern.compile("\\w+");
    private static final String VARIABLE_PATTERN_STRING = "[a-zA-Z][\\w]*";
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("[a-zA-Z][\\w]*");
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("^function[^(]*\\(");
    private static final Pattern JS_PLACEHODER = Pattern.compile("\\$\\{.*?\\}");

    public ScenarioEngine(Config config, ScenarioRuntime runtime, Map<String, Variable> vars, Logger logger) {
        this.config = config;
        this.runtime = runtime;
        this.hooks = runtime.featureRuntime.suite.hooks;
        this.fileReader = new ScenarioFileReader(this, runtime.featureRuntime);
        this.readFunction = s -> JsValue.fromJava(this.fileReader.readFile((String)s));
        this.bridge = new ScenarioBridge(this);
        this.vars = vars;
        this.logger = logger;
    }

    public static ScenarioEngine forTempUse(HttpClientFactory hcf) {
        FeatureRuntime fr = FeatureRuntime.forTempUse(hcf);
        ScenarioRuntime sr = new ScenarioIterator(fr).first();
        sr.engine.init();
        return sr.engine;
    }

    public static ScenarioEngine get() {
        return THREAD_LOCAL.get();
    }

    public static void set(ScenarioEngine se) {
        THREAD_LOCAL.set(se);
    }

    protected static void remove() {
        THREAD_LOCAL.remove();
    }

    public JsEngine getJsEngine() {
        return this.JS;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public void setAborted(boolean aborted) {
        this.aborted = aborted;
    }

    public boolean isFailed() {
        return this.failedReason != null;
    }

    public boolean isIgnoringStepErrors() {
        return !this.config.getContinueOnStepFailureMethods().isEmpty();
    }

    public void setFailedReason(Throwable failedReason) {
        this.failedReason = failedReason;
    }

    public Throwable getFailedReason() {
        return this.failedReason;
    }

    public void matchResult(Match.Type matchType, String expression, String path, String expected) {
        Match.Result mr = this.match(matchType, expression, path, expected);
        if (!mr.pass) {
            this.setFailedReason(new KarateException(mr.message));
        }
    }

    public void set(String name, String path, String exp) {
        this.set(name, path, exp, false, false);
    }

    public void remove(String name, String path) {
        try {
            this.set(name, path, null, true, false);
        }
        catch (Exception e) {
            this.logger.warn("remove failed: {}", e.getMessage());
        }
    }

    public void table(String name, List<Map<String, String>> rows) {
        name = StringUtils.trimToEmpty(name);
        ScenarioEngine.validateVariableName(name);
        ArrayList<LinkedHashMap<String, String>> result = new ArrayList<LinkedHashMap<String, String>>(rows.size());
        for (Map<String, String> map : rows) {
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>(map);
            ArrayList<String> toRemove = new ArrayList<String>(map.size());
            for (Map.Entry entry : row.entrySet()) {
                String exp = (String)entry.getValue();
                Variable sv = this.evalKarateExpression(exp);
                if (sv.isNull() && !ScenarioEngine.isWithinParentheses(exp)) {
                    toRemove.add((String)entry.getKey());
                    continue;
                }
                if (sv.isString()) {
                    entry.setValue(sv.getAsString());
                    continue;
                }
                entry.setValue((String)sv.getValue());
            }
            for (String string : toRemove) {
                row.remove(string);
            }
            result.add(row);
        }
        this.setVariable(name, result);
    }

    public void replace(String name, String token, String value) {
        Variable v = this.vars.get(name = name.trim());
        if (v == null) {
            throw new RuntimeException("no variable found with name: " + name);
        }
        String text = v.getAsString();
        String replaced = this.replacePlaceholderText(text, token, value);
        this.setVariable(name, replaced);
    }

    public void assertTrue(String expression) {
        if (!this.evalJs(expression).isTrue()) {
            String message = "did not evaluate to 'true': " + expression;
            this.setFailedReason(new KarateException(message));
        }
    }

    public void print(String exp) {
        if (!this.config.isPrintEnabled()) {
            return;
        }
        this.evalJs("karate.log('[print]'," + exp + ")");
    }

    public void invokeAfterHookIfConfigured(AfterHookType hookType) {
        Variable v;
        if (this.runtime.caller.depth > 0) {
            return;
        }
        switch (hookType) {
            case AFTER_SCENARIO: {
                v = this.config.getAfterScenario();
                break;
            }
            case AFTER_OUTLINE: {
                v = this.config.getAfterScenarioOutline();
                break;
            }
            case AFTER_FEATURE: {
                v = this.config.getAfterFeature();
                break;
            }
            default: {
                return;
            }
        }
        if (v.isJsOrJavaFunction()) {
            if (hookType == AfterHookType.AFTER_FEATURE) {
                ScenarioEngine.set(this);
            }
            try {
                this.executeFunction(v, new Object[0]);
            }
            catch (Exception e) {
                this.logger.warn("{} hook failed: {}", hookType.getPrefix(), String.valueOf(e));
            }
        }
    }

    public void logLastPerfEvent(String failureMessage) {
        if (this.prevPerfEvent != null && this.runtime.perfMode) {
            if (failureMessage != null) {
                this.prevPerfEvent.setFailed(true);
                this.prevPerfEvent.setMessage(failureMessage);
            }
            this.runtime.featureRuntime.perfHook.reportPerfEvent(this.prevPerfEvent);
        }
        this.prevPerfEvent = null;
    }

    public void capturePerfEvent(PerfEvent event) {
        this.logLastPerfEvent(null);
        this.prevPerfEvent = event;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        if (this.requestBuilder != null) {
            this.requestBuilder.client.setConfig(config);
        }
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getRequest() {
        if (this.request != null) {
            return this.request;
        }
        if (this.httpRequest != null) {
            this.request = this.httpRequest.toRequest();
            this.request.processBody();
            return this.request;
        }
        return null;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Response getResponse() {
        return this.response;
    }

    public HttpRequestBuilder getRequestBuilder() {
        return this.requestBuilder;
    }

    public void configure(String key, String exp) {
        Variable v = this.evalKarateExpression(exp);
        this.configure(key, v);
    }

    public void configure(String key, Variable v) {
        if (this.config.configure(key = StringUtils.trimToEmpty(key), v) && this.requestBuilder != null) {
            this.requestBuilder.client.setConfig(this.config);
        }
    }

    private void evalAsMap(String exp, BiConsumer<String, List<String>> fun) {
        Variable var = this.evalKarateExpression(exp);
        if (!var.isMap()) {
            this.logger.warn("did not evaluate to map {}: {}", exp, var);
            return;
        }
        Map map = (Map)var.getValue();
        map.forEach((k, v) -> {
            if (v instanceof List) {
                List list = (List)v;
                ArrayList<String> values = new ArrayList<String>(list.size());
                for (Object o : list) {
                    if (o == null) continue;
                    values.add(o.toString());
                }
                fun.accept((String)k, (List<String>)values);
            } else if (v != null) {
                fun.accept((String)k, Collections.singletonList(v.toString()));
            }
        });
    }

    public void url(String exp) {
        Variable var = this.evalKarateExpression(exp);
        this.requestBuilder.url(var.getAsString());
    }

    public void path(String exp) {
        Variable v;
        if (((String)exp).contains(",")) {
            exp = "[" + (String)exp + "]";
        }
        List list = (v = this.evalJs((String)exp)).isList() ? (List)v.getValue() : Collections.singletonList(v.getValue());
        for (Object o : list) {
            if (o == null) continue;
            this.requestBuilder.path(o.toString());
        }
    }

    public void param(String name, String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isList()) {
            this.requestBuilder.param(name, (List)var.getValue());
        } else {
            this.requestBuilder.param(name, var.getAsString());
        }
    }

    public void params(String expr) {
        this.evalAsMap(expr, (k, v) -> this.requestBuilder.param((String)k, (List<String>)v));
    }

    public void header(String name, String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isList()) {
            this.requestBuilder.header(name, (List)var.getValue());
        } else {
            this.requestBuilder.header(name, var.getAsString());
        }
    }

    public void headers(String expr) {
        this.evalAsMap(expr, (k, v) -> this.requestBuilder.header((String)k, (List<String>)v));
    }

    public void cookie(String name, String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isString()) {
            this.requestBuilder.cookie(name, var.getAsString());
        } else if (var.isMap()) {
            Map map = (Map)var.getValue();
            map.put("name", name);
            this.requestBuilder.cookie(map);
        }
    }

    public void cookies(String exp) {
        Variable var = this.evalKarateExpression(exp);
        Map<String, Map> cookies = Cookies.normalize(var.getValue());
        this.requestBuilder.cookies(cookies.values());
    }

    private void updateConfigCookies(Map<String, Map> cookies) {
        if (cookies == null) {
            return;
        }
        if (this.config.getCookies().isNull()) {
            this.config.setCookies(new Variable(cookies));
        } else {
            Map map = this.getOrEvalAsMap(this.config.getCookies(), new Object[0]);
            map.putAll(cookies);
            this.config.setCookies(new Variable(map));
        }
    }

    public void formField(String name, String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isList()) {
            this.requestBuilder.formField(name, var.getValue());
        } else {
            this.requestBuilder.formField(name, var.getAsString());
        }
    }

    public void formFields(String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isMap()) {
            Map map = (Map)var.getValue();
            map.forEach((k, v) -> this.requestBuilder.formField((String)k, v));
        } else {
            this.logger.warn("did not evaluate to map {}: {}", exp, var);
        }
    }

    public void multipartField(String name, String value) {
        Variable v = this.evalKarateExpression(value);
        HashMap map = new HashMap();
        map.put("value", v.getValue());
        this.multiPartInternal(name, map);
    }

    public void multipartFields(String exp) {
        this.multipartFiles(exp);
    }

    private void multiPartInternal(String name, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (name != null) {
            map.put("name", name);
        }
        if (value instanceof Number) {
            value = value.toString();
        }
        if (value instanceof Map) {
            map.putAll((Map)value);
            String toRead = (String)map.get(READ);
            if (toRead != null) {
                Resource resource = this.fileReader.toResource(toRead);
                if (resource.isFile()) {
                    File file = resource.getFile();
                    map.put("value", file);
                } else {
                    map.put("value", FileUtils.toBytes(resource.getStream()));
                }
            }
            this.requestBuilder.multiPart(map);
        } else if (value instanceof String) {
            map.put("value", (String)value);
            this.multiPartInternal(name, map);
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object o : list) {
                this.multiPartInternal(null, o);
            }
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace("did not evaluate to string, map or list {}: {}", name, value);
        }
    }

    public void multipartFile(String name, String exp) {
        Variable var = this.evalKarateExpression(exp);
        this.multiPartInternal(name, var.getValue());
    }

    public void multipartFiles(String exp) {
        Variable var = this.evalKarateExpression(exp);
        if (var.isMap()) {
            Map map = (Map)var.getValue();
            map.forEach((k, v) -> this.multiPartInternal((String)k, v));
        } else if (var.isList()) {
            List list = (List)var.getValue();
            for (Map map : list) {
                this.multiPartInternal(null, map);
            }
        } else {
            this.logger.warn("did not evaluate to map or list {}: {}", exp, var);
        }
    }

    public void request(String body) {
        Variable v = this.evalKarateExpression(body);
        this.requestBuilder.body(v.getValue());
    }

    public void soapAction(String exp) {
        String action = this.evalKarateExpression(exp).getAsString();
        if (action == null) {
            action = "";
        }
        this.requestBuilder.header("SOAPAction", action);
        this.requestBuilder.contentType("text/xml");
        this.method("POST");
    }

    public void retry(String condition) {
        this.requestBuilder.setRetryUntil(condition);
    }

    public void method(String method) {
        if (!HttpConstants.HTTP_METHODS.contains(method.toUpperCase())) {
            method = this.evalKarateExpression(method).getAsString();
        }
        this.requestBuilder.method(method);
        this.httpInvoke();
    }

    public Response httpInvoke() {
        if (this.requestBuilder.isRetry()) {
            this.httpInvokeWithRetries();
        } else {
            this.httpInvokeOnce();
        }
        this.requestBuilder.reset();
        return this.response;
    }

    private void httpInvokeOnce() {
        Object body;
        String responseType;
        Map<String, Object> headers;
        Map<String, Object> cookies = this.getOrEvalAsMap(this.config.getCookies(), new Object[0]);
        if (cookies != null) {
            this.requestBuilder.cookies(cookies.values());
        }
        if ((headers = this.config.getHeaders().isJsOrJavaFunction() ? this.getOrEvalAsMap(this.config.getHeaders(), this.requestBuilder.build()) : this.getOrEvalAsMap(this.config.getHeaders(), new Object[0])) != null) {
            this.requestBuilder.headers(headers);
        }
        this.httpRequest = this.requestBuilder.build();
        String perfEventName = null;
        if (this.runtime.perfMode) {
            perfEventName = this.runtime.featureRuntime.perfHook.getPerfEventName(this.httpRequest, this.runtime);
        }
        long startTime = System.currentTimeMillis();
        this.httpRequest.setStartTime(startTime);
        List<RuntimeHook> allHooks = this.getRuntimeHooks();
        allHooks.forEach(h -> h.beforeHttpCall(this.httpRequest, this.runtime));
        try {
            this.response = this.requestBuilder.client.invoke(this.httpRequest);
        }
        catch (Exception e) {
            String stacktrace;
            long endTime = System.currentTimeMillis();
            long responseTime = endTime - startTime;
            String message = "http call failed after " + responseTime + " milliseconds for url: " + this.httpRequest.getUrl();
            this.logger.error(e.getMessage() + ", " + message, new Object[0]);
            if (this.logger.isTraceEnabled() && (stacktrace = StringUtils.throwableToString(e)) != null) {
                this.logger.trace(stacktrace, new Object[0]);
            }
            if (perfEventName != null) {
                PerfEvent pe = new PerfEvent(startTime, endTime, perfEventName, 0);
                this.capturePerfEvent(pe);
            }
            throw new KarateException(message + "\n" + e.getMessage(), e);
        }
        startTime = this.httpRequest.getStartTime();
        long endTime = this.httpRequest.getEndTime();
        long responseTime = endTime - startTime;
        this.response.setResponseTime(responseTime);
        allHooks.forEach(h -> h.afterHttpCall(this.httpRequest, this.response, this.runtime));
        byte[] bytes = this.response.getBody();
        ResourceType resourceType = this.response.getResourceType();
        if (resourceType != null && resourceType.isBinary()) {
            responseType = "binary";
            body = bytes;
        } else {
            try {
                body = JsonUtils.fromBytes(bytes, true, resourceType);
            }
            catch (Exception e) {
                body = FileUtils.toString(bytes);
                this.logger.warn("auto-conversion of response failed: {}", e.getMessage());
            }
            responseType = body instanceof Map || body instanceof List ? "json" : (body instanceof Node ? "xml" : "string");
        }
        this.setHiddenVariable(REQUEST_TIME_STAMP, startTime);
        this.setVariable(RESPONSE_TIME, responseTime);
        this.setVariable(RESPONSE_STATUS, this.response.getStatus());
        this.setVariable(RESPONSE, body);
        if (this.config.isLowerCaseResponseHeaders()) {
            this.setVariable(RESPONSE_HEADERS, this.response.getHeadersWithLowerCaseNames());
        } else {
            this.setVariable(RESPONSE_HEADERS, this.response.getHeaders());
        }
        this.setHiddenVariable(RESPONSE_BYTES, bytes);
        this.setHiddenVariable(RESPONSE_TYPE, responseType);
        cookies = this.response.getCookies();
        this.updateConfigCookies(cookies);
        this.setHiddenVariable(RESPONSE_COOKIES, cookies);
        if (perfEventName != null) {
            PerfEvent pe = new PerfEvent(startTime, endTime, perfEventName, this.response.getStatus());
            this.capturePerfEvent(pe);
        }
    }

    private List<RuntimeHook> getRuntimeHooks() {
        return Stream.concat(this.hooks.stream(), Stream.of(this.requestBuilder.hook())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void httpInvokeWithRetries() {
        int maxRetries = this.config.getRetryCount();
        int sleep = this.config.getRetryInterval();
        int retryCount = 0;
        while (true) {
            Variable v;
            if (retryCount == maxRetries) {
                throw new KarateException("too many retry attempts: " + maxRetries);
            }
            if (retryCount > 0) {
                try {
                    this.logger.debug("sleeping before retry #{}", retryCount);
                    Thread.sleep(sleep);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.httpInvokeOnce();
                v = this.evalKarateExpression(this.requestBuilder.getRetryUntil());
            }
            catch (Exception e) {
                this.logger.warn("retry condition evaluation failed: {}", e.getMessage());
                v = Variable.NULL;
            }
            if (v.isTrue()) {
                if (retryCount <= 0) break;
                this.logger.debug("retry condition satisfied", new Object[0]);
                break;
            }
            this.logger.debug("retry condition not satisfied: {}", this.requestBuilder.getRetryUntil());
            ++retryCount;
        }
    }

    public void status(int status) {
        if (status != this.response.getStatus()) {
            String message = HttpLogger.getStatusFailureMessage(status, this.config, this.httpRequest, this.response);
            this.setFailedReason(new KarateException(message));
        }
    }

    public KeyStore getKeyStore(String trustStoreFile, String password, String type) {
        char[] passwordChars;
        if (trustStoreFile == null) {
            return null;
        }
        char[] cArray = passwordChars = password == null ? null : password.toCharArray();
        if (type == null) {
            type = KeyStore.getDefaultType();
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            InputStream is = this.fileReader.readFileAsStream(trustStoreFile);
            keyStore.load(is, passwordChars);
            this.logger.debug("key store key count for {}: {}", trustStoreFile, keyStore.size());
            return keyStore;
        }
        catch (Exception e) {
            this.logger.error("key store init failed: {}", e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static String getFactory(String channelType) {
        switch (channelType) {
            case "kafka": {
                return "io.karatelabs.kafka.KafkaChannelFactory";
            }
            case "grpc": {
                return "io.karatelabs.grpc.GrpcChannelFactory";
            }
            case "websocket": {
                return "io.karatelabs.websocket.WebsocketChannelFactory";
            }
            case "webhook": {
                return "io.karatelabs.webhook.WebhookChannelFactory";
            }
        }
        throw new RuntimeException("unknown channel type: " + channelType);
    }

    protected Object channelSession(String type) {
        String factoryClass = ScenarioEngine.getFactory(type);
        try {
            Class<?> clazz = Class.forName(factoryClass);
            ChannelFactory factory = (ChannelFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Map<String, Object> options = this.config.getCustomOptions().get(type);
            Channel channel = factory.create(this.runtime, options);
            if (this.channels == null) {
                this.channels = new ArrayList<Channel>();
            }
            this.channels.add(channel);
            return channel.init(this.runtime);
        }
        catch (KarateException ke) {
            throw ke;
        }
        catch (Exception e) {
            Object message = e instanceof ClassNotFoundException ? "cannot instantiate [" + type + "], is 'karate-" + type + "' included as a maven / gradle dependency ?" : e.getMessage();
            this.logger.error((String)message, new Object[0]);
            throw new RuntimeException((String)message, e);
        }
    }

    public void mockProceed(String requestUrlBase) {
        Request mockRequest;
        String urlBase = requestUrlBase == null ? (String)this.vars.get(REQUEST_URL_BASE).getValue() : requestUrlBase;
        this.requestBuilder.url(urlBase);
        this.requestBuilder.path((String)this.vars.get(REQUEST_PATH).getValue());
        this.requestBuilder.params((Map)this.vars.get(REQUEST_PARAMS).getValue());
        this.requestBuilder.method((String)this.vars.get(REQUEST_METHOD).getValue());
        this.requestBuilder.headers((Map)this.vars.get(REQUEST_HEADERS).getValue());
        this.requestBuilder.removeHeader("Content-Length");
        this.requestBuilder.body(this.vars.get(REQUEST).getValue());
        if (this.requestBuilder.client instanceof ArmeriaHttpClient && (mockRequest = MockHandler.LOCAL_REQUEST.get()) != null) {
            ArmeriaHttpClient client = (ArmeriaHttpClient)this.requestBuilder.client;
            client.setRequestContext(mockRequest.getRequestContext());
        }
        this.httpInvoke();
    }

    public Map<String, Object> mockConfigureHeaders() {
        return this.getOrEvalAsMap(this.config.getResponseHeaders(), new Object[0]);
    }

    public void mockAfterScenario() {
        if (this.config.getAfterScenario().isJsOrJavaFunction()) {
            this.executeFunction(this.config.getAfterScenario(), new Object[0]);
        }
    }

    public WebSocketClient webSocket(WebSocketOptions options) {
        WebSocketClient webSocketClient = new WebSocketClient(options, this.logger);
        webSocketClient.setEngine(this);
        if (this.webSocketClients == null) {
            this.webSocketClients = new ArrayList<WebSocketClient>();
        }
        this.webSocketClients.add(webSocketClient);
        return webSocketClient;
    }

    public void signal(Object result) {
        this.SIGNAL.complete(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen(String exp) {
        Variable v = this.evalKarateExpression(exp);
        int timeout = v.getAsInt();
        this.logger.debug("entered listen state with timeout: {}", timeout);
        Object listenResult = null;
        try {
            listenResult = this.SIGNAL.get(timeout, TimeUnit.MILLISECONDS);
            Thread.sleep(100L);
        }
        catch (Exception e) {
            this.logger.error("listen timed out: {}", String.valueOf(e));
        }
        this.SIGNAL = new CompletableFuture();
        Object object = JsFunction.LOCK;
        synchronized (object) {
            this.setHiddenVariable(LISTEN_RESULT, listenResult);
            this.logger.debug("exit listen state with result: {}", listenResult);
        }
    }

    public Command fork(boolean useLineFeed, List<String> args) {
        return this.fork(useLineFeed, Collections.singletonMap("args", args));
    }

    public Command fork(boolean useLineFeed, String line) {
        return this.fork(useLineFeed, Collections.singletonMap("line", line));
    }

    public Command fork(boolean useLineFeed, Map<String, Object> options) {
        Boolean start;
        Value funErr;
        Value funOut;
        Boolean redirectErrorStream;
        String workingDir;
        String[] args;
        List list;
        Boolean useShell = (Boolean)options.get("useShell");
        if (useShell == null) {
            useShell = false;
        }
        if ((list = (List)options.get("args")) == null) {
            String line = (String)options.get("line");
            if (line == null) {
                throw new RuntimeException("'line' or 'args' is required");
            }
            args = Command.tokenize(line);
        } else {
            args = list.toArray(new String[list.size()]);
        }
        if (useShell.booleanValue()) {
            args = Command.prefixShellArgs(args);
        }
        File workingFile = (workingDir = (String)options.get("workingDir")) == null ? null : new File(workingDir);
        Command command = new Command(useLineFeed, this.logger, null, null, workingFile, args);
        Map env = (Map)options.get("env");
        if (env != null) {
            command.setEnvironment(env);
        }
        if ((redirectErrorStream = (Boolean)options.get("redirectErrorStream")) != null) {
            command.setRedirectErrorStream(redirectErrorStream);
        }
        if ((funOut = Value.asValue((Object)options.get("listener"))).canExecute()) {
            command.setListener(new JsLambda(funOut));
        }
        if ((funErr = Value.asValue((Object)options.get("errorListener"))).canExecute()) {
            command.setErrorListener(new JsLambda(funErr));
        }
        if ((start = (Boolean)options.get("start")) == null) {
            start = true;
        }
        if (start.booleanValue()) {
            command.start();
        }
        return command;
    }

    private void autoDef(Plugin plugin, String instanceName) {
        for (String methodName : plugin.methodNames()) {
            String invoke = instanceName + "." + methodName;
            StringBuilder sb = new StringBuilder();
            sb.append("(function(){ if (arguments.length == 0) return ").append(invoke).append("();").append(" if (arguments.length == 1) return ").append(invoke).append("(arguments[0]);").append(" if (arguments.length == 2) return ").append(invoke).append("(arguments[0], arguments[1]);").append(" return ").append(invoke).append("(arguments[0], arguments[1], arguments[2]) })");
            this.setHiddenVariable(methodName, this.evalJs(sb.toString()));
        }
    }

    public void driver(String exp) {
        Variable v = this.evalKarateExpression(exp);
        if (this.driver == null || this.driver.isTerminated() || v.isMap()) {
            Map<String, Object> options = this.config.getCustomOptions().get("driver");
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            options.put("target", this.config.getDriverTarget());
            if (v.isMap()) {
                options.putAll((Map)v.getValue());
            }
            this.setDriver(DriverOptions.start(options, this.runtime));
        }
        if (v.isString()) {
            this.driver.setUrl(v.getAsString());
        }
    }

    public void robot(String exp) {
        Variable v = this.evalKarateExpression(exp);
        if (this.robot == null) {
            Map<String, Object> options = this.config.getCustomOptions().get("robot");
            if (options == null) {
                options = new HashMap<String, Object>();
            }
            if (v.isMap()) {
                options.putAll((Map)v.getValue());
            } else if (v.isString()) {
                options.put("window", v.getAsString());
            }
            try {
                Class<?> clazz = Class.forName("com.intuit.karate.robot.RobotFactory");
                PluginFactory factory = (PluginFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.robot = factory.create(this.runtime, options);
            }
            catch (KarateException ke) {
                throw ke;
            }
            catch (Exception e) {
                String message = "cannot instantiate robot, is 'karate-robot' included as a maven / gradle dependency ? " + e.getMessage();
                this.logger.error(message, new Object[0]);
                throw new RuntimeException(message, e);
            }
            this.setRobot(this.robot);
        }
    }

    public void setDriverToNull() {
        this.driver = null;
    }

    public void setDriver(Driver driver) {
        this.driver = driver;
        this.setHiddenVariable("driver", driver);
        if (this.robot != null) {
            this.logger.warn("'robot' is active, use 'driver.' prefix for driver methods", new Object[0]);
            return;
        }
        this.autoDef(driver, "driver");
        this.setHiddenVariable(KEY, Key.INSTANCE);
    }

    public void setRobot(Plugin robot) {
        this.robot = robot;
        this.setHiddenVariable("robot", robot);
        if (this.driver != null) {
            this.logger.warn("'driver' is active, use 'robot.' prefix for robot methods", new Object[0]);
            return;
        }
        this.autoDef(robot, "robot");
        this.setHiddenVariable(KEY, Key.INSTANCE);
    }

    public void stop(StepResult lastStepResult) {
        if (this.runtime.caller.isSharedScope()) {
            ScenarioEngine caller = this.runtime.caller.parentRuntime.engine;
            if (this.driver != null) {
                caller.setDriver(this.driver);
            }
            if (this.robot != null) {
                caller.setRobot(this.robot);
            }
            caller.webSocketClients = this.webSocketClients;
        } else if (this.runtime.caller.depth == 0) {
            if (this.webSocketClients != null) {
                this.webSocketClients.forEach(WebSocketClient::close);
            }
            if (this.driver != null) {
                DriverOptions options = this.driver.getOptions();
                if (options.stop) {
                    this.driver.quit();
                }
                if (options.target != null) {
                    this.logger.debug("custom target configured, attempting stop()", new Object[0]);
                    Map<String, Object> map = options.target.stop(this.runtime);
                    String video = (String)map.get("video");
                    this.embedVideo(video);
                } else {
                    if (options.afterStop != null) {
                        Command.execLine(null, options.afterStop);
                    }
                    this.embedVideo(options.videoFile);
                }
            }
            if (this.robot != null) {
                this.robot.afterScenario();
            }
            if (this.channels != null) {
                for (Channel channel : this.channels) {
                    channel.afterScenario();
                }
            }
        }
    }

    private void embedVideo(String path) {
        File videoFile;
        if (path != null && (videoFile = new File(path)).exists()) {
            Embed embed = this.runtime.embedVideo(videoFile);
            this.logger.debug("appended video to report: {}", embed);
        }
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    private ResourceResolver getResourceResolver() {
        if (this.resourceResolver != null) {
            return this.resourceResolver;
        }
        String prefixedPath = this.runtime.featureRuntime.rootFeature.featureCall.feature.getResource().getPrefixedParentPath();
        return new ResourceResolver(prefixedPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String renderHtml(Map<String, Object> options) {
        String path = (String)options.get(READ);
        if (path == null) {
            String html = (String)options.get("html");
            if (html == null) {
                this.logger.warn("'read' or 'html' property is mandatory: {}", options);
                return null;
            }
            KarateTemplateEngine stringEngine = TemplateUtils.forStrings(this.JS, this.getResourceResolver());
            return stringEngine.process(html);
        }
        if (this.templateEngine == null) {
            this.templateEngine = TemplateUtils.forResourceResolver(this.JS, this.getResourceResolver());
        }
        KarateEngineContext old = KarateEngineContext.get();
        try {
            String string = this.templateEngine.process(path);
            return string;
        }
        finally {
            KarateEngineContext.set(old);
        }
    }

    public void doc(String exp) {
        Variable v = this.evalKarateExpression(exp);
        if (v.isString()) {
            this.docInternal(Collections.singletonMap(READ, v.getAsString()));
        } else if (v.isMap()) {
            Map map = (Map)v.getValue();
            this.docInternal(map);
        } else {
            this.logger.warn("doc is not string or json: {}", v);
        }
    }

    protected String docInternal(Map<String, Object> options) {
        String html = this.renderHtml(options);
        if (html != null && !this.runtime.reportDisabled) {
            this.runtime.embed(FileUtils.toBytes(html), ResourceType.HTML);
        }
        return html;
    }

    public void compareImage(String exp) {
        Variable v = this.evalKarateExpression(exp);
        if (!v.isMap()) {
            throw new RuntimeException("invalid image comparison params: expected map");
        }
        this.compareImageInternal((Map)v.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> compareImageInternal(Map<String, Object> params) {
        Map<String, Object> options = this.getImageOptions(params.get("options"), "options");
        byte[] baselineImg = this.getImageBytes(params, "baseline");
        byte[] latestImg = this.getImageBytes(params, "latest");
        Map<String, Object> defaultOptions = this.getImageOptions(this.config.getImageComparisonOptions(), "defaultOptions");
        boolean embedUI = !Boolean.TRUE.equals(defaultOptions.get("hideUiOnSuccess"));
        Map<String, Object> result = null;
        try {
            result = ImageComparison.compare(baselineImg, latestImg, options, defaultOptions);
        }
        catch (ImageComparison.MismatchException e) {
            this.logger.error("image comparison failed: {}", e.getMessage());
            embedUI = true;
            result = e.data;
            if (!Boolean.TRUE.equals(defaultOptions.get("mismatchShouldPass"))) {
                throw e;
            }
        }
        finally {
            if (embedUI) {
                String diffJS = "newDiffUI(document.currentScript," + JsonUtils.toJson(result) + "," + JsonUtils.toJson(options) + "," + this.getImageHookFunction(options, defaultOptions, "onShowRebase") + "," + this.getImageHookFunction(options, defaultOptions, "onShowConfig") + ")";
                this.runtime.embed(JsonUtils.toBytes(diffJS), ResourceType.DEFERRED_JS);
            }
        }
        return result;
    }

    private byte[] getImageBytes(Map<String, Object> params, String paramName) {
        Object img = params.get(paramName);
        if (img == null) {
            return null;
        }
        if (img instanceof String) {
            return this.fileReader.readFileAsBytes((String)img);
        }
        if (img instanceof byte[]) {
            return (byte[])img;
        }
        throw new RuntimeException("invalid image comparison options: expected " + paramName + " to be one of string|byte[]");
    }

    private Map<String, Object> getImageOptions(Object obj, String objName) {
        if (obj == null) {
            return new HashMap<String, Object>();
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        throw new RuntimeException("invalid image comparison " + objName + ": expected map");
    }

    private String getImageHookFunction(Map<String, Object> options, Map<String, Object> defaultOptions, String name) {
        Object fn = options.containsKey(name) ? options.get(name) : defaultOptions.get(name);
        return fn == null ? null : fn.toString();
    }

    public void init() {
        this.JS = JsEngine.local();
        this.logger.trace("js context: {}", this.JS);
        this.runtime.magicVariables.forEach((k, v) -> this.JS.put((String)k, v));
        this.vars.forEach((k, v) -> this.JS.put((String)k, v.getValue()));
        if (this.runtime.caller.arg != null && this.runtime.caller.arg.isMap()) {
            Map arg = (Map)this.runtime.caller.arg.getValue();
            this.setVariables(arg);
        }
        this.JS.put(KARATE, this.bridge);
        this.JS.put(READ, this.readFunction);
        if (this.requestBuilder == null) {
            HttpClient client = this.runtime.featureRuntime.suite.clientFactory.create(this);
            this.requestBuilder = new HttpRequestBuilder(client);
        }
        if (!this.runtime.caller.isNone()) {
            ScenarioEngine caller = this.runtime.caller.parentRuntime.engine;
            if (caller.driver != null) {
                this.setDriver(caller.driver);
            }
            if (caller.robot != null) {
                this.setRobot(caller.robot);
            }
        }
    }

    protected Map<String, Variable> shallowCloneVariables() {
        HashMap<String, Variable> copy = new HashMap<String, Variable>(this.vars.size());
        this.vars.forEach((k, v) -> copy.put((String)k, v.copy(false)));
        return copy;
    }

    protected <T> Map<String, T> getOrEvalAsMap(Variable var, Object ... args) {
        if (var.isJsOrJavaFunction()) {
            Variable res = this.executeFunction(var, args);
            return res.isMap() ? (Map)res.getValue() : null;
        }
        return var.isMap() ? (Map)var.getValue() : null;
    }

    public Variable executeFunction(Variable var, Object ... args) {
        switch (var.type) {
            case JS_FUNCTION: {
                ProxyExecutable pe = (ProxyExecutable)var.getValue();
                Object result = JsEngine.execute(pe, args);
                return new Variable(result);
            }
            case JAVA_FUNCTION: {
                Function javaFunction = (Function)var.getValue();
                Object arg = args.length == 0 ? null : args[0];
                Object javaResult = javaFunction.apply(arg);
                return new Variable(JsValue.unWrap(javaResult));
            }
        }
        throw new RuntimeException("expected function, but was: " + String.valueOf(var));
    }

    public Variable evalJs(String js) {
        try {
            return new Variable(this.JS.eval(js));
        }
        catch (Exception e) {
            KarateException ke = JsEngine.fromJsEvalException(js, e, null);
            this.setFailedReason(ke);
            throw ke;
        }
    }

    public void setHiddenVariable(String key, Object value) {
        if (value instanceof Variable) {
            value = ((Variable)value).getValue();
        }
        this.JS.put(key, value);
    }

    public Object getVariable(String key) {
        return this.JS.get(key).getValue();
    }

    public boolean hasVariable(String key) {
        return this.JS.bindings.hasMember(key);
    }

    public void setVariable(String key, Object value) {
        Object o;
        Variable v;
        if (value instanceof Variable) {
            v = (Variable)value;
            o = v.getValue();
        } else {
            o = value;
            v = new Variable(value);
        }
        this.vars.put(key, v);
        if (this.JS != null) {
            this.JS.put(key, o);
        }
    }

    public void setVariables(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        map.forEach((k, v) -> this.setVariable((String)k, v));
    }

    public Map<String, Object> getAllVariablesAsMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(this.vars.size());
        this.vars.forEach((k, v) -> map.put((String)k, v == null ? null : (Object)v.getValue()));
        return map;
    }

    private static void validateVariableName(String name) {
        if (!ScenarioEngine.isValidVariableName(name)) {
            throw new RuntimeException("invalid variable name: " + name);
        }
        if (KARATE.equals(name)) {
            throw new RuntimeException("'karate' is a reserved name");
        }
        if (REQUEST.equals(name) || "url".equals(name)) {
            throw new RuntimeException("'" + name + "' is a reserved name, also use the form '* " + name + " <expression>' instead");
        }
    }

    private Variable evalAndCastTo(AssignType assignType, String exp, boolean docString) {
        Variable v = docString ? new Variable(exp) : this.evalKarateExpression(exp);
        switch (assignType) {
            case BYTE_ARRAY: {
                return new Variable(v.getAsByteArray());
            }
            case STRING: {
                return new Variable(v.getAsString());
            }
            case XML: {
                return new Variable(v.getAsXml());
            }
            case XML_STRING: {
                String xml = XmlUtils.toString(v.getAsXml());
                return new Variable(xml);
            }
            case JSON: {
                return new Variable(v.getValueAndForceParsingAsJson());
            }
            case YAML: {
                return new Variable(JsonUtils.fromYaml(v.getAsString()));
            }
            case CSV: {
                return new Variable(JsonUtils.fromCsv(v.getAsString()));
            }
            case COPY: {
                return v.copy(true);
            }
        }
        return v;
    }

    public void assign(AssignType assignType, String name, String exp, boolean docString) {
        name = StringUtils.trimToEmpty(name);
        ScenarioEngine.validateVariableName(name);
        if (this.vars.containsKey(name)) {
            LOGGER.debug("over-writing existing variable '{}' with new value: {}", (Object)name, (Object)exp);
        }
        this.setVariable(name, this.evalAndCastTo(assignType, exp, docString));
    }

    private static boolean isEmbeddedExpression(String text) {
        return text != null && (text.startsWith("#(") || text.startsWith("##(")) && text.endsWith(")");
    }

    private Map<String, Object> Map(Object callResult) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Variable evalEmbeddedExpressions(Variable value, boolean forMatch) {
        switch (value.type) {
            case STRING: 
            case MAP: 
            case LIST: {
                EmbedAction ea = this.recurseEmbeddedExpressions(value, forMatch);
                if (ea != null) {
                    return ea.remove ? Variable.NULL : new Variable(ea.value);
                }
                return value;
            }
            case XML: {
                this.recurseXmlEmbeddedExpressions((Node)value.getValue(), forMatch);
            }
        }
        return value;
    }

    private EmbedAction recurseEmbeddedExpressions(Variable node, boolean forMatch) {
        switch (node.type) {
            case LIST: {
                List list = (List)node.getValue();
                HashSet<Integer> indexesToRemove = new HashSet<Integer>();
                int count = list.size();
                for (int i = 0; i < count; ++i) {
                    EmbedAction ea = this.recurseEmbeddedExpressions(new Variable(list.get(i)), forMatch);
                    if (ea == null) continue;
                    if (ea.remove) {
                        indexesToRemove.add(i);
                        continue;
                    }
                    list.set(i, ea.value);
                }
                if (!indexesToRemove.isEmpty()) {
                    ArrayList copy = new ArrayList(count - indexesToRemove.size());
                    for (int i = 0; i < count; ++i) {
                        if (indexesToRemove.contains(i)) continue;
                        copy.add(list.get(i));
                    }
                    return EmbedAction.update(copy);
                }
                return null;
            }
            case MAP: {
                Map map = (Map)node.getValue();
                ArrayList keysToRemove = new ArrayList();
                map.forEach((k, v) -> {
                    EmbedAction ea = this.recurseEmbeddedExpressions(new Variable(v), forMatch);
                    if (ea != null) {
                        if (ea.remove) {
                            keysToRemove.add(k);
                        } else {
                            map.put(k, ea.value);
                        }
                    }
                });
                for (String key : keysToRemove) {
                    map.remove(key);
                }
                return null;
            }
            case XML: {
                return null;
            }
            case STRING: {
                String value = StringUtils.trimToNull((String)node.getValue());
                if (!ScenarioEngine.isEmbeddedExpression(value)) {
                    return null;
                }
                boolean optional = value.charAt(1) == '#';
                value = value.substring(optional ? 2 : 1);
                try {
                    JsValue result = this.JS.eval(value);
                    if (optional) {
                        if (result.isNull()) {
                            return EmbedAction.remove();
                        }
                        if (forMatch && (result.isObject() || result.isArray())) {
                            return null;
                        }
                    }
                    return EmbedAction.update(result.getValue());
                }
                catch (Exception e) {
                    this.logger.trace("embedded expression failed {}: {}", value, e.getMessage());
                    return null;
                }
            }
        }
        return null;
    }

    private void recurseXmlEmbeddedExpressions(Node node, boolean forMatch) {
        NamedNodeMap attribs;
        if (node.getNodeType() == 9) {
            node = node.getFirstChild();
        }
        int attribCount = (attribs = node.getAttributes()) == null ? 0 : attribs.getLength();
        HashSet<Attr> attributesToRemove = new HashSet<Attr>(attribCount);
        for (int i = 0; i < attribCount; ++i) {
            Attr attrib = (Attr)attribs.item(i);
            String value = attrib.getValue();
            if (!ScenarioEngine.isEmbeddedExpression(value = StringUtils.trimToNull(value))) continue;
            boolean optional = value.charAt(1) == '#';
            value = value.substring(optional ? 2 : 1);
            try {
                JsValue jv = this.JS.eval(value);
                if (optional && jv.isNull()) {
                    attributesToRemove.add(attrib);
                    continue;
                }
                attrib.setValue(jv.getAsString());
                continue;
            }
            catch (Exception e) {
                this.logger.trace("xml-attribute embedded expression failed, {}: {}", attrib.getName(), e.getMessage());
            }
        }
        for (Attr toRemove : attributesToRemove) {
            attribs.removeNamedItem(toRemove.getName());
        }
        NodeList nodeList = node.getChildNodes();
        int childCount = nodeList.getLength();
        ArrayList<Node> nodes = new ArrayList<Node>(childCount);
        for (int i = 0; i < childCount; ++i) {
            nodes.add(nodeList.item(i));
        }
        HashSet<Node> elementsToRemove = new HashSet<Node>(childCount);
        for (Node child : nodes) {
            String value = child.getNodeValue();
            if (value != null) {
                if (!ScenarioEngine.isEmbeddedExpression(value = StringUtils.trimToEmpty(value))) continue;
                boolean optional = value.charAt(1) == '#';
                value = value.substring(optional ? 2 : 1);
                try {
                    JsValue jv = this.JS.eval(value);
                    if (optional) {
                        if (jv.isNull()) {
                            elementsToRemove.add(child);
                            continue;
                        }
                        if (forMatch && (jv.isXml() || jv.isObject())) continue;
                        child.setNodeValue(jv.getAsString());
                        continue;
                    }
                    if (jv.isXml() || jv.isObject()) {
                        Node evalNode;
                        Node node2 = evalNode = jv.isXml() ? (Node)jv.getValue() : XmlUtils.fromMap((Map)jv.getValue());
                        if (evalNode.getNodeType() == 9) {
                            evalNode = evalNode.getFirstChild();
                        }
                        if (child.getNodeType() == 4) {
                            child.setNodeValue(XmlUtils.toString(evalNode));
                            continue;
                        }
                        evalNode = node.getOwnerDocument().importNode(evalNode, true);
                        child.getParentNode().replaceChild(evalNode, child);
                        continue;
                    }
                    child.setNodeValue(jv.getAsString());
                }
                catch (Exception e) {
                    this.logger.trace("xml embedded expression failed, {}: {}", child.getNodeName(), e.getMessage());
                }
                continue;
            }
            if (!child.hasChildNodes() && !child.hasAttributes()) continue;
            this.recurseXmlEmbeddedExpressions(child, forMatch);
        }
        for (Node toRemove : elementsToRemove) {
            Node parent = toRemove.getParentNode();
            Node grandParent = parent.getParentNode();
            grandParent.removeChild(parent);
        }
    }

    public String replacePlaceholderText(String text, String token, String replaceWith) {
        if (text == null) {
            return null;
        }
        if ((replaceWith = StringUtils.trimToNull(replaceWith)) == null) {
            return text;
        }
        try {
            Variable v = this.evalKarateExpression(replaceWith);
            replaceWith = v.getAsString();
        }
        catch (Exception e) {
            throw new RuntimeException("expression error (replace string values need to be within quotes): " + e.getMessage());
        }
        if (replaceWith == null) {
            return text;
        }
        if ((token = StringUtils.trimToNull((String)token)) == null) {
            return text;
        }
        char firstChar = ((String)token).charAt(0);
        if (Character.isLetterOrDigit(firstChar)) {
            token = "<" + (String)token + ">";
        }
        return text.replace((CharSequence)token, replaceWith);
    }

    public void replaceTable(String text, List<Map<String, String>> list) {
        if (text == null) {
            return;
        }
        if (list == null) {
            return;
        }
        for (Map<String, String> map : list) {
            String token = map.get(TOKEN);
            if (token == null) continue;
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            keys.remove(TOKEN);
            Iterator iterator = keys.iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)keys.iterator().next();
            String value = map.get(key);
            this.replace(text, token, value);
        }
    }

    public void set(String name, String path, Variable value) {
        this.set(name, path, false, value, false, false);
    }

    private void set(String name, String path, String exp, boolean delete, boolean viaTable) {
        this.set(name, path, ScenarioEngine.isWithinParentheses(exp), this.evalKarateExpression(exp), delete, viaTable);
    }

    private void set(String name, String path, boolean isWithinParentheses, Variable value, boolean delete, boolean viaTable) {
        Variable target;
        name = StringUtils.trimToEmpty(name);
        path = StringUtils.trimToNull(path);
        if (viaTable && value.isNull() && !isWithinParentheses) {
            return;
        }
        if (path == null) {
            StringUtils.Pair nameAndPath = ScenarioEngine.parseVariableAndPath(name);
            name = nameAndPath.left;
            path = nameAndPath.right;
        }
        Variable variable = target = this.JS.bindings.hasMember(name) ? new Variable(this.JS.get(name)) : null;
        if (ScenarioEngine.isXmlPath(path)) {
            if (target == null || target.isNull()) {
                if (viaTable) {
                    Document empty = XmlUtils.newDocument();
                    target = new Variable(empty);
                    this.setVariable(name, target);
                } else {
                    throw new RuntimeException("variable is null or not set '" + name + "'");
                }
            }
            Document doc = (Document)target.getValue();
            if (delete) {
                XmlUtils.removeByPath(doc, path);
            } else if (value.isXml()) {
                Node node = (Node)value.getValue();
                XmlUtils.setByPath(doc, path, node);
            } else if (value.isMap()) {
                Document node = XmlUtils.fromMap((Map)value.getValue());
                XmlUtils.setByPath(doc, path, node);
            } else {
                XmlUtils.setByPath((Node)doc, path, value.getAsString());
            }
            this.setVariable(name, new Variable(doc));
        } else {
            Json json;
            if (target == null || target.isNull()) {
                if (viaTable) {
                    json = path.startsWith("$[") && !path.startsWith("$['") ? Json.of("[]") : Json.of("{}");
                    target = new Variable(json.value());
                    this.setVariable(name, target);
                } else {
                    throw new RuntimeException("variable is null or not set '" + name + "'");
                }
            }
            if (!target.isMapOrList()) {
                throw new RuntimeException("cannot set json path on type: " + String.valueOf(target));
            }
            json = Json.of(target.getValue());
            if (delete) {
                json.remove(path);
            } else {
                json.set(path, value.getValue());
            }
        }
    }

    public void setViaTable(String name, String path, List<Map<String, String>> list) {
        name = StringUtils.trimToEmpty(name);
        if ((path = StringUtils.trimToNull(path)) == null) {
            StringUtils.Pair nameAndPath = ScenarioEngine.parseVariableAndPath(name);
            name = nameAndPath.left;
            path = nameAndPath.right;
        }
        for (Map<String, String> map : list) {
            String append = map.get(PATH);
            if (append == null) continue;
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            keys.remove(PATH);
            int columnCount = keys.size();
            for (int i = 0; i < columnCount; ++i) {
                String finalPath;
                Object suffix;
                String key = (String)keys.get(i);
                String expression = StringUtils.trimToNull(map.get(key));
                if (expression == null) continue;
                try {
                    int arrayIndex = Integer.valueOf(key);
                    suffix = "[" + arrayIndex + "]";
                }
                catch (NumberFormatException e) {
                    Object object = suffix = columnCount > 1 ? "[" + i + "]" : "";
                }
                if (append.startsWith("/") || path != null && path.startsWith("/")) {
                    finalPath = path == null ? append + (String)suffix : path + (String)suffix + "/" + append;
                } else {
                    if (path == null) {
                        path = "$";
                    }
                    finalPath = path + (String)suffix + "." + append;
                }
                this.set(name, finalPath, expression, false, true);
            }
        }
    }

    public static StringUtils.Pair parseVariableAndPath(String text) {
        Matcher matcher = VAR_AND_PATH_PATTERN.matcher(text);
        matcher.find();
        String name = text.substring(0, matcher.end());
        Object path = matcher.end() == text.length() ? "" : text.substring(matcher.end()).trim();
        if (!ScenarioEngine.isXmlPath((String)path) && !ScenarioEngine.isXmlPathFunction((String)path)) {
            path = "$" + (String)path;
        }
        return StringUtils.pair(name, (String)path);
    }

    public Match.Result match(Match.Type matchType, String expression, String path, String rhs) {
        Variable actual;
        String name = StringUtils.trimToEmpty(expression);
        if (ScenarioEngine.isDollarPrefixedJsonPath(name) || ScenarioEngine.isXmlPath(name)) {
            path = name;
            name = RESPONSE;
        }
        if (name.startsWith("$")) {
            name = name.substring(1);
        }
        if ((path = StringUtils.trimToNull(path)) == null) {
            if (name.startsWith("(")) {
                path = "$";
            } else {
                StringUtils.Pair pair = ScenarioEngine.parseVariableAndPath(name);
                name = pair.left;
                path = pair.right;
            }
        }
        if ("header".equals(name)) {
            return this.matchHeader(matchType, path, rhs);
        }
        if (ScenarioEngine.isXmlPathFunction(path) || !name.startsWith("(") && !path.endsWith(")") && !path.contains(").") && (ScenarioEngine.isDollarPrefixed(path) || ScenarioEngine.isJsonPath(path) || ScenarioEngine.isXmlPath(path))) {
            actual = this.evalKarateExpression(name);
            if (!(actual.isMap() || actual.isList() || ScenarioEngine.isXmlPath(path) || ScenarioEngine.isXmlPathFunction(path))) {
                actual = this.evalKarateExpression(expression);
                path = "$";
            }
        } else {
            actual = this.evalKarateExpression(expression);
            path = "$";
        }
        if (!"$".equals(path) && !"/".equals(path)) {
            actual = ScenarioEngine.isDollarPrefixed(path) ? this.evalJsonPath(actual, path) : ScenarioEngine.evalXmlPath(actual, path);
        }
        Variable expected = this.evalKarateExpression(rhs, true);
        return this.match(matchType, actual.getValue(), expected.getValue());
    }

    private Match.Result matchHeader(Match.Type matchType, String name, String exp) {
        Variable expected = this.evalKarateExpression(exp, true);
        String actual = this.response.getHeader(name);
        return this.match(matchType, actual, expected.getValue());
    }

    public Match.Result match(Match.Type matchType, Object actual, Object expected) {
        return Match.execute(this.JS, matchType, actual, expected, this.config.isMatchEachEmptyAllowed());
    }

    public static boolean isJavaScriptFunction(String text) {
        return FUNCTION_PATTERN.matcher(text).find();
    }

    public static boolean isValidVariableName(String name) {
        return VARIABLE_PATTERN.matcher(name).matches();
    }

    public static boolean hasJavaScriptPlacehoder(String exp) {
        return JS_PLACEHODER.matcher(exp).find();
    }

    public static final boolean isVariableAndSpaceAndPath(String text) {
        return text.matches("^[a-zA-Z][\\w]*\\s+.+");
    }

    public static final boolean isVariable(String text) {
        return VARIABLE_PATTERN.matcher(text).matches();
    }

    public static final boolean isWithinParentheses(String text) {
        return text != null && text.startsWith("(") && text.endsWith(")");
    }

    public static final boolean isCallSyntax(String text) {
        return text.startsWith("call ");
    }

    public static final boolean isCallOnceSyntax(String text) {
        return text.startsWith("callonce ");
    }

    public static final boolean isGetSyntax(String text) {
        return text.startsWith("get ") || text.startsWith("get[");
    }

    public static final boolean isJson(String text) {
        return text.startsWith("{") || text.startsWith("[");
    }

    public static final boolean isXml(String text) {
        return text.startsWith("<");
    }

    public static boolean isXmlPath(String text) {
        return text.startsWith("/");
    }

    public static boolean isXmlPathFunction(String text) {
        return text.matches("^[a-z-]+\\(.+");
    }

    public static final boolean isJsonPath(String text) {
        return text.indexOf(42) != -1 || text.contains("..") || text.contains("[?");
    }

    public static final boolean isDollarPrefixed(String text) {
        return text.startsWith("$");
    }

    public static final boolean isDollarPrefixedJsonPath(String text) {
        return text.startsWith("$.") || text.startsWith("$[") || text.equals("$");
    }

    public static StringUtils.Pair parseCallArgs(String line) {
        int pos = line.indexOf("read(");
        if (pos != -1) {
            pos = line.indexOf(41);
            if (pos == -1) {
                throw new RuntimeException("failed to parse call arguments: " + line);
            }
            return new StringUtils.Pair(line.substring(0, pos + 1), StringUtils.trimToNull(line.substring(pos + 1)));
        }
        pos = line.indexOf(32);
        if (pos == -1) {
            return new StringUtils.Pair(line, null);
        }
        return new StringUtils.Pair(line.substring(0, pos), StringUtils.trimToNull(line.substring(pos)));
    }

    public Variable call(Variable called, Variable arg, boolean sharedScope) {
        switch (called.type) {
            case JS_FUNCTION: 
            case JAVA_FUNCTION: {
                return arg == null ? this.executeFunction(called, new Object[0]) : this.executeFunction(called, arg.getValue());
            }
            case FEATURE: {
                Object callResult = this.callFeature((FeatureCall)called.getValue(), arg, -1, sharedScope);
                return new Variable(callResult);
            }
        }
        throw new RuntimeException("not a callable feature or js function: " + String.valueOf(called));
    }

    public Variable call(boolean callOnce, String exp, boolean sharedScope) {
        StringUtils.Pair pair = ScenarioEngine.parseCallArgs(exp);
        Variable called = this.evalKarateExpression(pair.left);
        Variable arg = pair.right == null ? null : this.evalKarateExpression(pair.right);
        Variable result = callOnce ? this.callOnce(exp, called, arg, sharedScope) : this.call(called, arg, sharedScope);
        result = new Variable(this.JS.attachAll(result.getValue()));
        if (sharedScope && result.isMap()) {
            this.setVariables((Map)result.getValue());
        }
        return result;
    }

    private Variable callOnceResult(ScenarioCall.Result result, boolean sharedScope) {
        if (sharedScope) {
            this.vars.clear();
            if (result.vars != null) {
                result.vars.forEach((k, v) -> this.vars.put((String)k, v.copy(false)));
            } else if (result.value != null) {
                if (result.value.isMap()) {
                    Map map = (Map)result.value.getValue();
                    map.forEach((k, v) -> this.vars.put((String)k, new Variable(JsonUtils.shallowCopy(v))));
                } else {
                    this.logger.warn("callonce: ignoring non-map value from result.value: {}", result.value);
                }
            }
            this.init();
            this.setConfig(new Config(result.config));
            return Variable.NULL;
        }
        return result.value.copy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Variable callOnce(String cacheKey, Variable called, Variable arg, boolean sharedScope) {
        Map<String, ScenarioCall.Result> CACHE = this.runtime.perfMode ? this.runtime.featureRuntime.suite.callOnceCache : this.runtime.featureRuntime.CALLONCE_CACHE;
        ScenarioCall.Result result = CACHE.get(cacheKey);
        if (result != null) {
            this.logger.trace("callonce cache hit for: {}", cacheKey);
            return this.callOnceResult(result, sharedScope);
        }
        long startTime = System.currentTimeMillis();
        this.logger.trace("callonce waiting for lock: {}", cacheKey);
        Map<String, ScenarioCall.Result> map = CACHE;
        synchronized (map) {
            result = CACHE.get(cacheKey);
            if (result != null) {
                long endTime = System.currentTimeMillis() - startTime;
                this.logger.warn("this thread waited {} milliseconds for callonce lock: {}", endTime, cacheKey);
                return this.callOnceResult(result, sharedScope);
            }
            this.logger.info(">> lock acquired, begin callonce: {}", cacheKey);
            Variable callResult = this.call(called, arg, sharedScope);
            Map<String, Variable> clonedVars = called.isFeature() && sharedScope ? this.shallowCloneVariables() : null;
            result = new ScenarioCall.Result(callResult.copy(false), new Config(this.config), clonedVars);
            CACHE.put(cacheKey, result);
            this.logger.info("<< lock released, cached callonce: {}", cacheKey);
            return this.callOnceResult(result, sharedScope);
        }
    }

    public Object callFeature(FeatureCall featureCall, Variable arg, int index, boolean sharedScope) {
        if (arg == null || arg.isMap()) {
            ScenarioCall call = new ScenarioCall(this.runtime, featureCall, arg);
            call.setLoopIndex(index);
            call.setSharedScope(sharedScope);
            FeatureRuntime fr = new FeatureRuntime(call);
            fr.run();
            THREAD_LOCAL.set(this);
            FeatureResult result = fr.result;
            this.runtime.addCallResult(result);
            if (result.isFailed()) {
                KarateException ke = result.getErrorMessagesCombined();
                throw ke;
            }
            return result.getVariables();
        }
        if (arg.isList() || arg.isJsOrJavaFunction()) {
            Iterator iterator;
            ArrayList<Object> result = new ArrayList<Object>();
            ArrayList<String> errors = new ArrayList<String>();
            int loopIndex = 0;
            boolean isList = arg.isList();
            Iterator iterator2 = iterator = isList ? ((List)arg.getValue()).iterator() : null;
            while (true) {
                Variable loopArg;
                if (!(loopArg = isList ? (iterator.hasNext() ? new Variable(iterator.next()) : Variable.NULL) : this.executeFunction(arg, loopIndex)).isMap()) {
                    if (isList) break;
                    this.logger.info("feature call loop function ended at index {}, returned: {}", loopIndex, loopArg);
                    break;
                }
                try {
                    Object loopResult = this.callFeature(featureCall, loopArg, loopIndex, sharedScope);
                    result.add(loopResult);
                }
                catch (Exception e) {
                    String message = "feature call loop failed at index: " + loopIndex + ", " + e.getMessage();
                    errors.add(message);
                    this.runtime.logError(message);
                    if (!isList) break;
                }
                ++loopIndex;
            }
            if (errors.isEmpty()) {
                return result;
            }
            String errorMessage = StringUtils.join(errors, "\n");
            throw new KarateException(errorMessage);
        }
        throw new RuntimeException("feature call argument is not a json object or array: " + String.valueOf(arg));
    }

    public Variable evalJsonPath(Variable v, String path) {
        Json json = Json.of(v.getValueAndForceParsingAsJson());
        try {
            return new Variable(json.get(path));
        }
        catch (PathNotFoundException e) {
            return Variable.NOT_PRESENT;
        }
    }

    public static Variable evalXmlPath(Variable xml, String path) {
        NodeList nodeList;
        Node doc = xml.getAsXml();
        try {
            nodeList = XmlUtils.getNodeListByPath(doc, path);
        }
        catch (Exception e) {
            String strValue = XmlUtils.getTextValueByPath(doc, path);
            Variable v = new Variable(strValue);
            if (path.startsWith("count")) {
                return new Variable(v.getAsInt());
            }
            return v;
        }
        int count = nodeList.getLength();
        if (count == 0) {
            return Variable.NOT_PRESENT;
        }
        if (count == 1) {
            return ScenarioEngine.nodeToValue(nodeList.item(0));
        }
        ArrayList list = new ArrayList();
        for (int i = 0; i < count; ++i) {
            Variable v = ScenarioEngine.nodeToValue(nodeList.item(i));
            list.add(v.getValue());
        }
        return new Variable(list);
    }

    private static Variable nodeToValue(Node node) {
        int childElementCount = XmlUtils.getChildElementCount(node);
        if (childElementCount == 0) {
            return new Variable(node.getTextContent());
        }
        if (node.getNodeType() == 9) {
            return new Variable(node);
        }
        return new Variable(XmlUtils.toNewDocument(node));
    }

    public Variable evalJsonPathOnVariableByName(String name, String path) {
        Variable v = new Variable(this.JS.get(name));
        return this.evalJsonPath(v, path);
    }

    public Variable evalXmlPathOnVariableByName(String name, String path) {
        Variable v = new Variable(this.JS.get(name));
        return ScenarioEngine.evalXmlPath(v, path);
    }

    public Variable evalKarateExpression(String text) {
        return this.evalKarateExpression(text, false);
    }

    public Variable evalKarateExpression(String text, boolean forMatch) {
        if ((text = StringUtils.trimToNull((String)text)) == null) {
            return Variable.NULL;
        }
        if (this.JS.bindings.hasMember((String)text)) {
            return new Variable(this.JS.get((String)text));
        }
        boolean callOnce = ScenarioEngine.isCallOnceSyntax((String)text);
        if (callOnce || ScenarioEngine.isCallSyntax((String)text)) {
            text = callOnce ? ((String)text).substring(9) : ((String)text).substring(5);
            return this.call(callOnce, (String)text, false);
        }
        if (ScenarioEngine.isDollarPrefixedJsonPath((String)text)) {
            return this.evalJsonPathOnVariableByName(RESPONSE, (String)text);
        }
        if (ScenarioEngine.isGetSyntax((String)text) || ScenarioEngine.isDollarPrefixed((String)text)) {
            List list;
            String right;
            String left;
            int index = -1;
            if (((String)text).startsWith("$")) {
                text = ((String)text).substring(1);
            } else if (((String)text).startsWith("get[")) {
                int pos = ((String)text).indexOf(93);
                index = Integer.valueOf(((String)text).substring(4, pos));
                text = ((String)text).substring(pos + 2);
            } else {
                text = ((String)text).substring(4);
            }
            if (ScenarioEngine.isDollarPrefixedJsonPath((String)text)) {
                left = RESPONSE;
                right = text;
            } else if (ScenarioEngine.isVariableAndSpaceAndPath((String)text)) {
                int pos = ((String)text).indexOf(32);
                right = ((String)text).substring(pos + 1);
                left = ((String)text).substring(0, pos);
            } else {
                StringUtils.Pair pair = ScenarioEngine.parseVariableAndPath((String)text);
                left = pair.left;
                right = pair.right;
            }
            Variable sv = ScenarioEngine.isXmlPath(right) || ScenarioEngine.isXmlPathFunction(right) ? this.evalXmlPathOnVariableByName(left, right) : this.evalJsonPathOnVariableByName(left, right);
            if (index != -1 && sv.isList() && !(list = (List)sv.getValue()).isEmpty()) {
                return new Variable(list.get(index));
            }
            return sv;
        }
        if (ScenarioEngine.isJson((String)text)) {
            Json json = Json.of(text);
            return this.evalEmbeddedExpressions(new Variable(json.value()), forMatch);
        }
        if (ScenarioEngine.isXml((String)text)) {
            Document doc = XmlUtils.toXmlDoc((String)text, this.config.isXmlNamespaceAware());
            return this.evalEmbeddedExpressions(new Variable(doc), forMatch);
        }
        if (ScenarioEngine.isXmlPath((String)text)) {
            return this.evalXmlPathOnVariableByName(RESPONSE, (String)text);
        }
        if (ScenarioEngine.isJavaScriptFunction((String)text)) {
            text = "(" + (String)text + ")";
        }
        return this.evalJs((String)text);
    }

    private static class EmbedAction {
        final boolean remove;
        final Object value;

        private EmbedAction(boolean remove, Object value) {
            this.remove = remove;
            this.value = value;
        }

        static EmbedAction remove() {
            return new EmbedAction(true, null);
        }

        static EmbedAction update(Object value) {
            return new EmbedAction(false, value);
        }
    }
}

