/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.FeatureRuntime;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioEngine;
import com.intuit.karate.core.ScenarioRuntime;
import com.intuit.karate.core.Variable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;

public class ScenarioIterator
implements Spliterator<ScenarioRuntime> {
    private final FeatureRuntime featureRuntime;
    private final Iterator<FeatureSection> sections;
    private Iterator<Scenario> scenarios;
    private Scenario currentScenario;
    private ScenarioRuntime dynamicRuntime;
    private Variable expressionValue;
    private int index;

    public ScenarioIterator(FeatureRuntime featureRuntime) {
        this.featureRuntime = featureRuntime;
        this.sections = featureRuntime.featureCall.feature.getSections().iterator();
    }

    public Stream<ScenarioRuntime> filterSelected() {
        return StreamSupport.stream(this, false).filter(sr -> sr.selectedForExecution);
    }

    public ScenarioRuntime first() {
        return this.filterSelected().findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAdvance(Consumer<? super ScenarioRuntime> action) {
        if (this.currentScenario == null) {
            if (this.scenarios == null) {
                if (this.sections.hasNext()) {
                    FeatureSection section = this.sections.next();
                    this.scenarios = section.isOutline() ? section.getScenarioOutline().getScenarios(this.featureRuntime).iterator() : Collections.singletonList(section.getScenario()).iterator();
                } else {
                    return false;
                }
            }
            if (this.scenarios.hasNext()) {
                this.currentScenario = this.scenarios.next();
                this.index = 0;
                this.expressionValue = null;
            } else {
                this.scenarios = null;
                return this.tryAdvance(action);
            }
        }
        if (this.currentScenario.isDynamic()) {
            Variable rowValue;
            Logger logger;
            block24: {
                logger = FeatureRuntime.logger;
                if (this.expressionValue == null) {
                    this.dynamicRuntime = new ScenarioRuntime(this.featureRuntime, this.currentScenario);
                    if (!this.dynamicRuntime.selectedForExecution) {
                        this.currentScenario = null;
                        return this.tryAdvance(action);
                    }
                    String expression = this.currentScenario.getDynamicExpression();
                    ScenarioEngine prevEngine = ScenarioEngine.get();
                    try {
                        ScenarioEngine.set(this.dynamicRuntime.engine);
                        this.dynamicRuntime.engine.init();
                        this.expressionValue = this.dynamicRuntime.engine.evalJs(expression);
                        if (this.expressionValue.isList()) break block24;
                        if (this.expressionValue.isJsOrJavaFunction()) {
                            break block24;
                        }
                        throw new RuntimeException("result is neither list nor function: " + String.valueOf(this.expressionValue));
                    }
                    catch (Exception e) {
                        String message = String.valueOf(this.currentScenario) + " dynamic expression evaluation failed: " + expression;
                        logger.error(message);
                        this.dynamicRuntime.result.addFakeStepResult(message, e);
                        this.currentScenario = null;
                        action.accept(this.dynamicRuntime);
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        ScenarioEngine.set(prevEngine);
                    }
                }
            }
            int rowIndex = this.index++;
            if (this.expressionValue.isJsOrJavaFunction()) {
                ScenarioEngine prevEngine = ScenarioEngine.get();
                try {
                    ScenarioEngine.set(this.dynamicRuntime.engine);
                    rowValue = this.dynamicRuntime.engine.executeFunction(this.expressionValue, rowIndex);
                }
                catch (Exception e) {
                    String message = String.valueOf(this.currentScenario) + " dynamic function expression evaluation failed at index " + rowIndex + ": " + e.getMessage();
                    logger.error(message);
                    this.dynamicRuntime.result.addFakeStepResult(message, e);
                    this.currentScenario = null;
                    action.accept(this.dynamicRuntime);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    ScenarioEngine.set(prevEngine);
                }
            } else {
                List list = (List)this.expressionValue.getValue();
                if (rowIndex >= list.size()) {
                    this.currentScenario = null;
                    return this.tryAdvance(action);
                }
                rowValue = new Variable(list.get(rowIndex));
            }
            if (rowValue.isMap()) {
                Scenario dynamic = this.currentScenario.copy(rowIndex);
                Map map = (Map)rowValue.getValue();
                dynamic.setExampleData(map);
                map.forEach((k, v) -> {
                    Variable var = new Variable(v);
                    dynamic.replace("<" + k + ">", var.getAsString());
                });
                action.accept(new ScenarioRuntime(this.featureRuntime, dynamic));
                return true;
            }
            this.dynamicRuntime.logger.info("dynamic expression complete at index: {}, not map-like: {}", rowIndex, rowValue);
            this.currentScenario = null;
            return this.tryAdvance(action);
        }
        action.accept(new ScenarioRuntime(this.featureRuntime, this.currentScenario));
        this.currentScenario = null;
        return true;
    }

    @Override
    public Spliterator<ScenarioRuntime> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return 0L;
    }

    @Override
    public int characteristics() {
        return 0;
    }
}

