/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Json;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Embed;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepResult {
    private static final Map<String, Object> DUMMY_MATCH = new HashMap<String, Object>(2);
    private final Step step;
    private final Result result;
    private boolean hidden;
    private List<Embed> embeds;
    private List<FeatureResult> callResults;
    private String stepLog;
    private boolean errorIgnored = false;
    private Throwable failedReason;

    public String getErrorMessage() {
        if (this.result == null) {
            return null;
        }
        Throwable error = this.result.getError();
        return error == null ? null : error.getMessage();
    }

    public void appendToStepLog(String log) {
        if (log == null) {
            return;
        }
        if (this.stepLog == null) {
            this.stepLog = "";
        }
        this.stepLog = this.stepLog + log;
    }

    public void setStepLog(String stepLog) {
        this.stepLog = stepLog;
    }

    public void setCallResults(List<FeatureResult> callResults) {
        this.callResults = callResults;
    }

    public void addEmbeds(List<Embed> value) {
        if (value != null) {
            if (this.embeds == null) {
                this.embeds = new ArrayList<Embed>();
            }
            this.embeds.addAll(value);
        }
    }

    public void setCallResultsFromKarateJson(File workingDir, List<Map<String, Object>> list) {
        if (list != null) {
            this.callResults = new ArrayList<FeatureResult>(list.size());
            for (Map<String, Object> map : list) {
                FeatureResult fr = FeatureResult.fromKarateJson(workingDir, map);
                this.callResults.add(fr);
            }
        }
    }

    public static StepResult fromKarateJson(File workingDir, Scenario scenario, Map<String, Object> map) {
        Map stepMap = (Map)map.get("step");
        Step step = Step.fromKarateJson(scenario, stepMap);
        Result result = Result.fromKarateJson((Map)map.get("result"));
        StepResult sr = new StepResult(step, result);
        Boolean hidden = (Boolean)map.get("hidden");
        if (hidden != null) {
            sr.setHidden(hidden);
        }
        String stepLog = (String)map.get("stepLog");
        sr.setStepLog(stepLog);
        List embedsList = (List)map.get("embeds");
        if (embedsList != null) {
            ArrayList<Embed> embeds = new ArrayList<Embed>(embedsList.size());
            for (Map embedMap : embedsList) {
                Embed embed = Embed.fromKarateJson(embedMap);
                embeds.add(embed);
            }
            sr.addEmbeds(embeds);
        }
        sr.setCallResultsFromKarateJson(workingDir, (List)map.get("callResults"));
        return sr;
    }

    public Map<String, Object> toKarateJson() {
        ArrayList<Map<String, Object>> list;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("step", this.step.toKarateJson());
        map.put("result", this.result.toKarateJson());
        if (this.hidden) {
            map.put("hidden", this.hidden);
        }
        if (!StringUtils.isBlank(this.stepLog)) {
            map.put("stepLog", this.stepLog);
        }
        if (this.embeds != null && !this.embeds.isEmpty()) {
            list = new ArrayList<Map<String, Object>>(this.embeds.size());
            map.put("embeds", list);
            for (Embed embed : this.embeds) {
                list.add(embed.toKarateJson());
            }
        }
        if (this.callResults != null && !this.callResults.isEmpty()) {
            list = new ArrayList(this.callResults.size());
            map.put("callResults", list);
            for (FeatureResult fr : this.callResults) {
                list.add(Json.of(fr.toKarateJson()).asMap());
            }
        }
        return map;
    }

    private static List<Map> tableToCucumberJson(Table table) {
        List<List<String>> rows = table.getRows();
        ArrayList<Map> list = new ArrayList<Map>(rows.size());
        int count = rows.size();
        for (int i = 0; i < count; ++i) {
            List<String> row = rows.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("cells", row);
            map.put("line", table.getLineNumberForRow(i));
            list.add(map);
        }
        return list;
    }

    public Map<String, Object> toCucumberJson() {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("line", this.step.getLine());
        map.put("keyword", this.step.getPrefix());
        map.put("name", this.step.getText());
        map.put("result", this.result.toCucumberJson());
        map.put("match", DUMMY_MATCH);
        StringBuilder sb = new StringBuilder();
        if (this.step.getDocString() != null) {
            sb.append(this.step.getDocString());
        }
        if (this.stepLog != null) {
            sb.append(this.stepLog);
        }
        if (sb.length() > 0) {
            map.put("doc_string", StepResult.docStringToCucumberJson(this.step.getLine(), sb.toString()));
        }
        if (this.step.getTable() != null) {
            map.put("rows", StepResult.tableToCucumberJson(this.step.getTable()));
        }
        if (this.embeds != null) {
            ArrayList<Map> embedList = new ArrayList<Map>(this.embeds.size());
            for (Embed embed : this.embeds) {
                embedList.add(embed.toMap());
            }
            map.put("embeddings", embedList);
        }
        if (this.step.getComments() != null && !this.step.getComments().isEmpty()) {
            map.put("comments", this.step.getComments());
        }
        return map;
    }

    private static Map<String, Object> docStringToCucumberJson(int line, String text) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("content_type", "");
        map.put("line", line);
        map.put("value", text);
        return map;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isWithCallResults() {
        return this.callResults != null && !this.callResults.isEmpty();
    }

    public boolean isStopped() {
        return this.result.isFailed() || this.result.isAborted();
    }

    public boolean isFailed() {
        return this.result.isFailed();
    }

    public StepResult(Step step, Result result) {
        this.step = step;
        this.result = result;
    }

    public Step getStep() {
        return this.step;
    }

    public Result getResult() {
        return this.result;
    }

    public String getStepLog() {
        return this.stepLog;
    }

    public List<Embed> getEmbeds() {
        return this.embeds;
    }

    public void addEmbed(Embed embed) {
        if (this.embeds == null) {
            this.embeds = new ArrayList<Embed>();
        }
        this.embeds.add(embed);
    }

    public void addCallResults(List<FeatureResult> values) {
        if (this.callResults == null) {
            this.callResults = new ArrayList<FeatureResult>();
        }
        this.callResults.addAll(values);
    }

    public List<FeatureResult> getCallResults() {
        return this.callResults;
    }

    public boolean isErrorIgnored() {
        return this.errorIgnored;
    }

    public void setErrorIgnored(boolean errorIgnored) {
        this.errorIgnored = errorIgnored;
    }

    public Throwable getFailedReason() {
        return this.failedReason;
    }

    public void setFailedReason(Throwable failedReason) {
        this.failedReason = failedReason;
    }

    public String toString() {
        return "[" + String.valueOf(this.result) + "] " + String.valueOf(this.step);
    }

    static {
        DUMMY_MATCH.put("location", "karate");
        DUMMY_MATCH.put("arguments", Collections.EMPTY_LIST);
    }
}

