/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.Actions;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.ScenarioActions;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.When;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepRuntime {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepRuntime.class);
    private static final Collection<MethodPattern> PATTERNS;
    private static final Map<String, Collection<Method>> KEYWORDS_METHODS;
    public static final Collection<Method> METHOD_MATCH;

    private StepRuntime() {
    }

    private static List<MethodMatch> findMethodsMatching(String text) {
        ArrayList<MethodMatch> matches = new ArrayList<MethodMatch>(1);
        for (MethodPattern pattern : PATTERNS) {
            List<String> args = pattern.match(text);
            if (args == null) continue;
            matches.add(new MethodMatch(pattern.method, args));
        }
        return matches;
    }

    public static Collection<Method> findMethodsByKeywords(List<String> text) {
        HashSet<Method> methods = new HashSet<Method>();
        text.forEach(m -> methods.addAll(StepRuntime.findMethodsByKeyword(m)));
        return methods;
    }

    public static Collection<Method> findMethodsByKeyword(String text) {
        if (KEYWORDS_METHODS.get(text) != null) {
            return KEYWORDS_METHODS.get(text);
        }
        LOGGER.warn("No keyword found for {}. Potential unexpected behavior.", (Object)text);
        return new HashSet<Method>();
    }

    private static long getElapsedTimeNanos(long startTime) {
        return System.nanoTime() - startTime;
    }

    public static Result execute(Step step, Actions actions) {
        Object[] args;
        String text = step.getText();
        List<MethodMatch> matches = StepRuntime.findMethodsMatching(text);
        if (matches.isEmpty()) {
            KarateException e = new KarateException("no step-definition method match found for: " + text);
            return Result.failed(System.currentTimeMillis(), 0L, e, step);
        }
        if (matches.size() > 1) {
            boolean evalAssign = false;
            for (MethodMatch m : matches) {
                if (!m.getMethod().getName().equalsIgnoreCase("evalAssignDocString")) continue;
                evalAssign = true;
                matches = Collections.singletonList(m);
                break;
            }
            if (!evalAssign) {
                KarateException e = new KarateException("more than one step-definition method matched: " + text + " - " + String.valueOf(matches));
                return Result.failed(System.currentTimeMillis(), 0L, e, step);
            }
        }
        MethodMatch match = matches.get(0);
        Object last = step.getDocString() != null ? step.getDocString() : (step.getTable() != null ? step.getTable().getRowsAsMaps() : null);
        try {
            args = match.convertArgs(last);
        }
        catch (Exception ignored) {
            KarateException e = new KarateException("no step-definition method match found for: " + text);
            return Result.failed(System.currentTimeMillis(), 0L, e, step);
        }
        long startTime = System.currentTimeMillis();
        long startTimeNanos = System.nanoTime();
        try {
            match.method.invoke((Object)actions, args);
            long elapsedTimeNanos = StepRuntime.getElapsedTimeNanos(startTimeNanos);
            if (actions.isAborted()) {
                return Result.aborted(startTime, elapsedTimeNanos, match);
            }
            if (actions.isFailed()) {
                return Result.failed(startTime, elapsedTimeNanos, actions.getFailedReason(), step, match);
            }
            return Result.passed(startTime, elapsedTimeNanos, match);
        }
        catch (InvocationTargetException e) {
            return Result.failed(startTime, StepRuntime.getElapsedTimeNanos(startTimeNanos), e.getTargetException(), step, match);
        }
        catch (Exception e) {
            return Result.failed(startTime, StepRuntime.getElapsedTimeNanos(startTimeNanos), e, step, match);
        }
    }

    static {
        HashMap<String, MethodPattern> temp = new HashMap<String, MethodPattern>();
        ArrayList overwrite = new ArrayList();
        KEYWORDS_METHODS = new HashMap<String, Collection<Method>>();
        for (Method method : ScenarioActions.class.getMethods()) {
            When when = method.getDeclaredAnnotation(When.class);
            if (when == null) continue;
            String regex = when.value();
            MethodPattern methodPattern = new MethodPattern(method, regex);
            temp.put(regex, methodPattern);
            String keyword = method.getName().equalsIgnoreCase("eval") ? "eval" : methodPattern.keyword;
            Collection keywordMethods = KEYWORDS_METHODS.computeIfAbsent(keyword, k -> new HashSet());
            keywordMethods.add(methodPattern.method);
        }
        for (MethodPattern mp : overwrite) {
            temp.put(mp.regex, mp);
            String keyword = mp.method.getName().equalsIgnoreCase("eval") ? "eval" : mp.keyword;
            Collection keywordMethods = KEYWORDS_METHODS.computeIfAbsent(keyword, k -> new HashSet());
            keywordMethods.add(mp.method);
        }
        PATTERNS = temp.values();
        METHOD_MATCH = StepRuntime.findMethodsByKeyword("match");
    }

    static class MethodPattern {
        final String regex;
        final Method method;
        final Pattern pattern;
        final String keyword;

        MethodPattern(Method method, String regex) {
            this.regex = regex;
            this.method = method;
            try {
                this.pattern = Pattern.compile(regex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String keyword1 = regex.substring(1).split(" |\\\\h|\\\\s")[0];
            if (keyword1.endsWith("$")) {
                keyword1 = keyword1.substring(0, keyword1.length() - 1);
            }
            this.keyword = keyword1;
        }

        List<String> match(String text) {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.lookingAt()) {
                ArrayList<String> args = new ArrayList<String>(matcher.groupCount());
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    int startIndex = matcher.start(i);
                    args.add(startIndex == -1 ? null : matcher.group(i));
                }
                return args;
            }
            return null;
        }

        public String toString() {
            return "\n" + String.valueOf(this.pattern) + " " + this.method.toGenericString();
        }
    }

    public static class MethodMatch {
        private static final Pattern METHOD_REGEX_PATTERN = Pattern.compile("([a-zA-Z_$][a-zA-Z\\d_$\\.]*)*\\.([a-zA-Z_$][a-zA-Z\\d_$]*?)\\((.*)\\)");
        final Method method;
        final List<String> args;

        MethodMatch(Method method, List<String> args) {
            this.method = method;
            this.args = args;
        }

        Object[] convertArgs(Object last) {
            Class<?>[] types = this.method.getParameterTypes();
            Object[] result = new Object[types.length];
            int i = 0;
            for (String arg : this.args) {
                Class<?> type = types[i];
                result[i] = List.class.isAssignableFrom(type) ? StringUtils.split(arg, ',', false) : (Integer.TYPE.isAssignableFrom(type) ? Integer.valueOf(arg) : arg);
                ++i;
            }
            if (last != null) {
                result[i] = last;
            }
            return result;
        }

        public static MethodMatch getBySignatureAndArgs(String methodReference) {
            String methodSignature = methodReference.substring(0, methodReference.indexOf(32));
            String referenceArgs = methodReference.substring(methodReference.indexOf(32) + 1);
            Matcher methodMatch = METHOD_REGEX_PATTERN.matcher(methodSignature);
            Method method = null;
            if (methodMatch.find()) {
                try {
                    String className = methodMatch.group(1);
                    String methodName = methodMatch.group(2);
                    String params = methodMatch.group(3);
                    List<String> paramList = Arrays.asList(params.split(","));
                    method = Class.forName(className).getMethod(methodName, (Class[])paramList.stream().map(param -> {
                        try {
                            return Class.forName(param);
                        }
                        catch (ClassNotFoundException e) {
                            return null;
                        }
                    }).filter(Objects::nonNull).toArray(Class[]::new));
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    return null;
                }
            }
            List args = "null".equalsIgnoreCase(referenceArgs) ? null : Json.of(JsonUtils.fromJson(referenceArgs)).asList();
            return new MethodMatch(method, args);
        }

        public Method getMethod() {
            return this.method;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.method.getDeclaringClass().getName());
            sb.append(".");
            sb.append(this.method.getName());
            sb.append("(");
            StringJoiner sj = new StringJoiner(",");
            for (Class<?> parameterType : this.method.getParameterTypes()) {
                sj.add(parameterType.getTypeName());
            }
            sb.append(sj);
            sb.append(")");
            return sb.toString() + " " + (this.args == null || this.args.isEmpty() ? "null" : JsonUtils.toJson(this.args));
        }
    }
}

