/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.core.FeatureCall;
import com.intuit.karate.graal.JsValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class Variable {
    private static final Logger logger = LoggerFactory.getLogger(Variable.class);
    public static final Variable NULL = new Variable(null);
    public static final Variable NOT_PRESENT = new Variable("#notpresent");
    public final Type type;
    private final Object value;

    public Variable(Object o) {
        if (o instanceof Value) {
            o = new JsValue((Value)o).getValue();
        } else if (o instanceof JsValue) {
            o = ((JsValue)o).getValue();
        }
        this.type = o == null ? Type.NULL : (o instanceof ProxyExecutable ? Type.JS_FUNCTION : (o instanceof Value ? Type.OTHER : (o instanceof Function ? Type.JAVA_FUNCTION : (o instanceof Node ? Type.XML : (o instanceof List ? Type.LIST : (o instanceof Map ? Type.MAP : (o instanceof String ? Type.STRING : (Number.class.isAssignableFrom(o.getClass()) ? Type.NUMBER : (Boolean.class.equals(o.getClass()) ? Type.BOOLEAN : (o instanceof byte[] ? Type.BYTES : (o instanceof FeatureCall ? Type.FEATURE : Type.OTHER)))))))))));
        this.value = o;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public boolean isJsOrJavaFunction() {
        return this.type == Type.JS_FUNCTION || this.type == Type.JAVA_FUNCTION;
    }

    public boolean isJavaFunction() {
        return this.type == Type.JAVA_FUNCTION;
    }

    public boolean isJsFunction() {
        return this.type == Type.JS_FUNCTION;
    }

    public boolean isBytes() {
        return this.type == Type.BYTES;
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isList() {
        return this.type == Type.LIST;
    }

    public boolean isMap() {
        return this.type == Type.MAP;
    }

    public boolean isMapOrList() {
        return this.type == Type.MAP || this.type == Type.LIST;
    }

    public boolean isXml() {
        return this.type == Type.XML;
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isNull() {
        return this.type == Type.NULL;
    }

    public boolean isOther() {
        return this.type == Type.OTHER;
    }

    public boolean isFeature() {
        return this.type == Type.FEATURE;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isTrue() {
        return this.type == Type.BOOLEAN && (Boolean)this.value != false;
    }

    public String getTypeString() {
        return this.type.name().toLowerCase();
    }

    public Node getAsXml() {
        switch (this.type) {
            case XML: {
                return (Node)this.getValue();
            }
            case MAP: {
                return XmlUtils.fromMap((Map)this.getValue());
            }
            case STRING: 
            case BYTES: {
                String xml = this.getAsString();
                return XmlUtils.toXmlDoc(xml);
            }
            case OTHER: {
                return XmlUtils.fromJavaObject(this.value);
            }
        }
        throw new RuntimeException("cannot convert to xml:" + String.valueOf(this));
    }

    public Object getValueAndConvertIfXmlToMap() {
        return this.isXml() ? XmlUtils.toObject((Node)this.getValue()) : this.value;
    }

    public Object getValueAndForceParsingAsJson() {
        switch (this.type) {
            case MAP: 
            case LIST: {
                return this.value;
            }
            case STRING: 
            case BYTES: {
                return JsonUtils.fromJson(this.getAsString());
            }
            case XML: {
                return XmlUtils.toObject((Node)this.getValue());
            }
            case OTHER: {
                return Json.of(this.value).value();
            }
        }
        throw new RuntimeException("cannot convert to json: " + String.valueOf(this));
    }

    public byte[] getAsByteArray() {
        if (this.type == Type.BYTES) {
            return (byte[])this.getValue();
        }
        return FileUtils.toBytes(this.getAsString());
    }

    public String getAsString() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case BYTES: {
                return FileUtils.toString((byte[])this.value);
            }
            case MAP: 
            case LIST: {
                try {
                    return JsonUtils.toJson(this.value);
                }
                catch (Throwable t) {
                    logger.warn("conversion to json string failed, will attempt to use fall-back approach: {}", (Object)t.getMessage());
                    return JsonUtils.toJsonSafe(this.value, false);
                }
            }
            case XML: {
                return XmlUtils.toString((Node)this.getValue());
            }
        }
        return this.value.toString();
    }

    public String getAsPrettyString() {
        switch (this.type) {
            case MAP: 
            case LIST: {
                return JsonUtils.toJsonSafe(this.value, true);
            }
            case XML: {
                return this.getAsPrettyXmlString();
            }
        }
        return this.getAsString();
    }

    public String getAsPrettyXmlString() {
        return XmlUtils.toString(this.getAsXml(), true);
    }

    public int getAsInt() {
        if (this.isNumber()) {
            return ((Number)this.value).intValue();
        }
        return Integer.valueOf(this.getAsString());
    }

    public Variable copy(boolean deep) {
        switch (this.type) {
            case LIST: {
                return deep ? new Variable(JsonUtils.deepCopy(this.value)) : new Variable(new ArrayList((List)this.value));
            }
            case MAP: {
                return deep ? new Variable(JsonUtils.deepCopy(this.value)) : new Variable(new LinkedHashMap((Map)this.value));
            }
            case XML: {
                return new Variable(XmlUtils.toXmlDoc(this.getAsString()));
            }
        }
        return this;
    }

    public Variable toLowerCase() {
        switch (this.type) {
            case STRING: {
                return new Variable(this.getAsString().toLowerCase());
            }
            case MAP: 
            case LIST: {
                String json = this.getAsString().toLowerCase();
                return new Variable(JsonUtils.fromJson(json));
            }
            case XML: {
                String xml = this.getAsString().toLowerCase();
                return new Variable(XmlUtils.toXmlDoc(xml));
            }
        }
        return this;
    }

    public boolean isNotPresent() {
        return "#notpresent".equals(this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type: ").append((Object)this.type);
        sb.append(", value: ").append(this.value);
        sb.append("]");
        return sb.toString();
    }

    public static enum Type {
        NULL,
        BOOLEAN,
        NUMBER,
        STRING,
        BYTES,
        LIST,
        MAP,
        XML,
        JS_FUNCTION,
        JAVA_FUNCTION,
        FEATURE,
        OTHER;

    }
}

