/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.graal;

import com.intuit.karate.FileUtils;
import com.intuit.karate.KarateException;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsValue;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsEngine {
    private static final Logger logger = LoggerFactory.getLogger(JsEngine.class);
    private static final String JS = "js";
    private static final String JS_FOREIGN_OBJECT_PROTOTYPE = "js.foreign-object-prototype";
    private static final String JS_NASHORN_COMPAT = "js.nashorn-compat";
    private static final String JS_ECMASCRIPT_VERSION = "js.ecmascript-version";
    private static final String ENGINE_WARN_INTERPRETER_ONLY = "engine.WarnInterpreterOnly";
    private static final String V_2021 = "2021";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final ThreadLocal<JsEngine> GLOBAL_JS_ENGINE = new ThreadLocal<JsEngine>(){

        @Override
        protected JsEngine initialValue() {
            return new JsEngine(JsEngine.createContext(null));
        }
    };
    public final Context context;
    public final Value bindings;

    private static Context createContext(Engine engine) {
        if (engine == null) {
            engine = Engine.newBuilder().option(ENGINE_WARN_INTERPRETER_ONLY, FALSE).build();
        }
        return Context.newBuilder((String[])new String[]{JS}).allowExperimentalOptions(true).allowAllAccess(true).option(JS_NASHORN_COMPAT, TRUE).option(JS_ECMASCRIPT_VERSION, V_2021).option(JS_FOREIGN_OBJECT_PROTOTYPE, TRUE).engine(engine).build();
    }

    public static JsValue evalGlobal(String src) {
        return JsEngine.global().eval(src);
    }

    public static JsValue evalGlobal(InputStream is) {
        return JsEngine.global().eval(is);
    }

    public static JsEngine global() {
        return GLOBAL_JS_ENGINE.get();
    }

    public static void remove() {
        GLOBAL_JS_ENGINE.remove();
    }

    public static JsEngine local() {
        Engine engine = JsEngine.GLOBAL_JS_ENGINE.get().context.getEngine();
        return new JsEngine(JsEngine.createContext(engine));
    }

    private JsEngine(Context context) {
        this.context = context;
        this.bindings = context.getBindings(JS);
    }

    public JsEngine copy() {
        JsEngine temp = JsEngine.local();
        for (String key : this.bindings.getMemberKeys()) {
            Value v = this.bindings.getMember(key);
            if (v.isHostObject()) {
                temp.bindings.putMember(key, (Object)v);
                continue;
            }
            temp.bindings.putMember(key, JsValue.toJava(v));
        }
        return temp;
    }

    public Value attach(Value value) {
        try {
            return this.context.asValue((Object)value);
        }
        catch (Exception e) {
            logger.trace("context switch: {}", (Object)e.getMessage());
            CharSequence source = value.getSourceLocation().getCharacters();
            return this.evalForValue("(" + String.valueOf(source) + ")");
        }
    }

    public Object attachAll(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            ArrayList result = new ArrayList(list.size());
            list.forEach(v -> result.add(this.attachAll(v)));
            return result;
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            LinkedHashMap result = new LinkedHashMap(map.size());
            map.forEach((k, v) -> result.put(k, this.attachAll(v)));
            return result;
        }
        if (o instanceof Value) {
            return this.attach((Value)o);
        }
        return o;
    }

    public JsValue eval(InputStream is) {
        return this.eval(FileUtils.toString(is));
    }

    public JsValue eval(File file) {
        return this.eval(FileUtils.toString(file));
    }

    public JsValue eval(String exp) {
        return new JsValue(this.evalForValue(exp));
    }

    public Value evalForValue(String exp) {
        return this.context.eval(JS, (CharSequence)exp);
    }

    public void put(String key, Object value) {
        this.bindings.putMember(key, JsValue.fromJava(value));
    }

    public void remove(String key) {
        this.bindings.removeMember(key);
    }

    public void putAll(Map<String, Object> map) {
        map.forEach((k, v) -> this.put((String)k, v));
    }

    public JsValue get(String key) {
        if (this.bindings.hasMember(key)) {
            return new JsValue(this.bindings.getMember(key));
        }
        throw new RuntimeException("no such variable: " + key);
    }

    public static Object execute(ProxyExecutable function, Object ... args) {
        Value[] values = new Value[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = Value.asValue((Object)args[i]);
        }
        return function.execute(values);
    }

    public static Value execute(Value function, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = JsValue.fromJava(args[i]);
        }
        return function.execute(args);
    }

    public Value evalWith(Value value, String src, boolean returnValue) {
        return this.evalWith(value.getMemberKeys(), arg_0 -> ((Value)value).getMember(arg_0), src, returnValue);
    }

    public Value evalWith(Map<String, Object> variables, String src, boolean returnValue) {
        return this.evalWith(variables.keySet(), variables::get, src, returnValue);
    }

    public Value evalWith(Set<String> names, Function<String, Object> getVariable, String src, boolean returnValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("(function($){ ");
        HashMap<String, Object> arg = new HashMap<String, Object>(names.size());
        for (String name : names) {
            sb.append("let ").append(name).append(" = $.").append(name).append("; ");
            arg.put(name, getVariable.apply(name));
        }
        if (returnValue) {
            sb.append("return ");
        }
        sb.append(src).append(" })");
        Value function = this.evalForValue(sb.toString());
        return function.execute(new Object[]{JsValue.fromJava(arg)});
    }

    public static KarateException fromJsEvalException(String js, Exception e, String message) {
        StackTraceElement[] stack = e.getStackTrace();
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append('\n');
        }
        sb.append("js failed:\n>>>>\n");
        List<String> lines = StringUtils.toStringLines(js);
        int index = 0;
        for (String line : lines) {
            sb.append(String.format("%02d", ++index)).append(": ").append(line).append('\n');
        }
        sb.append("<<<<\n");
        sb.append(e.toString()).append('\n');
        for (int i = 0; i < stack.length; ++i) {
            String line;
            line = stack[i].toString();
            sb.append("- ").append(line).append('\n');
            if (line.startsWith("<js>") || i > 5) break;
        }
        return new KarateException(sb.toString());
    }

    public String toString() {
        return this.context.toString();
    }
}

