/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.http.HttpUtils;
import com.intuit.karate.http.ProxyClientHandler;
import com.intuit.karate.http.ProxyContext;
import com.intuit.karate.http.ProxyResponse;
import com.intuit.karate.http.RequestFilter;
import com.intuit.karate.http.ResponseFilter;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyRemoteHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyRemoteHandler.class);
    private final ProxyContext proxyContext;
    private final ProxyClientHandler clientHandler;
    private final RequestFilter requestFilter;
    private final ResponseFilter responseFilter;
    private final Channel clientChannel;
    private final FullHttpRequest initialRequest;
    protected Channel remoteChannel;
    protected FullHttpRequest currentRequest;

    public ProxyRemoteHandler(ProxyContext proxyContext, ProxyClientHandler clientHandler, FullHttpRequest initialRequest) {
        this.proxyContext = proxyContext;
        this.clientHandler = clientHandler;
        this.clientChannel = clientHandler.clientChannel;
        this.requestFilter = clientHandler.requestFilter;
        this.responseFilter = clientHandler.responseFilter;
        this.initialRequest = initialRequest;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse response) throws Exception {
        ProxyResponse filtered;
        if (logger.isTraceEnabled()) {
            logger.debug("<< {}", (Object)response);
        }
        ProxyResponse proxyResponse = filtered = this.responseFilter == null ? null : this.responseFilter.apply(this.proxyContext, this.currentRequest, response);
        if (filtered == null || filtered.response == null) {
            ReferenceCountUtil.retain((Object)response);
        } else {
            response = filtered.response;
            if (logger.isTraceEnabled()) {
                logger.debug("<<<< {}", (Object)response);
            }
        }
        this.clientChannel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    protected void send(FullHttpRequest request) {
        FullHttpRequest filtered;
        this.currentRequest = request;
        if (this.requestFilter != null) {
            ProxyResponse pr = this.requestFilter.apply(this.proxyContext, request);
            if (pr != null && pr.response != null) {
                this.clientChannel.writeAndFlush((Object)pr.response);
                return;
            }
            filtered = pr == null ? null : pr.request;
        } else {
            filtered = null;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(">> before: {}", (Object)request);
        }
        if (filtered == null) {
            ReferenceCountUtil.retain((Object)request);
            filtered = request;
        } else if (logger.isTraceEnabled()) {
            logger.trace(">>>> after: {}", (Object)filtered);
        }
        HttpUtils.fixHeadersForProxy((HttpRequest)filtered);
        this.remoteChannel.writeAndFlush((Object)filtered);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.remoteChannel = ctx.channel();
        if (this.initialRequest != null) {
            this.send(this.initialRequest);
            this.clientHandler.unlockAndProceed();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause.getMessage() == null) {
            cause.printStackTrace();
        } else {
            logger.error("closing proxy outbound connection: {}", (Object)cause.getMessage());
        }
        ctx.close();
        HttpUtils.flushAndClose(this.clientChannel);
    }

    public String toString() {
        return String.valueOf(this.remoteChannel);
    }
}

