/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import com.intuit.karate.FileUtils;
import com.intuit.karate.http.HttpUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(SslContextFactory.class);
    public static final String DEFAULT_CERT_NAME = "cert.pem";
    public static final String DEFAULT_KEY_NAME = "key.pem";
    private String buildDir;
    private File certFile;
    private File keyFile;

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public void setCertFile(File certFile) {
        this.certFile = certFile;
    }

    public void setKeyFile(File keyFile) {
        this.keyFile = keyFile;
    }

    public File getCertFile() {
        return this.certFile;
    }

    public File getKeyFile() {
        return this.keyFile;
    }

    public void build() {
        if (this.buildDir == null) {
            this.buildDir = FileUtils.getBuildDir();
        }
        try {
            if (this.certFile == null || this.keyFile == null) {
                this.certFile = new File(this.buildDir + File.separator + DEFAULT_CERT_NAME);
                this.keyFile = new File(this.buildDir + File.separator + DEFAULT_KEY_NAME);
            }
            if (!this.certFile.exists() || !this.keyFile.exists()) {
                logger.warn("ssl - " + String.valueOf(this.certFile) + " and / or " + String.valueOf(this.keyFile) + " not found, will create");
                HttpUtils.createSelfSignedCertificate(this.certFile, this.keyFile);
            } else {
                logger.info("ssl - re-using existing files: {} and {}", (Object)this.certFile, (Object)this.keyFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

