/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.report;

import com.intuit.karate.FileUtils;
import com.intuit.karate.graal.JsEngine;
import com.intuit.karate.report.ReportUtils;
import com.intuit.karate.template.KarateTemplateEngine;
import com.intuit.karate.template.TemplateUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public interface Report {
    public JsEngine getJsEngine();

    public String getResourceRoot();

    public String getTemplate();

    public String getReportDir();

    public String getReportFileName();

    default public File render() {
        return this.render(null);
    }

    default public File render(String reportDir) {
        JsEngine je = this.getJsEngine();
        KarateTemplateEngine engine = TemplateUtils.forResourceRoot(je, this.getResourceRoot());
        String html = engine.process(this.getTemplate());
        if (reportDir == null) {
            reportDir = this.getReportDir();
        }
        ReportUtils.initStaticResources(reportDir);
        File file = new File(reportDir + File.separator + this.getReportFileName());
        FileUtils.writeToFile(file, html);
        return file;
    }

    public static Builder template(String value) {
        return new Builder().template(value);
    }

    public static class Builder {
        private JsEngine je;
        private String resourceRoot = "classpath:com/intuit/karate/report";
        private String template;
        private String reportDir;
        private String reportFileName;
        private final Map<String, Object> variables = new HashMap<String, Object>();

        public Builder resourceRoot(String value) {
            this.resourceRoot = value;
            return this;
        }

        public Builder template(String value) {
            this.template = value;
            return this;
        }

        public Builder jsEngine(JsEngine value) {
            this.je = value;
            return this;
        }

        public Builder variable(String name, Object value) {
            this.variables.put(name, value);
            return this;
        }

        public Builder variables(Map<String, Object> value) {
            this.variables.putAll(value);
            return this;
        }

        public Builder reportDir(String value) {
            this.reportDir = value;
            return this;
        }

        public Builder reportFileName(String value) {
            this.reportFileName = value;
            return this;
        }

        public Report build() {
            if (this.template == null) {
                throw new RuntimeException("template name is mandatory");
            }
            if (this.reportDir == null) {
                throw new RuntimeException("report dir is mandatory");
            }
            if (this.reportFileName == null) {
                this.reportFileName = this.template;
            }
            if (this.je == null) {
                this.je = JsEngine.local();
            }
            this.je.putAll(this.variables);
            return new Report(){

                @Override
                public JsEngine getJsEngine() {
                    return je;
                }

                @Override
                public String getResourceRoot() {
                    return resourceRoot;
                }

                @Override
                public String getTemplate() {
                    return template;
                }

                @Override
                public String getReportDir() {
                    return reportDir;
                }

                @Override
                public String getReportFileName() {
                    return reportFileName;
                }
            };
        }
    }
}

