/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.shell;

import com.intuit.karate.shell.Stoppable;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopListenerThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(StopListenerThread.class);
    private Stoppable stoppable;
    private ServerSocket socket;

    public StopListenerThread(int port, Stoppable stoppable) {
        this.stoppable = stoppable;
        this.setDaemon(true);
        this.setName("stop-listener-" + port);
        try {
            this.socket = new ServerSocket(port, 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public void run() {
        logger.info("starting thread: {}", (Object)this.getName());
        try {
            Socket accept = this.socket.accept();
            BufferedReader reader = new BufferedReader(new InputStreamReader(accept.getInputStream()));
            reader.readLine();
            logger.info("shutting down thread: {}", (Object)this.getName());
            this.stoppable.stop();
            accept.close();
            this.socket.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stop(int port) {
        try {
            Socket s = new Socket(InetAddress.getByName("127.0.0.1"), port);
            OutputStream out = s.getOutputStream();
            logger.info("sending stop request to port: {}", (Object)port);
            out.write("\r\n".getBytes());
            out.flush();
            s.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

