/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.FileUtils;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.http.ResourceType;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRecord;
import de.siegmar.fastcsv.writer.CsvWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class JsonUtils {
    private static final Logger logger = LoggerFactory.getLogger(JsonUtils.class);
    private static final JSONStyle JSON_STYLE = new JSONStyle(2);

    private JsonUtils() {
    }

    public static boolean isJson(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        if (s.charAt(0) == ' ' && (s = s.trim()).isEmpty()) {
            return false;
        }
        return s.charAt(0) == '{' || s.charAt(0) == '[';
    }

    public static String toStrictJson(String raw) {
        JSONParser jp = new JSONParser(-1);
        try {
            Object o = jp.parse(raw);
            return JSONValue.toJSONString((Object)o, (JSONStyle)JSON_STYLE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJson(Object o) {
        return JsonUtils.toJson(o, false);
    }

    public static String toJson(Object o, boolean pretty) {
        if (!pretty) {
            try {
                return JSONValue.toJSONString((Object)o, (JSONStyle)JSON_STYLE);
            }
            catch (Throwable t) {
                logger.warn("object to json serialization failure, trying alternate approach: {}", (Object)t.getMessage());
            }
        }
        return JsonUtils.toJsonSafe(o, pretty);
    }

    public static byte[] toJsonBytes(Object o) {
        return JsonUtils.toJson(o).getBytes(StandardCharsets.UTF_8);
    }

    public static Object fromJson(String json) {
        return JSONValue.parseKeepingOrder((String)json);
    }

    public static Object fromJsonStrict(String json) {
        JSONParser parser = new JSONParser(4752);
        try {
            return parser.parse(json.trim(), JSONValue.defaultReader.DEFAULT_ORDERED);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object fromJson(String s, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return JSONValue.parse((String)s, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String s, Class<T> clazz) {
        return (T)JsonUtils.fromJson(s, clazz.getName());
    }

    public static Object fromYaml(String raw) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
        return yaml.load(raw);
    }

    public static List<Map> fromCsv(String raw) {
        CsvReader reader = CsvReader.builder().ofCsvRecord(raw);
        ArrayList<String> header = new ArrayList<String>();
        ArrayList<Map> rows = new ArrayList<Map>();
        try {
            boolean first = true;
            for (CsvRecord row : reader) {
                if (first) {
                    for (String field : row.getFields()) {
                        header.add(field.replace("\ufeff", ""));
                    }
                    first = false;
                    continue;
                }
                int count = header.size();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(count);
                for (int i = 0; i < count; ++i) {
                    map.put((String)header.get(i), row.getField(i));
                }
                rows.add(map);
            }
            return rows;
        }
        catch (Exception e) {
            logger.warn("failed to parse csv: {}", (Object)e.getMessage());
            return rows;
        }
    }

    public static String toCsv(List<Map<String, Object>> list) {
        StringWriter sw = new StringWriter();
        CsvWriter writer = CsvWriter.builder().build((Writer)sw);
        if (!list.isEmpty()) {
            writer.writeRecord(list.get(0).keySet());
        }
        for (Map<String, Object> map : list) {
            ArrayList<String> row = new ArrayList<String>(map.size());
            for (Object value : map.values()) {
                row.add(value == null ? null : value.toString());
            }
            writer.writeRecord(row);
        }
        return sw.toString();
    }

    public static Object shallowCopy(Object o) {
        if (o instanceof List) {
            return new ArrayList((List)o);
        }
        if (o instanceof Map) {
            return new LinkedHashMap((Map)o);
        }
        return o;
    }

    public static Object deepCopy(Object o) {
        Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());
        return JsonUtils.recurseDeepCopy(o, seen);
    }

    private static Object recurseDeepCopy(Object o, Set<Object> seen) {
        if (o instanceof List) {
            List list = (List)o;
            if (seen.add(o)) {
                int count = list.size();
                ArrayList<Object> listCopy = new ArrayList<Object>(count);
                for (int i = 0; i < count; ++i) {
                    listCopy.add(JsonUtils.recurseDeepCopy(list.get(i), seen));
                }
                return listCopy;
            }
            return o;
        }
        if (o instanceof Map) {
            if (seen.add(o)) {
                Map map = (Map)o;
                LinkedHashMap mapCopy = new LinkedHashMap(map.size());
                map.forEach((k, v) -> mapCopy.put(k, JsonUtils.recurseDeepCopy(v, seen)));
                return mapCopy;
            }
            return o;
        }
        return o;
    }

    public static String toJsonSafe(Object o, boolean pretty) {
        StringBuilder sb = new StringBuilder();
        Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());
        JsonUtils.recurseJsonString(o, pretty, sb, 0, seen);
        if (pretty) {
            sb.append('\n');
        }
        return sb.toString();
    }

    private static void pad(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append(' ').append(' ');
        }
    }

    private static void ref(StringBuilder sb, Object o) {
        sb.append("\"#ref:").append(o.getClass().getName()).append('\"');
    }

    public static String escapeValue(String raw) {
        return JSONValue.escape((String)raw, (JSONStyle)JSONStyle.LT_COMPRESS);
    }

    private static void recurseJsonString(Object o, boolean pretty, StringBuilder sb, int depth, Set<Object> seen) {
        if (o == null) {
            sb.append("null");
        } else if (o instanceof List) {
            List list = (List)o;
            if (list.isEmpty() || seen.add(o)) {
                sb.append('[');
                if (pretty) {
                    sb.append('\n');
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    if (pretty) {
                        JsonUtils.pad(sb, depth + 1);
                    }
                    JsonUtils.recurseJsonString(child, pretty, sb, depth + 1, seen);
                    if (iterator.hasNext()) {
                        sb.append(',');
                    }
                    if (!pretty) continue;
                    sb.append('\n');
                }
                if (pretty) {
                    JsonUtils.pad(sb, depth);
                }
                sb.append(']');
            } else {
                JsonUtils.ref(sb, o);
            }
        } else if (o instanceof Map) {
            Map map = (Map)o;
            if (map.isEmpty() || seen.add(o)) {
                sb.append('{');
                if (pretty) {
                    sb.append('\n');
                }
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object key = entry.getKey();
                    if (pretty) {
                        JsonUtils.pad(sb, depth + 1);
                    }
                    sb.append('\"').append(JsonUtils.escapeValue(key == null ? null : key.toString())).append('\"').append(':');
                    if (pretty) {
                        sb.append(' ');
                    }
                    JsonUtils.recurseJsonString(entry.getValue(), pretty, sb, depth + 1, seen);
                    if (iterator.hasNext()) {
                        sb.append(',');
                    }
                    if (!pretty) continue;
                    sb.append('\n');
                }
                if (pretty) {
                    JsonUtils.pad(sb, depth);
                }
                sb.append('}');
            } else {
                JsonUtils.ref(sb, o);
            }
        } else if (o instanceof String) {
            String value = (String)o;
            sb.append('\"').append(JsonUtils.escapeValue(value)).append('\"');
        } else if (o instanceof Number || o instanceof Boolean) {
            sb.append(o);
        } else {
            String value = o.toString();
            sb.append('\"').append(JsonUtils.escapeValue(value)).append('\"');
        }
    }

    public static void removeKeysWithNullValues(Object o) {
        if (o instanceof List) {
            List list = (List)o;
            for (Object v : list) {
                JsonUtils.removeKeysWithNullValues(v);
            }
        } else if (o instanceof Map) {
            Map map = (Map)o;
            ArrayList<String> toRemove = new ArrayList<String>();
            for (Map.Entry entry : map.entrySet()) {
                Object v = entry.getValue();
                if (v == null) {
                    toRemove.add((String)entry.getKey());
                    continue;
                }
                JsonUtils.removeKeysWithNullValues(v);
            }
            toRemove.forEach(key -> map.remove(key));
        }
    }

    public static Map<String, String> simplify(Map<String, List<String>> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(map.size());
        map.forEach((k, v) -> {
            if (v instanceof List) {
                Object value;
                List list = v;
                if (list.size() > 1) {
                    result.put((String)k, StringUtils.join(list, ","));
                } else if (list.size() == 1 && (value = list.get(0)) != null) {
                    result.put((String)k, String.valueOf(value));
                }
            } else if (v != null) {
                result.put((String)k, String.valueOf(v));
            }
        });
        return result;
    }

    public static String toString(Object o) {
        return JsonUtils.toString(o, false);
    }

    public static String toString(Object o, boolean pretty) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map || o instanceof List) {
            return JsonUtils.toJson(o, pretty);
        }
        if (o instanceof Node) {
            return XmlUtils.toString((Node)o, pretty);
        }
        if (o instanceof byte[]) {
            return FileUtils.toString((byte[])o);
        }
        return o.toString();
    }

    public static byte[] toBytes(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Map || o instanceof List) {
            return FileUtils.toBytes(JsonUtils.toJson(o));
        }
        if (o instanceof Node) {
            return FileUtils.toBytes(XmlUtils.toString((Node)o));
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        return FileUtils.toBytes(o.toString());
    }

    public static Object fromBytes(byte[] bytes, boolean strict, ResourceType resourceType) {
        if (bytes == null) {
            return null;
        }
        String raw = FileUtils.toString(bytes);
        return JsonUtils.fromString(raw, strict, resourceType);
    }

    public static Object fromString(String raw, boolean strict, ResourceType resourceType) {
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return raw;
        }
        if (resourceType != null && resourceType.isBinary()) {
            return raw;
        }
        switch (trimmed.charAt(0)) {
            case '[': 
            case '{': {
                if (strict) {
                    return JsonUtils.fromJsonStrict(raw);
                }
                try {
                    return JsonUtils.fromJson(raw);
                }
                catch (Exception e) {
                    logger.trace("failed to parse json: {}", (Object)e.getMessage());
                    return raw;
                }
            }
            case '<': {
                if (resourceType == null || resourceType.isXml()) {
                    try {
                        return XmlUtils.toXmlDoc(raw);
                    }
                    catch (Exception e) {
                        logger.trace("failed to parse xml: {}", (Object)e.getMessage());
                        if (strict) {
                            throw e;
                        }
                        return raw;
                    }
                }
                return raw;
            }
        }
        return raw;
    }

    public static Object fromStringSafe(String raw) {
        try {
            return JsonUtils.fromString(raw, false, null);
        }
        catch (Exception e) {
            logger.trace("failed to auto convert: {}", (Object)String.valueOf(e));
            return raw;
        }
    }

    static {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JsonSmartJsonProvider();
            private final MappingProvider mappingProvider = new JsonSmartMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }
}

