/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Json;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.MatchOperation;
import com.intuit.karate.MatchOperator;
import com.intuit.karate.StringUtils;
import com.intuit.karate.XmlUtils;
import com.intuit.karate.graal.JsEngine;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Match {
    private static final int TYPE_DOES_NOT_SUPPORT_MACRO_SHORTCUT = -1;
    static final Result PASS = new Result(true, null);
    static final Map<String, Validator> VALIDATORS = new HashMap<String, Validator>(11);

    static Result fail(String message) {
        return new Result(false, message);
    }

    public static Result execute(JsEngine js, Type matchType, Object actual, Object expected, boolean matchEachEmptyAllowed) {
        MatchOperation mo = new MatchOperation(js, matchType.operator(matchEachEmptyAllowed), new Value(actual), new Value(expected));
        mo.execute();
        if (mo.pass) {
            return PASS;
        }
        return Match.fail(mo.getFailureReasons());
    }

    public static Object parseIfJsonOrXmlString(Object o) {
        if (o instanceof String) {
            String s = (String)o;
            if (s.isEmpty()) {
                return o;
            }
            if (JsonUtils.isJson(s)) {
                return Json.of(s).value();
            }
            if (XmlUtils.isXml(s)) {
                return XmlUtils.toXmlDoc(s);
            }
            if (s.charAt(0) == '\\') {
                return s.substring(1);
            }
        }
        return o;
    }

    public static Value evaluate(Object actual) {
        return new Value(Match.parseIfJsonOrXmlString(actual), false);
    }

    public static Value that(Object actual) {
        return new Value(Match.parseIfJsonOrXmlString(actual), true);
    }

    static {
        VALIDATORS.put("array", v -> v.isList() ? PASS : Match.fail("not an array or list"));
        VALIDATORS.put("boolean", v -> v.isBoolean() ? PASS : Match.fail("not a boolean"));
        VALIDATORS.put("ignore", v -> PASS);
        VALIDATORS.put("notnull", v -> v.isNull() ? Match.fail("null") : PASS);
        VALIDATORS.put("null", v -> v.isNull() ? PASS : Match.fail("not null"));
        VALIDATORS.put("number", v -> v.isNumber() ? PASS : Match.fail("not a number"));
        VALIDATORS.put("object", v -> v.isMap() ? PASS : Match.fail("not an object or map"));
        VALIDATORS.put("present", v -> v.isNotPresent() ? Match.fail("not present") : PASS);
        VALIDATORS.put("notpresent", v -> v.isNotPresent() ? PASS : Match.fail("present"));
        VALIDATORS.put("string", v -> v.isNotPresent() ? Match.fail("not present") : (v.isString() ? PASS : Match.fail("not a string")));
        VALIDATORS.put("uuid", v -> {
            if (!v.isString()) {
                return Match.fail("not a string");
            }
            try {
                UUID.fromString((String)v.getValue());
                return PASS;
            }
            catch (Exception e) {
                return Match.fail("not a valid uuid");
            }
        });
    }

    public static class Result {
        public final String message;
        public final boolean pass;

        private Result(boolean pass, String message) {
            this.pass = pass;
            this.message = message;
        }

        public String toString() {
            return this.pass ? "[pass]" : this.message;
        }

        public Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("pass", this.pass);
            map.put("message", this.message);
            return map;
        }
    }

    public static enum Type {
        EQUALS(MatchOperator.CoreOperator::equalsOperator, 0),
        NOT_EQUALS(MatchOperatorFactory.not(MatchOperator.CoreOperator::equalsOperator, "equals"), 2),
        CONTAINS(MatchOperator.CoreOperator::containsOperator, 1),
        NOT_CONTAINS(MatchOperatorFactory.not(MatchOperator.CoreOperator::containsOperator, "actual contains expected"), 2),
        CONTAINS_ONLY(MatchOperator.CoreOperator::containsOnlyOperator, 2),
        CONTAINS_ANY(MatchOperator.CoreOperator::containsAnyOperator, 2),
        CONTAINS_DEEP(MatchOperatorFactory.deep(MatchOperator.CoreOperator::containsOperator), 2),
        CONTAINS_ONLY_DEEP(MatchOperatorFactory.deep(MatchOperator.CoreOperator::containsOnlyOperator), -1),
        CONTAINS_ANY_DEEP(MatchOperatorFactory.deep(MatchOperator.CoreOperator::containsAnyOperator), -1),
        EACH_EQUALS(MatchOperatorFactory.each(Type.EQUALS.operatorFactory), 0),
        EACH_NOT_EQUALS(MatchOperatorFactory.each(Type.NOT_EQUALS.operatorFactory), 2),
        EACH_CONTAINS(MatchOperatorFactory.each(Type.CONTAINS.operatorFactory), 1),
        EACH_NOT_CONTAINS(MatchOperatorFactory.each(Type.NOT_CONTAINS.operatorFactory), 2),
        EACH_CONTAINS_ONLY(MatchOperatorFactory.each(Type.CONTAINS_ONLY.operatorFactory), 2),
        EACH_CONTAINS_ANY(MatchOperatorFactory.each(Type.CONTAINS_ANY.operatorFactory), 2),
        EACH_CONTAINS_DEEP(MatchOperatorFactory.each(Type.CONTAINS_DEEP.operatorFactory), 2);

        final MatchOperatorFactory operatorFactory;
        final int shortcutLength;

        private Type(MatchOperatorFactory operatorFactory, int shortcutLength) {
            this.operatorFactory = operatorFactory;
            this.shortcutLength = shortcutLength;
        }

        MatchOperator operator(boolean matchEachEmptyAllowed) {
            return this.operatorFactory.create(matchEachEmptyAllowed);
        }
    }

    public static class Value {
        final ValueType type;
        final boolean exceptionOnMatchFailure;
        private final Object value;

        Value(Object value) {
            this(value, false);
        }

        Value(Object value, boolean exceptionOnMatchFailure) {
            if (value instanceof Set) {
                Set set = (Set)((Object)value);
                value = new ArrayList(set);
            } else if (value != null && value.getClass().isArray()) {
                int length = Array.getLength(value);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(Array.get(value, i));
                }
                value = list;
            }
            this.value = value;
            this.exceptionOnMatchFailure = exceptionOnMatchFailure;
            this.type = value == null ? ValueType.NULL : (value instanceof Node ? ValueType.XML : (value instanceof List ? ValueType.LIST : (value instanceof Map ? ValueType.MAP : (value instanceof String ? ValueType.STRING : (Number.class.isAssignableFrom(value.getClass()) ? ValueType.NUMBER : (Boolean.class.equals(value.getClass()) ? ValueType.BOOLEAN : (value instanceof byte[] ? ValueType.BYTES : ValueType.OTHER)))))));
        }

        public boolean isBoolean() {
            return this.type == ValueType.BOOLEAN;
        }

        public boolean isNumber() {
            return this.type == ValueType.NUMBER;
        }

        public boolean isString() {
            return this.type == ValueType.STRING;
        }

        public boolean isNull() {
            return this.type == ValueType.NULL;
        }

        public boolean isMap() {
            return this.type == ValueType.MAP;
        }

        public boolean isList() {
            return this.type == ValueType.LIST;
        }

        public boolean isXml() {
            return this.type == ValueType.XML;
        }

        boolean isNotPresent() {
            return "#notpresent".equals(this.value);
        }

        boolean isArrayObjectOrReference() {
            String temp = this.value.toString();
            return temp.startsWith("#[") || temp.startsWith("##[") || temp.startsWith("#(") || temp.startsWith("##(") || "#array".equals(temp) || "##array".equals(temp) || "#object".equals(temp) || "##object".equals(temp);
        }

        boolean isMapOrListOrXml() {
            switch (this.type) {
                case MAP: 
                case LIST: 
                case XML: {
                    return true;
                }
            }
            return false;
        }

        public <T> T getValue() {
            return (T)this.value;
        }

        String getWithinSingleQuotesIfString() {
            if (this.type == ValueType.STRING) {
                return "'" + String.valueOf(this.value) + "'";
            }
            return this.getAsString();
        }

        public String getAsString() {
            switch (this.type) {
                case MAP: 
                case LIST: {
                    return JsonUtils.toJsonSafe(this.value, false);
                }
                case XML: {
                    return XmlUtils.toString((Node)this.getValue());
                }
            }
            return String.valueOf(this.value);
        }

        String getAsXmlString() {
            if (this.type == ValueType.MAP) {
                Document node = XmlUtils.fromMap((Map)this.getValue());
                return XmlUtils.toString(node);
            }
            return this.getAsString();
        }

        Value getSortedLike(Value other) {
            if (this.isMap() && other.isMap()) {
                Map reference = (Map)other.getValue();
                Map source = (Map)this.getValue();
                LinkedHashSet remainder = new LinkedHashSet(source.keySet());
                LinkedHashMap result = new LinkedHashMap(source.size());
                reference.keySet().forEach(key -> {
                    if (source.containsKey(key)) {
                        result.put((String)key, source.get(key));
                        remainder.remove(key);
                    }
                });
                for (String key2 : remainder) {
                    result.put(key2, source.get(key2));
                }
                return new Value(result, other.exceptionOnMatchFailure);
            }
            return this;
        }

        public String toString() {
            return "[type: " + String.valueOf((Object)this.type) + ", value: " + String.valueOf(this.value) + "]";
        }

        public Result is(Type matchType, Object expected) {
            MatchOperation mo = new MatchOperation(matchType.operator(false), this, new Value(Match.parseIfJsonOrXmlString(expected), this.exceptionOnMatchFailure));
            mo.execute();
            if (mo.pass) {
                return PASS;
            }
            if (this.exceptionOnMatchFailure) {
                throw new RuntimeException(mo.getFailureReasons());
            }
            return Match.fail(mo.getFailureReasons());
        }

        public Result isEqualTo(Object expected) {
            return this.is(Type.EQUALS, expected);
        }

        public Result contains(Object expected) {
            return this.is(Type.CONTAINS, expected);
        }

        public Result containsDeep(Object expected) {
            return this.is(Type.CONTAINS_DEEP, expected);
        }

        public Result containsOnly(Object expected) {
            return this.is(Type.CONTAINS_ONLY, expected);
        }

        public Result containsOnlyDeep(Object expected) {
            return this.is(Type.CONTAINS_ONLY_DEEP, expected);
        }

        public Result containsAny(Object expected) {
            return this.is(Type.CONTAINS_ANY, expected);
        }

        public Result isNotEqualTo(Object expected) {
            return this.is(Type.NOT_EQUALS, expected);
        }

        public Result isNotContaining(Object expected) {
            return this.is(Type.NOT_CONTAINS, expected);
        }

        public Result isEachEqualTo(Object expected) {
            return this.is(Type.EACH_EQUALS, expected);
        }

        public Result isEachNotEqualTo(Object expected) {
            return this.is(Type.EACH_NOT_EQUALS, expected);
        }

        public Result isEachContaining(Object expected) {
            return this.is(Type.EACH_CONTAINS, expected);
        }

        public Result isEachNotContaining(Object expected) {
            return this.is(Type.EACH_NOT_CONTAINS, expected);
        }

        public Result isEachContainingDeep(Object expected) {
            return this.is(Type.EACH_CONTAINS_DEEP, expected);
        }

        public Result isEachContainingOnly(Object expected) {
            return this.is(Type.EACH_CONTAINS_ONLY, expected);
        }

        public Result isEachContainingAny(Object expected) {
            return this.is(Type.EACH_CONTAINS_ANY, expected);
        }
    }

    static interface Validator
    extends Function<Value, Result> {
    }

    static enum ValueType {
        NULL,
        BOOLEAN,
        NUMBER,
        STRING,
        BYTES,
        LIST,
        MAP,
        XML,
        OTHER;

    }

    static class Context {
        final JsEngine JS;
        final MatchOperation root;
        final int depth;
        final boolean xml;
        final String path;
        final String name;
        final int index;

        Context(JsEngine js, MatchOperation root, boolean xml, int depth, String path, String name, int index) {
            this.JS = js;
            this.root = root;
            this.xml = xml;
            this.depth = depth;
            this.path = path;
            this.name = name;
            this.index = index;
        }

        Context descend(String name) {
            if (this.xml) {
                String childPath = this.path.endsWith("/@") ? this.path + name : (this.depth == 0 ? "" : this.path) + "/" + name;
                return new Context(this.JS, this.root, this.xml, this.depth + 1, childPath, name, -1);
            }
            boolean needsQuotes = name.indexOf(45) != -1 || name.indexOf(32) != -1 || name.indexOf(46) != -1;
            String childPath = needsQuotes ? this.path + "['" + name + "']" : this.path + "." + name;
            return new Context(this.JS, this.root, this.xml, this.depth + 1, childPath, name, -1);
        }

        Context descend(int index) {
            if (this.xml) {
                return new Context(this.JS, this.root, this.xml, this.depth + 1, this.path + "[" + (index + 1) + "]", this.name, index);
            }
            return new Context(this.JS, this.root, this.xml, this.depth + 1, this.path + "[" + index + "]", this.name, index);
        }
    }

    static class RegexValidator
    implements Validator {
        private final Pattern pattern;

        public RegexValidator(String regex) {
            regex = StringUtils.trimToEmpty(regex);
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public Result apply(Value v) {
            if (!v.isString()) {
                return Match.fail("not a string");
            }
            String strValue = (String)v.getValue();
            Matcher matcher = this.pattern.matcher(strValue);
            return matcher.matches() ? PASS : Match.fail("regex match failed");
        }
    }

    static interface CoreOperatorFactory
    extends MatchOperatorFactory {
        @Override
        public MatchOperator.CoreOperator create(boolean var1);
    }

    static interface MatchOperatorFactory {
        public MatchOperator create(boolean var1);

        public static MatchOperatorFactory not(CoreOperatorFactory delegateFactory, String failureMessage) {
            return matchEachEmptyAllowed -> new MatchOperator.NotOperator(delegateFactory.create(matchEachEmptyAllowed), failureMessage);
        }

        public static MatchOperatorFactory deep(CoreOperatorFactory delegateFactory) {
            return matchEachEmptyAllowed -> delegateFactory.create(matchEachEmptyAllowed).deep();
        }

        public static MatchOperatorFactory each(MatchOperatorFactory delegateFactory) {
            return matchEachEmptyAllowed -> new MatchOperator.EachOperator(delegateFactory.create(matchEachEmptyAllowed), matchEachEmptyAllowed);
        }
    }
}

