/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.Match;
import com.intuit.karate.MatchOperator;
import com.intuit.karate.StringUtils;
import com.intuit.karate.graal.JsEngine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MatchOperation {
    public static final String REGEX = "regex";
    final Match.Context context;
    final MatchOperator type;
    final Match.Value actual;
    final Match.Value expected;
    final List<MatchOperation> failures;
    boolean pass = true;
    String failReason;

    MatchOperation(MatchOperator type, Match.Value actual, Match.Value expected) {
        this(JsEngine.global(), null, type, actual, expected);
    }

    MatchOperation(JsEngine js, MatchOperator type, Match.Value actual, Match.Value expected) {
        this(js, null, type, actual, expected);
    }

    MatchOperation(Match.Context context, MatchOperator type, Match.Value actual, Match.Value expected) {
        this(null, context, type, actual, expected);
    }

    private MatchOperation(JsEngine js, Match.Context context, MatchOperator type, Match.Value actual, Match.Value expected) {
        this.type = type;
        this.actual = actual;
        this.expected = expected;
        if (context == null) {
            if (js == null) {
                js = JsEngine.global();
            }
            this.failures = new ArrayList<MatchOperation>();
            this.context = actual.isXml() ? new Match.Context(js, this, true, 0, "/", "", -1) : new Match.Context(js, this, false, 0, "$", "", -1);
        } else {
            this.context = context;
            this.failures = context.root.failures;
        }
    }

    boolean execute() {
        return this.type.execute(this);
    }

    boolean pass() {
        this.pass = true;
        return true;
    }

    boolean fail(String reason) {
        this.pass = false;
        if (reason == null) {
            return false;
        }
        this.failReason = this.failReason == null ? reason : reason + " | " + this.failReason;
        this.context.root.failures.add(this);
        return false;
    }

    String getFailureReasons() {
        return MatchOperation.collectFailureReasons(this);
    }

    private boolean isXmlAttributeOrMap() {
        return this.context.xml && this.actual.isMap() && (this.context.name.equals("@") || ((Map)this.actual.getValue()).containsKey("_"));
    }

    private static String collectFailureReasons(MatchOperation root) {
        StringBuilder sb = new StringBuilder();
        sb.append("match failed: ").append(root.type).append('\n');
        Collections.reverse(root.failures);
        Iterator<MatchOperation> iterator = root.failures.iterator();
        HashSet<String> previousPaths = new HashSet<String>();
        int index = 0;
        int prevDepth = -1;
        while (iterator.hasNext()) {
            MatchOperation mo = iterator.next();
            if (previousPaths.contains(mo.context.path) || mo.isXmlAttributeOrMap()) continue;
            previousPaths.add(mo.context.path);
            if (mo.context.depth != prevDepth) {
                prevDepth = mo.context.depth;
                ++index;
            }
            String prefix = StringUtils.repeat(' ', index * 2);
            sb.append(prefix).append(mo.context.path).append(" | ").append(mo.failReason);
            sb.append(" (").append((Object)mo.actual.type).append(':').append((Object)mo.expected.type).append(")");
            sb.append('\n');
            if (mo.context.xml) {
                sb.append(prefix).append(mo.actual.getAsXmlString()).append('\n');
                sb.append(prefix).append(mo.expected.getAsXmlString()).append('\n');
            } else {
                Match.Value expected = mo.expected.getSortedLike(mo.actual);
                sb.append(prefix).append(mo.actual.getWithinSingleQuotesIfString()).append('\n');
                sb.append(prefix).append(expected.getWithinSingleQuotesIfString()).append('\n');
            }
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

