/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureSection;
import com.intuit.karate.core.Step;
import com.intuit.karate.core.Table;
import com.intuit.karate.core.Tag;
import com.intuit.karate.core.Tags;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Scenario {
    private final Feature feature;
    private final FeatureSection section;
    private final int exampleIndex;
    private int line;
    private List<Tag> tags;
    private String name;
    private String description;
    private List<Step> steps;
    private Map<String, Object> exampleData;
    private String dynamicExpression;
    private Tags tagsEffective;

    public Scenario(Feature feature, FeatureSection section, int exampleIndex) {
        this.feature = feature;
        this.section = section;
        this.exampleIndex = exampleIndex;
    }

    public boolean isEqualTo(Scenario other) {
        return other.section.getIndex() == this.section.getIndex() && other.exampleIndex == this.exampleIndex;
    }

    public String getNameAndDescription() {
        Object temp = "";
        if (this.name != null) {
            temp = (String)temp + this.name;
        }
        if (this.description != null) {
            if (!((String)temp).isEmpty()) {
                temp = (String)temp + " ";
            }
            temp = (String)temp + this.description;
        }
        return temp;
    }

    public String getRefIdAndName() {
        if (this.name == null) {
            return this.getRefId();
        }
        return this.getRefId() + " " + this.name;
    }

    public Scenario copy(int exampleIndex) {
        Scenario s = new Scenario(this.feature, this.section, exampleIndex);
        s.name = this.name;
        s.description = this.description;
        s.tags = this.tags;
        s.line = this.line;
        s.dynamicExpression = this.dynamicExpression;
        s.steps = new ArrayList<Step>(this.steps.size());
        for (Step step : this.steps) {
            Step temp = new Step(s, step.getIndex());
            s.steps.add(temp);
            temp.setLine(step.getLine());
            temp.setEndLine(step.getEndLine());
            temp.setPrefix(step.getPrefix());
            temp.setText(step.getText());
            temp.setDocString(step.getDocString());
            temp.setTable(step.getTable());
        }
        return s;
    }

    public void replace(String token, String value) {
        if (value == null) {
            return;
        }
        this.name = this.name.replace(token, value);
        for (Step step : this.steps) {
            Table table;
            String text = step.getText();
            step.setText(text.replace(token, value));
            String docString = step.getDocString();
            if (docString != null) {
                step.setDocString(docString.replace(token, value));
            }
            if ((table = step.getTable()) == null) continue;
            step.setTable(table.replace(token, value));
        }
    }

    public Step getStepByLine(int line) {
        for (Step step : this.getStepsIncludingBackground()) {
            if (step.getLine() != line) continue;
            return step;
        }
        return null;
    }

    public String getRefId() {
        int num = this.section.getIndex() + 1;
        String meta = "[" + num;
        if (this.exampleIndex != -1) {
            meta = meta + "." + (this.exampleIndex + 1);
        }
        return meta + ":" + this.line + "]";
    }

    public String getDebugInfo() {
        return String.valueOf(this.feature) + ":" + this.line;
    }

    public String getUniqueId() {
        String id = this.feature.getResource().getPackageQualifiedName() + "_" + (this.section.getIndex() + 1);
        return this.exampleIndex == -1 ? id : id + "_" + (this.exampleIndex + 1);
    }

    public List<Step> getBackgroundSteps() {
        return this.feature.isBackgroundPresent() ? this.feature.getBackground().getSteps() : Collections.EMPTY_LIST;
    }

    public List<Step> getStepsIncludingBackground() {
        List<Step> background = this.feature.isBackgroundPresent() ? this.feature.getBackground().getSteps() : null;
        int count = background == null ? this.steps.size() : this.steps.size() + background.size();
        ArrayList<Step> temp = new ArrayList<Step>(count);
        if (background != null) {
            temp.addAll(background);
        }
        temp.addAll(this.steps);
        return temp;
    }

    public Tags getTagsEffective() {
        if (this.tagsEffective == null) {
            this.tagsEffective = Tags.merge(this.feature.getTags(), this.tags);
        }
        return this.tagsEffective;
    }

    public FeatureSection getSection() {
        return this.section;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public boolean isOutlineExample() {
        return this.exampleIndex != -1;
    }

    public boolean isDynamic() {
        return this.dynamicExpression != null;
    }

    public String getDynamicExpression() {
        return this.dynamicExpression;
    }

    public void setDynamicExpression(String dynamicExpression) {
        this.dynamicExpression = dynamicExpression;
    }

    public Map<String, Object> getExampleData() {
        return this.exampleData;
    }

    public void setExampleData(Map<String, Object> exampleData) {
        this.exampleData = exampleData;
    }

    public int getExampleIndex() {
        return this.exampleIndex;
    }

    public String toString() {
        return this.feature.toString() + this.getRefId();
    }

    public URI getUriToLineNumber() {
        return URI.create(String.valueOf(this.feature.getResource().getUri()) + "?line=" + this.line);
    }

    public boolean isSetup() {
        return this.getTags() == null ? false : this.getTags().stream().map(Tag::getName).anyMatch(t -> t.equals("setup"));
    }
}

